/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.dependency;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.uber.okbuck.core.dependency.DependencyUtils;
import com.uber.okbuck.core.dependency.OResolvedDependency;
import com.uber.okbuck.core.dependency.VersionlessDependency;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import com.uber.okbuck.extension.JetifierExtension;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExcludeRule;

public class OExternalDependency {
    private static final String SOURCE_FILE = "-sources.jar";
    private final OResolvedDependency base;
    private final Path cachePath;
    private boolean enableJetifier;
    private Set<OExternalDependency> dependencies = new HashSet<OExternalDependency>();
    private Set<ExcludeRule> excludeRules = new HashSet<ExcludeRule>();
    private boolean firstLevel = false;
    public static Comparator<OExternalDependency> compareByName = (o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.getTargetPath()), (Comparable)((Object)o2.getTargetPath())).compare((Comparable)((Object)o1.getPackaging()), (Comparable)((Object)o2.getPackaging())).compare((Comparable)((Object)o1.getTargetName()), (Comparable)((Object)o2.getTargetName())).result();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OExternalDependency)) {
            return false;
        }
        OExternalDependency that = (OExternalDependency)o;
        return Objects.equals(this.base, that.base);
    }

    public String getMavenCoordsForValidation() {
        return this.base.getMavenCoordsForValidation();
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public String toString() {
        return this.base.toString();
    }

    public String getGroup() {
        return this.getVersionless().group();
    }

    public String getName() {
        return this.getVersionless().name();
    }

    public VersionlessDependency getVersionless() {
        return this.base.versionless();
    }

    public Dependency getAsGradleDependency() {
        return this.base.asGradleDependency();
    }

    public String getVersion() {
        return this.base.version();
    }

    public File getRealDependencyFile() {
        return this.base.realDependencyFile();
    }

    public Optional<File> getRealSourceFile() {
        if (this.base.versionless().classifier().isPresent()) {
            return Optional.empty();
        }
        return this.base.realDependencySourceFile();
    }

    public static String getGradleSha(File file) {
        return file.getParentFile().getName();
    }

    public String getPackaging() {
        return this.base.packaging();
    }

    public String getMavenCoords() {
        return this.base.getMavenCoords();
    }

    public String getTargetName() {
        return this.base.targetName() + "." + this.getPackaging();
    }

    public String getBaseTargetName() {
        return this.base.targetName();
    }

    public String getVersionlessTargetName() {
        return this.base.versionlessTargetName() + "." + this.getPackaging();
    }

    public String getTargetPath() {
        return this.cachePath.resolve(this.base.basePath()).toString();
    }

    public String getSourceFileName() {
        return this.getSourceFileNameFrom(this.getDependencyFileName());
    }

    public String getDependencyFileName() {
        return this.getTargetName();
    }

    public boolean enableJetifier() {
        return this.enableJetifier;
    }

    public synchronized void addExcludeRules(Set<ExcludeRule> excludeRules) {
        this.excludeRules.addAll(excludeRules);
    }

    public synchronized void addDeps(Set<OExternalDependency> dependencies) {
        this.dependencies.addAll(dependencies);
    }

    public Set<OExternalDependency> getDeps() {
        return this.dependencies.stream().collect(Collectors.groupingBy(OExternalDependency::getVersionless)).values().stream().map(deps -> {
            Optional<OExternalDependency> matching = deps.stream().filter(d -> {
                if (d.getGroup().equals(this.getGroup())) {
                    return d.getVersion().equals(this.getVersion());
                }
                return false;
            }).findAny();
            return matching.orElseGet(() -> DependencyUtils.lowest(deps));
        }).filter(this::shouldInclude).collect(Collectors.toSet());
    }

    public void updateFirstLevel(boolean firstLevel) {
        this.firstLevel = this.firstLevel || firstLevel;
    }

    public boolean isFirstLevel() {
        return this.firstLevel;
    }

    String getSourceFileNameFrom(String prebuiltName) {
        if (ImmutableList.of((Object)"jar", (Object)"aar").contains((Object)this.getPackaging())) {
            return prebuiltName.replaceFirst("\\.(jar|aar)$", SOURCE_FILE);
        }
        throw new IllegalStateException("Couldn't get sources file name for " + prebuiltName);
    }

    private boolean shouldInclude(OExternalDependency dependency) {
        for (ExcludeRule rule : this.excludeRules) {
            if (rule.getGroup() != null && rule.getModule() != null) {
                return !dependency.getGroup().equals(rule.getGroup()) || !dependency.getName().equals(rule.getModule());
            }
            if (dependency.getGroup().equals(rule.getGroup())) {
                return false;
            }
            if (!dependency.getName().equals(rule.getModule())) continue;
            return false;
        }
        return true;
    }

    protected OExternalDependency(OResolvedDependency resolvedDependency, ExternalDependenciesExtension externalDependenciesExtension, JetifierExtension jetifierExtension) {
        this.base = resolvedDependency;
        this.enableJetifier = jetifierExtension.shouldJetify(resolvedDependency.versionless().group(), resolvedDependency.versionless().name(), this.getPackaging());
        this.cachePath = Paths.get(externalDependenciesExtension.getCache(), new String[0]);
    }

    public static Set<OExternalDependency> filterAar(Set<OExternalDependency> dependencies) {
        return dependencies.stream().filter(dependency -> dependency.getPackaging().equals("aar")).collect(Collectors.toSet());
    }

    public static Set<OExternalDependency> filterJar(Set<OExternalDependency> dependencies) {
        return dependencies.stream().filter(dependency -> dependency.getPackaging().equals("jar")).collect(Collectors.toSet());
    }
}

