/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.dependency;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.uber.okbuck.core.dependency.$AutoValue_OResolvedDependency;
import com.uber.okbuck.core.dependency.VersionlessDependency;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;

@AutoValue
public abstract class OResolvedDependency {
    public static final String AAR = "aar";
    public static final String JAR = "jar";
    private static final String NAME_DELIMITER = "-";

    public abstract VersionlessDependency versionless();

    public abstract String version();

    public abstract File realDependencyFile();

    public abstract Optional<File> realDependencySourceFile();

    abstract boolean isVersioned();

    public static Builder builder() {
        return new $AutoValue_OResolvedDependency.Builder();
    }

    public final String toString() {
        return this.getMavenCoords() + " -> " + this.realDependencyFile().toString();
    }

    @Memoized
    public String getMavenCoords() {
        return this.versionless().group() + ":" + this.versionless().name() + ":" + this.packaging() + this.versionless().classifier().map(c -> ":" + c).orElse("") + ":" + this.version();
    }

    @Memoized
    String getMavenCoordsForValidation() {
        return this.versionless().group() + ":" + this.versionless().name() + ":" + this.version();
    }

    @Memoized
    public String packaging() {
        return FilenameUtils.getExtension((String)this.realDependencyFile().getName());
    }

    @Memoized
    public String targetName() {
        StringBuilder targetName = new StringBuilder(this.versionless().name());
        if (this.isVersioned()) {
            targetName.append(NAME_DELIMITER).append(this.version());
        }
        targetName.append(this.versionless().classifier().map(c -> NAME_DELIMITER + c).orElse(""));
        return targetName.toString();
    }

    @Memoized
    public String versionlessTargetName() {
        return this.versionless().name() + this.versionless().classifier().map(c -> NAME_DELIMITER + c).orElse("");
    }

    @Memoized
    Path basePath() {
        return Paths.get(this.versionless().group().replace('.', File.separatorChar), new String[0]);
    }

    @Memoized
    Dependency asGradleDependency() {
        DefaultExternalModuleDependency externalDependency = new DefaultExternalModuleDependency(this.versionless().group(), this.versionless().name(), this.version());
        externalDependency.setTransitive(false);
        Optional<String> classifier = this.versionless().classifier();
        if (classifier.isPresent()) {
            DefaultDependencyArtifact artifact = new DefaultDependencyArtifact(externalDependency.getName(), this.packaging(), this.packaging(), classifier.get(), null);
            externalDependency.addArtifact((DependencyArtifact)artifact);
        }
        return externalDependency;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setVersionless(VersionlessDependency var1);

        public abstract Builder setVersion(String var1);

        public abstract Builder setIsVersioned(boolean var1);

        public abstract Builder setRealDependencyFile(File var1);

        public abstract Builder setRealDependencySourceFile(Optional<File> var1);

        public abstract OResolvedDependency build();
    }
}

