/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.dependency.exporter;

import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codehaus.plexus.util.StringUtils;
import org.gradle.api.artifacts.ExternalDependency;

public class DependencyExporterModel {
    @Nullable
    private final String name;
    @Nullable
    private final String version;
    @Nullable
    private final String group;
    private final boolean force;
    @Nullable
    private Set<String> excludeRules = new TreeSet<String>();

    public DependencyExporterModel(ExternalDependency externalDependency) {
        this.name = externalDependency.getName();
        this.version = externalDependency.getVersion();
        this.group = externalDependency.getGroup();
        this.force = externalDependency.isForce();
        if (externalDependency.getExcludeRules() != null) {
            this.excludeRules = externalDependency.getExcludeRules().stream().map(e -> {
                if (StringUtils.isNotBlank((String)e.getGroup()) && StringUtils.isNotBlank((String)e.getModule())) {
                    return String.format("%s:%s", e.getGroup(), e.getModule());
                }
                if (StringUtils.isNotBlank((String)e.getGroup())) {
                    return e.getGroup();
                }
                if (StringUtils.isNotBlank((String)e.getModule())) {
                    return e.getModule();
                }
                return null;
            }).collect(Collectors.toSet());
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public boolean isForce() {
        return this.force;
    }

    @Nullable
    public Set<String> getExcludeRules() {
        return this.excludeRules;
    }
}

