/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.manager;

import com.google.common.base.Preconditions;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.OkBuckExtension;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public final class BuckManager {
    private static final String BUCK_BINARY_LOCATION = ".okbuck/workspace/buck_binary";
    private static final String BUCK_BINARY_CONFIGURATION = "buckBinary";
    private static final String JITPACK_URL = "https://jitpack.io";
    private final Project rootProject;
    @Nullable
    private Path realBuckBinaryPath;

    public BuckManager(Project rootProject) {
        this.rootProject = rootProject;
    }

    public void setupBuckBinary() {
        OkBuckExtension okbuckExt = ProjectUtil.getOkBuckExtension(this.rootProject);
        if (okbuckExt.buckBinary != null) {
            Configuration buckConfig = (Configuration)this.rootProject.getConfigurations().maybeCreate(BUCK_BINARY_CONFIGURATION);
            this.rootProject.getRepositories().maven(mavenArtifactRepository -> mavenArtifactRepository.setUrl((Object)JITPACK_URL));
            this.rootProject.getDependencies().add(BUCK_BINARY_CONFIGURATION, (Object)(BuckManager.getJavaVersion() == 11 ? okbuckExt.buckBinaryJava11 : okbuckExt.buckBinary));
            Set resolvedFiles = buckConfig.getResolvedConfiguration().getFiles();
            Preconditions.checkArgument((resolvedFiles.size() == 1 ? 1 : 0) != 0);
            this.realBuckBinaryPath = ((File)resolvedFiles.iterator().next()).toPath();
        }
    }

    public void finalizeDependencies() {
        Path buckBinaryCache = this.rootProject.file((Object)BUCK_BINARY_LOCATION).toPath();
        FileUtil.deleteQuietly(buckBinaryCache);
        if (this.realBuckBinaryPath != null) {
            Path linkedBinaryPath = buckBinaryCache.resolve(this.realBuckBinaryPath.getFileName());
            linkedBinaryPath.getParent().toFile().mkdirs();
            FileUtil.symlink(linkedBinaryPath, this.realBuckBinaryPath);
        }
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

