/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.manager;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.uber.okbuck.composer.common.BazelHttpFileRuleComposer;
import com.uber.okbuck.composer.common.HttpFileRuleComposer;
import com.uber.okbuck.composer.java.JavaAnnotationProcessorRuleComposer;
import com.uber.okbuck.composer.java.LocalPrebuiltRuleComposer;
import com.uber.okbuck.composer.java.PrebuiltRuleComposer;
import com.uber.okbuck.core.annotation.AnnotationProcessorCache;
import com.uber.okbuck.core.dependency.DependencyFactory;
import com.uber.okbuck.core.dependency.DependencyUtils;
import com.uber.okbuck.core.dependency.LocalOExternalDependency;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.dependency.VersionlessDependency;
import com.uber.okbuck.core.dependency.exporter.DependencyExporter;
import com.uber.okbuck.core.manager.BuckFileManager;
import com.uber.okbuck.core.model.base.Scope;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectCache;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import com.uber.okbuck.extension.JetifierExtension;
import com.uber.okbuck.extension.OkBuckExtension;
import com.uber.okbuck.template.common.BazelFunctionRule;
import com.uber.okbuck.template.core.Rule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;

public class DependencyManager {
    private final Project project;
    private final ExternalDependenciesExtension externalDependenciesExtension;
    private final JetifierExtension jetifierExtension;
    private final BuckFileManager buckFileManager;
    private final Set<ExternalDependency> rawDependencies = new HashSet<ExternalDependency>();
    private final SetMultimap<VersionlessDependency, OExternalDependency> originalDependencyMap = LinkedHashMultimap.create();
    private final HashMap<VersionlessDependency, Boolean> skipPrebuiltDependencyMap = new HashMap();
    private final HashMap<String, String> sha256Cache;
    private final DependencyExporter dependencyExporter;

    public DependencyManager(Project rootProject, OkBuckExtension okBuckExtension, BuckFileManager buckFileManager, DependencyExporter dependencyExporter) {
        this.project = rootProject;
        this.externalDependenciesExtension = okBuckExtension.getExternalDependenciesExtension();
        this.jetifierExtension = okBuckExtension.getJetifierExtension();
        this.buckFileManager = buckFileManager;
        this.dependencyExporter = dependencyExporter;
        this.sha256Cache = DependencyManager.initSha256Cache(rootProject, this.externalDependenciesExtension);
    }

    public synchronized void addRawDependencies(Set<ExternalDependency> dependencies) {
        this.rawDependencies.addAll(dependencies);
    }

    public synchronized void addDependency(OExternalDependency dependency, boolean skipPrebuilt) {
        VersionlessDependency versionless = dependency.getVersionless();
        this.originalDependencyMap.put((Object)versionless, (Object)dependency);
        if (this.skipPrebuiltDependencyMap.containsKey(versionless)) {
            this.skipPrebuiltDependencyMap.put(versionless, this.skipPrebuiltDependencyMap.get(versionless) != false && skipPrebuilt);
        } else {
            this.skipPrebuiltDependencyMap.put(versionless, skipPrebuilt);
        }
    }

    public void resolveCurrentRawDeps() {
        if (!this.externalDependenciesExtension.resoleOnlyThirdParty()) {
            return;
        }
        Map<String, List<ExternalDependency>> rawDepsMap = this.rawDependencies.stream().collect(Collectors.groupingBy(i -> i.getGroup() + "--" + i.getVersion()));
        ArrayList allProjects = new ArrayList(this.project.getAllprojects());
        int numberOfChunks = allProjects.size();
        List chunksRawDepsMap = rawDepsMap.keySet().stream().collect(Collectors.groupingBy(key -> Math.abs(key.hashCode()) % numberOfChunks)).values().stream().map(chunk -> chunk.stream().collect(Collectors.toMap(key -> key, rawDepsMap::get))).collect(Collectors.toList());
        IntStream.range(0, allProjects.size()).parallel().forEach(i -> DependencyManager.resolveDepsWithProject((Project)allProjects.get(i), (Map)chunksRawDepsMap.get(i)));
    }

    private static void resolveDepsWithProject(Project project, Map<String, List<ExternalDependency>> depsMap) {
        if (project != project.getRootProject()) {
            ProjectCache.initScopeCache(project);
        }
        for (Map.Entry<String, List<ExternalDependency>> e : depsMap.entrySet()) {
            Configuration config = (Configuration)project.getConfigurations().maybeCreate("resolve__" + e.getKey().replace(".", "__").replace(":", "__"));
            config.getDependencies().addAll((Collection)e.getValue());
            Scope.builder(project).configuration(config).build();
        }
        if (project != project.getRootProject()) {
            ProjectCache.resetScopeCache(project);
        }
    }

    public void finalizeDependencies(OkBuckExtension okBuckExtension) {
        this.dependencyExporter.export(this.rawDependencies);
        Map<VersionlessDependency, Collection<OExternalDependency>> filteredDependencyMap = this.filterDependencies();
        this.validateDependencies(filteredDependencyMap);
        this.updateDependencies(filteredDependencyMap);
        this.processDependencies(filteredDependencyMap, okBuckExtension);
        DependencyManager.persistSha256Cache(this.project, this.sha256Cache, this.externalDependenciesExtension);
    }

    private Map<VersionlessDependency, Collection<OExternalDependency>> filterDependencies() {
        Map dependencies = this.originalDependencyMap.asMap();
        if (this.externalDependenciesExtension.shouldMarkFirstLevelAllVersions()) {
            dependencies.values().forEach(value -> {
                boolean firstLevel = value.stream().anyMatch(OExternalDependency::isFirstLevel);
                value.forEach(externalDependency -> externalDependency.updateFirstLevel(firstLevel));
            });
        }
        if (!this.externalDependenciesExtension.useLatest()) {
            return dependencies;
        }
        ImmutableMap.Builder filteredDependencyMapBuilder = ImmutableMap.builder();
        ImmutableList.Builder dependenciesToResolveBuilder = ImmutableList.builder();
        dependencies.forEach((key, value) -> {
            if (value.size() == 1) {
                filteredDependencyMapBuilder.put(key, value);
            } else if (this.externalDependenciesExtension.useLatest((VersionlessDependency)key)) {
                dependenciesToResolveBuilder.addAll((Iterable)value);
            } else {
                filteredDependencyMapBuilder.put(key, value);
            }
        });
        this.resolved((Collection<OExternalDependency>)dependenciesToResolveBuilder.build()).forEach(externalDependency -> filteredDependencyMapBuilder.put((Object)externalDependency.getVersionless(), (Object)ImmutableList.of((Object)externalDependency)));
        return filteredDependencyMapBuilder.build();
    }

    private Set<OExternalDependency> resolved(Collection<OExternalDependency> externalDependencies) {
        Configuration detached = this.project.getConfigurations().detachedConfiguration((Dependency[])externalDependencies.stream().map(OExternalDependency::getAsGradleDependency).toArray(Dependency[]::new));
        return DependencyUtils.resolveExternal(this.project, detached, this.externalDependenciesExtension, this.jetifierExtension);
    }

    private void validateDependencies(Map<VersionlessDependency, Collection<OExternalDependency>> dependencyMap) {
        if (this.externalDependenciesExtension.versionlessEnabled()) {
            Joiner.MapJoiner mapJoiner = Joiner.on((String)",\n").withKeyValueSeparator("=");
            Map extraDependencies = dependencyMap.entrySet().stream().filter(entry -> ((Collection)entry.getValue()).size() > 1).filter(entry -> !this.externalDependenciesExtension.isVersioned((VersionlessDependency)entry.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.groupingBy(dependency -> dependency.getVersionless().mavenCoords(), Collectors.mapping(OExternalDependency::getVersion, Collectors.toSet())));
            if (extraDependencies.size() > 0) {
                throw new IllegalStateException("Multiple versions found for external dependencies: \n" + mapJoiner.join(extraDependencies));
            }
            Map singleDependencies = dependencyMap.values().stream().filter(externalDependencies -> externalDependencies.size() == 1).flatMap(Collection::stream).filter(dependency -> this.externalDependenciesExtension.isVersioned(dependency.getVersionless())).collect(Collectors.groupingBy(dependency -> dependency.getVersionless().mavenCoords(), Collectors.mapping(OExternalDependency::getVersion, Collectors.toSet())));
            if (singleDependencies.size() > 0) {
                throw new IllegalStateException("Single version found for external dependencies, please remove them from external dependency extension: \n" + mapJoiner.join(singleDependencies));
            }
        }
    }

    private void updateDependencies(Map<VersionlessDependency, Collection<OExternalDependency>> dependencyMap) {
        ExternalDependenciesExtension extension = ProjectUtil.getExternalDependencyExtension(this.project);
        if (!extension.versionlessExportedDepsEnabled()) {
            return;
        }
        Configuration config = (Configuration)this.project.getConfigurations().create("okbuckDependencyResolver");
        config.getDependencies().addAll(this.rawDependencies);
        ResolvedConfiguration resolvedConfiguration = config.getResolvedConfiguration();
        if (resolvedConfiguration.hasError()) {
            resolvedConfiguration.rethrowFailure();
        }
        resolvedConfiguration.getLenientConfiguration().getAllModuleDependencies().forEach(rDependency -> {
            List oExternal = DependencyFactory.fromDependency(rDependency).stream().peek(it -> {
                if (!dependencyMap.containsKey(it)) {
                    DependencyManager.dependencyException(rDependency);
                }
            }).map(dependencyMap::get).collect(Collectors.toList());
            boolean firstLevel = rDependency.getParents().stream().anyMatch(parent -> parent.getParents().size() == 0);
            oExternal.stream().flatMap(Collection::stream).forEach(external -> external.updateFirstLevel(firstLevel));
            Set<OExternalDependency> childDependencies = DependencyManager.childDependencies(rDependency, dependencyMap);
            if (childDependencies.size() == 0) {
                return;
            }
            oExternal.stream().map(dependencies -> {
                Preconditions.checkArgument((dependencies.size() == 1 ? 1 : 0) != 0, (Object)("Dependency having multiple versions can't have deps: m" + dependencies));
                return (OExternalDependency)dependencies.stream().findAny().get();
            }).forEach(dependency -> dependency.addDeps(childDependencies));
        });
    }

    private static Set<OExternalDependency> childDependencies(ResolvedDependency rDependency, Map<VersionlessDependency, Collection<OExternalDependency>> dependencyMap) {
        return rDependency.getChildren().stream().map(cDependency -> DependencyFactory.fromDependency(cDependency).stream().peek(it -> {
            if (!dependencyMap.containsKey(it)) {
                DependencyManager.dependencyException(cDependency);
            }
        }).map(dependencyMap::get).map(dependencies -> {
            Preconditions.checkArgument((dependencies.size() == 1 ? 1 : 0) != 0, (Object)("Child dependencies can't have multiple versions: " + dependencies));
            return (OExternalDependency)dependencies.stream().findAny().get();
        }).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static void dependencyException(ResolvedDependency dependency) {
        throw new IllegalStateException("Couldn't find " + dependency + " child of parents -> " + dependency.getParents() + " in final resolved deps.");
    }

    private void processDependencies(Map<VersionlessDependency, Collection<OExternalDependency>> dependencyMap, OkBuckExtension okBuckExtension) {
        Path rootPath = this.project.getRootDir().toPath();
        File cacheDir = rootPath.resolve(this.externalDependenciesExtension.getCache()).toFile();
        FileUtil.deleteQuitelyAndCreate(cacheDir, this.externalDependenciesExtension.shouldCleanCacheDir(), okBuckExtension.buildFileName);
        Map<Path, List<OExternalDependency>> groupToDependencyMap = dependencyMap.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(dependency -> rootPath.resolve(dependency.getTargetPath())));
        AnnotationProcessorCache annotationProcessorCache = ProjectUtil.getAnnotationProcessorCache(this.project);
        Map<Path, List<Scope>> basePathToScopeMap = annotationProcessorCache.getBasePathToExternalDependencyScopeMap();
        ImmutableList.Builder bazelDependencies = ImmutableList.builder();
        groupToDependencyMap.forEach((basePath, dependencies) -> {
            ImmutableList.Builder localPrebuiltDependencies = ImmutableList.builder();
            ImmutableList.Builder prebuiltDependencies = ImmutableList.builder();
            ImmutableList.Builder httpFileDependencies = ImmutableList.builder();
            if (this.externalDependenciesExtension.shouldDownloadInBuck()) {
                dependencies.forEach(dependency -> {
                    if (dependency instanceof LocalOExternalDependency) {
                        localPrebuiltDependencies.add(dependency);
                    } else if (this.isPrebuiltDependency((OExternalDependency)dependency)) {
                        prebuiltDependencies.add(dependency);
                        bazelDependencies.add(dependency);
                    } else {
                        httpFileDependencies.add(dependency);
                        bazelDependencies.add(dependency);
                    }
                });
            } else {
                localPrebuiltDependencies.addAll((Iterable)dependencies);
            }
            DependencyManager.preComputeSha256((List<OExternalDependency>)prebuiltDependencies.build(), this.sha256Cache);
            DependencyManager.preComputeSha256((List<OExternalDependency>)httpFileDependencies.build(), this.sha256Cache);
            ImmutableList.Builder rulesBuilder = ImmutableList.builder();
            rulesBuilder.addAll(LocalPrebuiltRuleComposer.compose((Collection<OExternalDependency>)localPrebuiltDependencies.build()));
            rulesBuilder.addAll(PrebuiltRuleComposer.compose((Collection<OExternalDependency>)prebuiltDependencies.build(), this.sha256Cache));
            rulesBuilder.addAll(HttpFileRuleComposer.compose((Collection<OExternalDependency>)httpFileDependencies.build(), this.sha256Cache));
            List scopeList = (List)basePathToScopeMap.get(basePath);
            if (scopeList != null) {
                rulesBuilder.addAll(JavaAnnotationProcessorRuleComposer.compose(scopeList));
            }
            this.buckFileManager.writeToBuckFile((List<Rule>)rulesBuilder.build(), basePath.resolve(okBuckExtension.buildFileName).toFile());
            DependencyManager.createSymlinks(basePath, (Collection<OExternalDependency>)localPrebuiltDependencies.build());
        });
        if (okBuckExtension.getExternalDependenciesExtension().bazelDepsEnabled()) {
            ImmutableList.Builder bazelRulesBuilder = ImmutableList.builder();
            bazelRulesBuilder.add((Object)new BazelFunctionRule());
            bazelRulesBuilder.addAll(BazelHttpFileRuleComposer.compose((Collection<OExternalDependency>)bazelDependencies.build(), this.sha256Cache));
            this.buckFileManager.writeToBuckFile("", cacheDir.toPath().resolve(okBuckExtension.buildFileName).toFile(), false);
            File defsBzl = cacheDir.toPath().resolve("defs.bzl").toFile();
            this.buckFileManager.writeToBuckFile((List<Rule>)bazelRulesBuilder.build(), defsBzl);
            this.buckFileManager.writeToBuckFile("\n", defsBzl, true);
        }
    }

    private boolean isPrebuiltDependency(OExternalDependency dependency) {
        return this.skipPrebuiltDependencyMap.getOrDefault(dependency.getVersionless(), false) == false && (dependency.getPackaging().equals("aar") || dependency.getPackaging().equals("jar"));
    }

    private static void createSymlinks(Path path, Collection<OExternalDependency> dependencies) {
        if (!path.toFile().exists() && !path.toFile().mkdirs()) {
            throw new IllegalStateException(String.format("Couldn't create %s when creating symlinks", path));
        }
        SetMultimap nameToDependencyMap = MultimapBuilder.hashKeys().hashSetValues().build();
        dependencies.forEach(dependency -> nameToDependencyMap.put((Object)dependency.getVersionless(), dependency));
        dependencies.forEach(dependency -> {
            FileUtil.symlink(path.resolve(dependency.getDependencyFileName()), dependency.getRealDependencyFile().toPath());
            dependency.getRealSourceFile().ifPresent(file -> FileUtil.symlink(path.resolve(dependency.getSourceFileName()), file.toPath()));
        });
    }

    private static void preComputeSha256(List<OExternalDependency> dependencies, HashMap<String, String> sha256Map) {
        dependencies.forEach(dependency -> {
            DependencyManager.computeSha256IfAbsent(dependency.getRealDependencyFile(), sha256Map);
            Optional<File> sourcesFile = dependency.getRealSourceFile();
            sourcesFile.ifPresent(file -> DependencyManager.computeSha256IfAbsent(file, sha256Map));
        });
    }

    private static void computeSha256IfAbsent(File file, HashMap<String, String> sha256Map) {
        String key = OExternalDependency.getGradleSha(file);
        sha256Map.computeIfAbsent(key, k -> DependencyUtils.shaSum256(file));
    }

    private static HashMap<String, String> initSha256Cache(Project rootProject, ExternalDependenciesExtension externalDependenciesExtension) {
        File projectMappingFile = rootProject.file((Object)externalDependenciesExtension.getSha256Cache());
        try {
            return FileUtil.readMapFromJsonFile(projectMappingFile);
        }
        catch (IOException e) {
            return new HashMap<String, String>();
        }
    }

    private static void persistSha256Cache(Project rootProject, HashMap<String, String> sha256Map, ExternalDependenciesExtension externalDependenciesExtension) {
        File projectMappingFile = rootProject.file((Object)externalDependenciesExtension.getSha256Cache());
        try {
            FileUtil.persistMapToJsonFile(sha256Map, projectMappingFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

