/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.manager;

import com.google.common.collect.ImmutableList;
import com.uber.okbuck.composer.base.BuckRuleComposer;
import com.uber.okbuck.core.dependency.DependencyCache;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.manager.BuckFileManager;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.OkBuckExtension;
import com.uber.okbuck.template.config.groovy.GroovyBuckFile;
import com.uber.okbuck.template.config.groovy.Groovyc;
import com.uber.okbuck.template.config.groovy.StartGroovy;
import com.uber.okbuck.template.core.Rule;
import groovy.lang.GroovySystem;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public final class GroovyManager {
    private static final String GROOVY_DEPS_CONFIG = "okbuck_groovy_deps";
    public static final String GROOVY_HOME_LOCATION = ".okbuck/workspace/groovy_installation";
    public static final String GROOVY_HOME = "groovy_home";
    public static final String GROOVY_HOME_TARGET = "//.okbuck/workspace/groovy_installation:groovy_home";
    private static String groovyVersion = GroovySystem.getVersion();
    private final Project rootProject;
    private final BuckFileManager buckFileManager;
    @Nullable
    private Set<OExternalDependency> dependencies;

    public GroovyManager(Project rootProject, BuckFileManager buckFileManager) {
        this.rootProject = rootProject;
        this.buckFileManager = buckFileManager;
    }

    public void setupGroovyHome() {
        Configuration groovyConfig = (Configuration)this.rootProject.getConfigurations().maybeCreate(GROOVY_DEPS_CONFIG);
        this.rootProject.getDependencies().add(GROOVY_DEPS_CONFIG, (Object)("org.codehaus.groovy:groovy:" + groovyVersion));
        this.dependencies = new DependencyCache(this.rootProject, ProjectUtil.getDependencyManager(this.rootProject)).build(groovyConfig);
    }

    public void finalizeDependencies(OkBuckExtension okBuckExtension) {
        File groovyHome = this.rootProject.file((Object)GROOVY_HOME_LOCATION);
        FileUtil.deleteQuietly(groovyHome.toPath());
        if (this.dependencies != null && this.dependencies.size() > 0) {
            groovyHome.mkdirs();
            File groovyStarterConf = new File(groovyHome, "groovy-starter.conf");
            FileUtil.copyResourceToProject("groovy/conf/groovy-starter.conf", groovyStarterConf);
            File groovyc = new File(groovyHome, "groovyc");
            new Groovyc().groovyVersion(groovyVersion).render(groovyc);
            groovyc.setExecutable(true);
            File startGroovy = new File(groovyHome, "startGroovy");
            new StartGroovy().groovyVersion(groovyVersion).render(startGroovy);
            startGroovy.setExecutable(true);
            OExternalDependency groovyAll = this.dependencies.iterator().next();
            Object groovyHomeRule = new GroovyBuckFile().groovyAllJar(BuckRuleComposer.external(groovyAll)).groovyVersion(groovyVersion).name(GROOVY_HOME);
            this.buckFileManager.writeToBuckFile((List<Rule>)ImmutableList.of(groovyHomeRule), groovyHome.toPath().resolve(okBuckExtension.buildFileName).toFile());
        }
    }
}

