/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.manager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sun.istack.Nullable;
import com.uber.okbuck.composer.base.BuckRuleComposer;
import com.uber.okbuck.core.dependency.DependencyCache;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.manager.BuckFileManager;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.OkBuckExtension;
import com.uber.okbuck.template.core.Rule;
import com.uber.okbuck.template.java.NativePrebuilt;
import com.uber.okbuck.template.jvm.JvmBinaryRule;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JetifierManager {
    private static final Logger LOG = LoggerFactory.getLogger(JetifierManager.class);
    private static final String JETIFIER_LOCATION = ".okbuck/workspace/jetifier";
    private static final String JETIFIER_DEPS_CONFIG = "okbuck_jetifier_deps";
    private static final String JETIFIER_GROUP = "com.android.tools.build.jetifier";
    private static final String JETIFIER_CLI_CLASS = "com.android.tools.build.jetifier.standalone.Main";
    private static final String JETIFIER_BINARY_RULE_NAME = "okbuck_jetifier";
    private static final String COMMONS_CLI_DEP = "commons-cli:commons-cli:1.3.1";
    private static final ImmutableList<String> JETIFIER_MODULES = ImmutableList.of((Object)"jetifier-core", (Object)"jetifier-processor");
    private static final ImmutableList<String> INTERNAL_MODULES = ImmutableList.of((Object)"jetifier-standalone.jar");
    @Nullable
    private Set<OExternalDependency> dependencies;
    private final Project project;
    private final BuckFileManager buckFileManager;

    public JetifierManager(Project project, BuckFileManager buckFileManager) {
        this.project = project;
        this.buckFileManager = buckFileManager;
    }

    public static boolean isJetifierEnabled(Project project) {
        Object prop = project.findProperty("android.enableJetifier");
        return prop != null ? Boolean.valueOf((String)prop) : false;
    }

    public void setupJetifier(String version) {
        if (!version.equals("1.0.0-beta03")) {
            LOG.warn("Using jetifier version other than %s; This might result in problems with the tool", (Object)"1.0.0-beta03");
        }
        Configuration jetifierConfig = (Configuration)this.project.getConfigurations().maybeCreate(JETIFIER_DEPS_CONFIG);
        DependencyHandler handler = this.project.getDependencies();
        JETIFIER_MODULES.stream().map(module -> String.format("%s:%s:%s", JETIFIER_GROUP, module, version)).forEach(dependency -> handler.add(JETIFIER_DEPS_CONFIG, dependency));
        handler.add(JETIFIER_DEPS_CONFIG, (Object)COMMONS_CLI_DEP);
        this.dependencies = new DependencyCache(this.project, ProjectUtil.getDependencyManager(this.project)).build(jetifierConfig);
    }

    public void finalizeDependencies(OkBuckExtension okBuckExtension) {
        Path jetifierCache = this.project.file((Object)JETIFIER_LOCATION).toPath();
        FileUtil.deleteQuietly(jetifierCache);
        if (this.dependencies != null && this.dependencies.size() > 0) {
            jetifierCache.toFile().mkdirs();
            ImmutableList.Builder rulesBuilder = new ImmutableList.Builder();
            ImmutableSet.Builder binaryDependencies = ImmutableSet.builder();
            binaryDependencies.addAll(BuckRuleComposer.external(this.dependencies));
            for (String module : INTERNAL_MODULES) {
                FileUtil.copyResourceToProject("jetifier/" + module, new File(jetifierCache.toFile(), module));
                rulesBuilder.add(((Rule)((Object)new NativePrebuilt().prebuiltType((String)RuleType.PREBUILT_JAR.getProperties().get(0)).prebuilt(module).ruleType(RuleType.PREBUILT_JAR.getBuckName()))).name(module));
                binaryDependencies.add((Object)(":" + module));
            }
            rulesBuilder.add(((Rule)((Object)((Rule)((Object)((Rule)((Object)new JvmBinaryRule().mainClassName(JETIFIER_CLI_CLASS).deps((Collection)binaryDependencies.build()))).ruleType(RuleType.JAVA_BINARY.getBuckName()))).name(JETIFIER_BINARY_RULE_NAME))).defaultVisibility());
            if (okBuckExtension.getJetifierExtension().customConfigFile != null) {
                File configFile = this.project.file((Object)Paths.get(okBuckExtension.getJetifierExtension().customConfigFile, new String[0]));
                String relativeConfigPath = FileUtil.getRelativePath(this.project.getRootProject().getProjectDir(), configFile);
                ProjectUtil.getPlugin((Project)this.project.getRootProject()).exportedPaths.add(relativeConfigPath);
            }
            this.buckFileManager.writeToBuckFile((List<Rule>)rulesBuilder.build(), this.project.getRootProject().file((Object)(".okbuck/workspace/jetifier/" + okBuckExtension.buildFileName)));
        }
    }
}

