/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.manager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.composer.base.BuckRuleComposer;
import com.uber.okbuck.core.dependency.DependencyCache;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.manager.BuckFileManager;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.template.core.Rule;
import com.uber.okbuck.template.java.NativePrebuilt;
import com.uber.okbuck.template.jvm.JvmBinaryRule;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public final class LintManager {
    private static final String LINT_DEPS_CACHE = ".okbuck/workspace/lint";
    private static final String LINT_BINARY_RULE_NAME = "okbuck_lint";
    private static final String LINT_DUMMY_JAR = "lint-dummy.jar";
    private static final String LINT_GROUP = "com.android.tools.lint";
    private static final String LINT_MODULE = "lint";
    private static final String LINT_DEPS_CONFIG = "buckLint_deps";
    private static final ImmutableSet<String> LINT_BINARY_EXCLUDES = ImmutableSet.of((Object)"META-INF/.*\\\\.SF", (Object)"META-INF/.*\\\\.DSA", (Object)"META-INF/.*\\\\.RSA");
    private static final String LINT_CLI_CLASS = "com.uber.okbuck.android.lint.AndroidLintCli";
    private static final String ANDROID_LINT_CLI_JAR = "android-lint-cli.jar";
    private static final String ANDROID_LINT_CLI_RULE_NAME = "android-lint-cli";
    private final Project project;
    private final String lintBuckFile;
    private final BuckFileManager buckFileManager;
    private Set<OExternalDependency> dependencies;
    private DependencyCache lintDepCache;

    public LintManager(Project project, String lintBuckFile, BuckFileManager buckFileManager) {
        this.project = project;
        this.lintBuckFile = lintBuckFile;
        this.buckFileManager = buckFileManager;
    }

    @Nullable
    public static String getDefaultLintVersion(Project buckProject) {
        return ProjectUtil.findVersionInClasspath(buckProject, LINT_GROUP, LINT_MODULE);
    }

    public void fetchLintDeps(String version) {
        this.project.getConfigurations().maybeCreate(LINT_DEPS_CONFIG);
        this.project.getDependencies().add(LINT_DEPS_CONFIG, (Object)("com.android.tools.lint:lint:" + version));
        this.getLintDepsCache();
    }

    public DependencyCache getLintDepsCache() {
        if (this.lintDepCache == null) {
            this.lintDepCache = new DependencyCache(this.project, ProjectUtil.getDependencyManager(this.project));
            this.dependencies = this.lintDepCache.build(this.project.getRootProject().getConfigurations().getByName(LINT_DEPS_CONFIG));
        }
        return this.lintDepCache;
    }

    public void finalizeDependencies() {
        Path lintCache = this.project.file((Object)LINT_DEPS_CACHE).toPath();
        FileUtil.deleteQuietly(lintCache);
        if (this.dependencies != null && this.dependencies.size() > 0) {
            lintCache.toFile().mkdirs();
            ((Rule)((Object)((Rule)((Object)new JvmBinaryRule().mainClassName("").excludes((Set)LINT_BINARY_EXCLUDES).defaultVisibility())).name(LINT_BINARY_RULE_NAME))).ruleType(RuleType.JAVA_BINARY.getBuckName());
            ImmutableList.Builder rulesBuilder = new ImmutableList.Builder();
            Set<String> stringDependencies = BuckRuleComposer.external(this.dependencies);
            stringDependencies.add(":android-lint-cli");
            rulesBuilder.add(((Rule)((Object)((Rule)((Object)((Rule)((Object)new JvmBinaryRule().excludes((Set)LINT_BINARY_EXCLUDES).mainClassName(LINT_CLI_CLASS).deps(stringDependencies))).ruleType(RuleType.JAVA_BINARY.getBuckName()))).name(LINT_BINARY_RULE_NAME))).defaultVisibility());
            rulesBuilder.add(((Rule)((Object)new NativePrebuilt().prebuiltType((String)RuleType.PREBUILT_JAR.getProperties().get(0)).prebuilt(ANDROID_LINT_CLI_JAR).ruleType(RuleType.PREBUILT_JAR.getBuckName()))).name(ANDROID_LINT_CLI_RULE_NAME));
            rulesBuilder.add(((Rule)((Object)new NativePrebuilt().prebuiltType((String)RuleType.PREBUILT_JAR.getProperties().get(0)).prebuilt(LINT_DUMMY_JAR).ruleType(RuleType.PREBUILT_JAR.getBuckName()))).name(LINT_DUMMY_JAR));
            FileUtil.copyResourceToProject("lint/android-lint-cli.jar", new File(lintCache.toFile(), ANDROID_LINT_CLI_JAR));
            FileUtil.copyResourceToProject("lint/lint-dummy.jar", new File(lintCache.toFile(), LINT_DUMMY_JAR));
            this.buckFileManager.writeToBuckFile((List<Rule>)rulesBuilder.build(), this.project.getRootProject().file((Object)this.lintBuckFile));
        }
    }
}

