/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.composer.base.BuckRuleComposer;
import com.uber.okbuck.core.dependency.DependencyCache;
import com.uber.okbuck.core.manager.BuckFileManager;
import com.uber.okbuck.core.model.android.AndroidAppTarget;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.model.base.Scope;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.OkBuckExtension;
import com.uber.okbuck.template.core.Rule;
import com.uber.okbuck.template.java.NativePrebuilt;
import com.uber.okbuck.template.jvm.JvmBinaryRule;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.api.Project;

public final class TransformManager {
    private static final String TRANSFORM_CACHE = ".okbuck/workspace/transform";
    public static final String TRANSFORM_RULE = "//.okbuck/workspace/transform:okbuck_transform";
    public static final String CONFIGURATION_TRANSFORM = "transform";
    private static final String TRANSFORM_FOLDER = "transform/";
    private static final String TRANSFORM_JAR = "transform-cli-1.1.0.jar";
    private static final String TRANSFORM_JAR_RULE = "//.okbuck/workspace/transform:transform-cli-1.1.0.jar";
    private static final String OPT_TRANSFORM_CLASS = "transform";
    private static final String OPT_CONFIG_FILE = "configFile";
    private static final String PREFIX = "java -Dokbuck.inJarsDir=$IN_JARS_DIR -Dokbuck.outJarsDir=$OUT_JARS_DIR -Dokbuck.androidBootClasspath=$ANDROID_BOOTCLASSPATH ";
    private static final String SUFFIX = "-cp $(location //.okbuck/workspace/transform:okbuck_transform) com.uber.okbuck.transform.CliTransform; ";
    private static final String OKBUCK_TRANSFORM_TARGET_NAME = "okbuck_transform";
    private static final String BINARY_EXCLUDES = "META-INF";
    private final Project rootProject;
    private final BuckFileManager buckFileManager;
    @Nullable
    private ImmutableSet<String> dependencies;

    public TransformManager(Project rootProject, BuckFileManager buckFileManager) {
        this.rootProject = rootProject;
        this.buckFileManager = buckFileManager;
    }

    public void fetchTransformDeps() {
        DependencyCache dependencyCache = new DependencyCache(this.rootProject, ProjectUtil.getDependencyManager(this.rootProject));
        Scope transformScope = Scope.builder(this.rootProject).configuration("transform").depCache(dependencyCache).build();
        this.dependencies = new ImmutableSet.Builder().addAll(BuckRuleComposer.targets(transformScope.getTargetDeps())).addAll(BuckRuleComposer.external(transformScope.getExternalDeps())).add((Object)TRANSFORM_JAR_RULE).build();
    }

    public void finalizeDependencies(OkBuckExtension okBuckExtension) {
        if (this.dependencies != null && this.dependencies.size() > 0) {
            Path cacheDir = this.rootProject.file((Object)TRANSFORM_CACHE).toPath();
            FileUtil.deleteQuietly(cacheDir);
            cacheDir.toFile().mkdirs();
            TransformManager.copyFiles(cacheDir);
            this.composeBuckFile(cacheDir, okBuckExtension.buildFileName);
        }
    }

    private static void copyFiles(Path cacheDir) {
        FileUtil.copyResourceToProject("transform/transform-cli-1.1.0.jar", new File(cacheDir.toFile(), TRANSFORM_JAR));
    }

    private void composeBuckFile(Path cacheDir, String buildFileName) {
        ImmutableList.Builder rulesBuilder = new ImmutableList.Builder();
        if (this.dependencies != null) {
            rulesBuilder.add(((Rule)((Object)new NativePrebuilt().prebuiltType((String)RuleType.PREBUILT_JAR.getProperties().get(0)).prebuilt(TRANSFORM_JAR).ruleType(RuleType.PREBUILT_JAR.getBuckName()))).name(TRANSFORM_JAR)).add(((Rule)((Object)((Rule)((Object)((Rule)((Object)new JvmBinaryRule().excludes(Collections.singleton(BINARY_EXCLUDES)).deps((Collection)this.dependencies))).ruleType(RuleType.JAVA_BINARY.getBuckName()))).name(OKBUCK_TRANSFORM_TARGET_NAME))).defaultVisibility());
        }
        this.buckFileManager.writeToBuckFile((List<Rule>)rulesBuilder.build(), cacheDir.resolve(buildFileName).toFile());
    }

    public Pair<String, List<String>> getBashCommandAndTransformDeps(AndroidAppTarget target) {
        List results = target.getTransforms().stream().map(it -> TransformManager.getBashCommandAndTransformDeps(target, it)).collect(Collectors.toList());
        return Pair.of((Object)String.join((CharSequence)" ", results.stream().map(Pair::getLeft).collect(Collectors.toList())), results.stream().map(Pair::getRight).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static Pair<String, String> getBashCommandAndTransformDeps(AndroidAppTarget target, Map<String, String> options) {
        String transformClass = options.get("transform");
        String configFile = options.get(OPT_CONFIG_FILE);
        StringBuilder bashCmd = new StringBuilder(PREFIX);
        String configFileRule = null;
        if (transformClass != null) {
            bashCmd.append("-Dokbuck.transformClass=").append(transformClass).append(" ");
        }
        if (configFile != null) {
            configFileRule = TransformManager.getTransformConfigRuleForFile(target.getProject(), target.getRootProject().file((Object)configFile));
            bashCmd.append("-Dokbuck.configFile=$(location ").append(configFileRule).append(") ");
        }
        bashCmd.append(SUFFIX);
        return Pair.of((Object)bashCmd.toString(), (Object)configFileRule);
    }

    private static String getTransformConfigRuleForFile(Project project, File config) {
        String relativeConfigPath = FileUtil.getRelativePath(project.getRootProject().getProjectDir(), config);
        ProjectUtil.getPlugin((Project)project.getRootProject()).exportedPaths.add(relativeConfigPath);
        if (project.getProjectDir().equals(config.getParentFile())) {
            return ":" + config.getName();
        }
        String configTarget = BuckRuleComposer.fileRule(relativeConfigPath);
        Preconditions.checkNotNull((Object)configTarget);
        return configTarget;
    }
}

