/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.android;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.SigningConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.model.android.AndroidAppInstrumentationTarget;
import com.uber.okbuck.core.model.android.AndroidInstrumentationTarget;
import com.uber.okbuck.core.model.android.AndroidLibTarget;
import com.uber.okbuck.core.model.android.ExoPackageScope;
import com.uber.okbuck.core.model.android.Keystore;
import com.uber.okbuck.core.model.base.Target;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.TestExtension;
import com.uber.okbuck.extension.TransformExtension;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public class AndroidAppTarget
extends AndroidLibTarget {
    private static final int DEFAULT_LINEARALLOC_LIMIT = 0x1000000;
    private final boolean multidexEnabled;
    @Nullable
    private final Keystore keystore;
    private final Set<String> cpuFilters;
    private final int linearAllocHardLimit;
    private final List<String> primaryDexPatterns;
    private final List<String> exoPackageDependencies;
    private final File proguardMappingFile;
    private final boolean minifyEnabled;
    private final Map<String, Object> placeholders = new LinkedHashMap<String, Object>();
    private final boolean includesVectorDrawables;
    @Nullable
    private final AndroidAppInstrumentationTarget appInstrumentationTarget;

    public AndroidAppTarget(Project project, String name, boolean isTest) {
        super(project, name, isTest);
        this.minifyEnabled = this.getBaseVariant().getBuildType().isMinifyEnabled();
        this.keystore = this.extractKeystore();
        Set abiFilters = this.getAndroidExtension().getSplits().getAbiFilters();
        this.cpuFilters = abiFilters != null ? abiFilters : ImmutableSet.of();
        this.multidexEnabled = Optional.ofNullable(this.getBaseVariant().getBuildType().getMultiDexEnabled()).orElse(Optional.ofNullable(this.getBaseVariant().getMergedFlavor().getMultiDexEnabled()).orElse(false));
        this.primaryDexPatterns = (List)this.getProp(this.getOkbuck().primaryDexPatterns, ImmutableList.of());
        this.linearAllocHardLimit = this.getProp(this.getOkbuck().linearAllocHardLimit, 0x1000000);
        this.exoPackageDependencies = (List)this.getProp(this.getOkbuck().appLibDependencies, ImmutableList.of());
        this.proguardMappingFile = this.getProp(this.getOkbuck().proguardMappingFile, null);
        this.placeholders.put("applicationId", this.getApplicationIdWithSuffix());
        this.placeholders.putAll(this.getBaseVariant().getBuildType().getManifestPlaceholders());
        this.placeholders.putAll(this.getBaseVariant().getMergedFlavor().getManifestPlaceholders());
        this.includesVectorDrawables = this.getAndroidExtension().getDefaultConfig().getVectorDrawables().getUseSupportLibrary();
        TestExtension testExtension = this.getOkbuck().getTestExtension();
        this.appInstrumentationTarget = testExtension.espresso && this.getInstrumentationTestVariant() != null ? new AndroidAppInstrumentationTarget(project, AndroidInstrumentationTarget.getInstrumentationTargetName(name)) : null;
    }

    public AndroidAppTarget(Project project, String name) {
        this(project, name, false);
    }

    @Override
    protected BaseVariant getBaseVariant() {
        AppExtension appExtension = (AppExtension)this.getAndroidExtension();
        Optional<ApplicationVariant> optionalBaseVariant = appExtension.getApplicationVariants().stream().filter(variant -> variant.getName().equals(this.getName())).findFirst();
        Preconditions.checkArgument((boolean)optionalBaseVariant.isPresent());
        return (BaseVariant)optionalBaseVariant.get();
    }

    @Override
    public Set<OExternalDependency> getApiExternalDeps() {
        return ImmutableSet.of();
    }

    @Override
    public Set<Target> getApiTargetDeps() {
        return ImmutableSet.of();
    }

    @Override
    public boolean shouldGenerateBuildConfig() {
        return true;
    }

    @Nullable
    public ExoPackageScope getExopackage() {
        if (this.getProp(this.getOkbuck().exopackage, false).booleanValue()) {
            return new ExoPackageScope(this.getProject(), this.getMain(), this.exoPackageDependencies, this.getExoManifest());
        }
        return null;
    }

    @Nullable
    public String getProguardConfig() {
        if (this.minifyEnabled) {
            ImmutableSet proguardFiles = new ImmutableSet.Builder().addAll((Iterable)this.getBaseVariant().getMergedFlavor().getProguardFiles()).addAll((Iterable)this.getBaseVariant().getBuildType().getProguardFiles()).build();
            Preconditions.checkArgument((proguardFiles.size() == 1 ? 1 : 0) != 0, (String)"%s proguard files found. Only one can be used.", (int)proguardFiles.size());
            File proguardFile = (File)proguardFiles.iterator().next();
            Preconditions.checkArgument((boolean)proguardFile.exists(), (String)"Proguard file %s does not exist", (Object)proguardFile);
            return FileUtil.getRelativePath(this.getProject().getRootDir(), proguardFile);
        }
        return null;
    }

    @Nullable
    public String getProguardMapping() {
        if (!this.minifyEnabled || this.proguardMappingFile == null || !this.proguardMappingFile.exists()) {
            return null;
        }
        return FileUtil.getRelativePath(this.getProject().getRootDir(), this.proguardMappingFile);
    }

    public List<Map<String, String>> getTransforms() {
        TransformExtension transform = this.getOkbuck().getTransformExtension();
        return (List)this.getProp(transform.transforms, ImmutableList.of());
    }

    @Override
    public String getPackage() {
        return this.getOriginalPackage();
    }

    @Nullable
    private Keystore extractKeystore() {
        SigningConfig config;
        SigningConfig mergedConfig = this.getBaseVariant().getMergedFlavor().getSigningConfig();
        SigningConfig signingConfig = config = mergedConfig != null ? mergedConfig : this.getBaseVariant().getBuildType().getSigningConfig();
        if (config != null) {
            String keystoreFilePath = FileUtil.getRelativePath(this.getRootProject().getProjectDir(), config.getStoreFile());
            ProjectUtil.getPlugin((Project)this.getProject()).exportedPaths.add(keystoreFilePath);
            return Keystore.create(keystoreFilePath, config.getStorePassword(), config.getKeyAlias(), config.getKeyPassword());
        }
        return null;
    }

    @Nullable
    private String getExoManifest() {
        String mainManifest = this.getMainManifest();
        List<String> secondaryManifests = this.getSecondaryManifests();
        if (secondaryManifests != null) {
            Optional<String> optionalExoManifest = secondaryManifests.stream().filter(manifest -> manifest.contains("/" + this.getName() + "/")).findAny();
            return optionalExoManifest.orElse(mainManifest);
        }
        return mainManifest;
    }

    public final boolean getMultidexEnabled() {
        return this.multidexEnabled;
    }

    @Nullable
    public final Keystore getKeystore() {
        return this.keystore;
    }

    public final Set<String> getCpuFilters() {
        return this.cpuFilters;
    }

    public final int getLinearAllocHardLimit() {
        return this.linearAllocHardLimit;
    }

    public final List<String> getPrimaryDexPatterns() {
        return this.primaryDexPatterns;
    }

    public final boolean getMinifyEnabled() {
        return this.minifyEnabled;
    }

    public final Map<String, Object> getPlaceholders() {
        return this.placeholders;
    }

    public final boolean getIncludesVectorDrawables() {
        return this.includesVectorDrawables;
    }

    @Nullable
    public final AndroidAppInstrumentationTarget getAppInstrumentationTarget() {
        return this.appInstrumentationTarget;
    }
}

