/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.android;

import com.uber.okbuck.core.annotation.AnnotationProcessorCache;
import com.uber.okbuck.core.model.android.AndroidAppTarget;
import com.uber.okbuck.core.model.base.Scope;
import com.uber.okbuck.core.util.ProjectUtil;
import java.util.List;
import org.gradle.api.Project;

public abstract class AndroidInstrumentationTarget
extends AndroidAppTarget {
    private static final String KAPT_ANDROID_TEST = "kaptAndroidTest";

    protected AndroidInstrumentationTarget(Project project, String name) {
        super(project, name, true);
    }

    @Override
    public List<Scope> getAptScopes() {
        AnnotationProcessorCache apCache = ProjectUtil.getAnnotationProcessorCache(this.getProject());
        if (this.getIsKapt()) {
            return apCache.getAnnotationProcessorScopes(this.getProject(), KAPT_ANDROID_TEST);
        }
        return apCache.getAnnotationProcessorScopes(this.getProject(), this.getBaseVariant().getAnnotationProcessorConfiguration());
    }

    @Override
    public Scope getApt() {
        if (this.getIsKapt()) {
            return this.getAptScopeForConfiguration(KAPT_ANDROID_TEST);
        }
        return this.getAptScopeForConfiguration(this.getBaseVariant().getAnnotationProcessorConfiguration());
    }

    @Override
    public Scope getProvided() {
        return Scope.builder(this.getProject()).configuration(this.getBaseVariant().getCompileConfiguration()).build();
    }

    @Override
    public Scope getMain() {
        return Scope.builder(this.getProject()).configuration(this.getBaseVariant().getRuntimeConfiguration()).sourceDirs(this.getSources(this.getBaseVariant())).javaResourceDirs(this.getJavaResources(this.getBaseVariant())).customOptions("extra_arguments", AndroidInstrumentationTarget.getJavaCompilerOptions(this.getBaseVariant())).customOptions("extra_kotlinc_arguments", this.getKotlinCompilerOptions()).customOptions(this.getKotlinFriendPaths(false)).customOptions("kotlinc_plugins", this.getKotlinCompilerPlugins()).build();
    }

    @Override
    public Scope getTest() {
        return Scope.builder(this.getProject()).build();
    }

    static String getMainTargetName(String name) {
        return name.replaceFirst("_test$", "");
    }

    static String getInstrumentationTargetName(String name) {
        return name + "_test";
    }
}

