/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.android;

import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.google.common.base.Preconditions;
import com.uber.okbuck.core.model.android.AndroidInstrumentationTarget;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;

public class AndroidLibInstrumentationTarget
extends AndroidInstrumentationTarget {
    AndroidLibInstrumentationTarget(Project project, String name) {
        super(project, name);
    }

    @Override
    protected BaseVariant getBaseVariant() {
        return this.getLibraryVariant().getTestVariant();
    }

    @Override
    Map<String, String> getResVariantDirs() {
        HashMap<String, String> variantDirs = new HashMap<String, String>();
        this.getLibraryVariant().getSourceSets().forEach(provider -> this.getAvailable(provider.getResDirectories()).forEach(dir -> variantDirs.put((String)dir, provider.getName())));
        return variantDirs;
    }

    private LibraryVariant getLibraryVariant() {
        LibraryExtension libraryExtension = (LibraryExtension)this.getAndroidExtension();
        DomainObjectSet libraryVariants = libraryExtension.getLibraryVariants().matching(libraryVariant -> libraryVariant.getName().equals(AndroidLibInstrumentationTarget.getMainTargetName(this.getName())));
        Preconditions.checkArgument((libraryVariants.size() > 0 ? 1 : 0) != 0);
        return (LibraryVariant)libraryVariants.iterator().next();
    }
}

