/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.android;

import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.core.model.android.AndroidInstrumentationTarget;
import com.uber.okbuck.core.model.android.AndroidLibInstrumentationTarget;
import com.uber.okbuck.core.model.android.AndroidTarget;
import com.uber.okbuck.core.model.base.ProjectType;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.TestExtension;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public class AndroidLibTarget
extends AndroidTarget {
    @Nullable
    private final AndroidLibInstrumentationTarget libInstrumentationTarget;

    public AndroidLibTarget(Project project, String name) {
        this(project, name, false);
    }

    public AndroidLibTarget(Project project, String name, boolean isTest) {
        super(project, name, isTest);
        TestExtension testExtension = this.getOkbuck().getTestExtension();
        this.libInstrumentationTarget = testExtension.espressoForLibraries && this.getInstrumentationTestVariant() != null && ProjectUtil.getType(project).equals((Object)ProjectType.ANDROID_LIB) ? new AndroidLibInstrumentationTarget(project, AndroidInstrumentationTarget.getInstrumentationTargetName(name)) : null;
    }

    @Override
    protected BaseVariant getBaseVariant() {
        LibraryExtension libraryExtension = (LibraryExtension)this.getAndroidExtension();
        Optional<LibraryVariant> baseVariantOptional = libraryExtension.getLibraryVariants().stream().filter(variant -> variant.getName().equals(this.getName())).findFirst();
        Preconditions.checkArgument((boolean)baseVariantOptional.isPresent());
        return (BaseVariant)baseVariantOptional.get();
    }

    public boolean shouldGenerateBuildConfig() {
        return this.getOkbuck().libraryBuildConfig;
    }

    @Nullable
    public String getConsumerProguardConfig() {
        ImmutableSet consumerProguardFiles = new ImmutableSet.Builder().addAll((Iterable)this.getBaseVariant().getMergedFlavor().getConsumerProguardFiles()).addAll((Iterable)this.getBaseVariant().getBuildType().getConsumerProguardFiles()).build();
        if (consumerProguardFiles.size() > 0) {
            Optional optionalFile = consumerProguardFiles.stream().findFirst();
            return FileUtil.getRelativePath(this.getProject().getProjectDir(), (File)optionalFile.get());
        }
        return null;
    }

    @Nullable
    public final AndroidLibInstrumentationTarget getLibInstrumentationTarget() {
        return this.libInstrumentationTarget;
    }
}

