/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.android;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.builder.model.ClassField;
import com.android.builder.model.LintOptions;
import com.android.builder.model.SourceProvider;
import com.facebook.infer.annotation.Initializer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.core.annotation.AnnotationProcessorCache;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.model.base.Scope;
import com.uber.okbuck.core.model.jvm.JvmTarget;
import com.uber.okbuck.core.model.jvm.TestOptions;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.core.util.XmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.kotlin.gradle.internal.AndroidExtensionsExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinAndroidPluginWrapper;
import org.w3c.dom.Document;

public abstract class AndroidTarget
extends JvmTarget {
    private static final String KOTLIN_EXTENSIONS_OPTION = "plugin:org.jetbrains.kotlin.android:";
    private static final String DEFAULT_SDK = "1";
    private final String applicationId;
    private final String applicationIdSuffix;
    private final String minSdk;
    private final String targetSdk;
    private final boolean debuggable;
    private final boolean generateR2;
    private final boolean isKotlinAndroid;
    private final boolean isKapt;
    private final boolean hasKotlinAndroidExtensions;
    private final boolean hasExperimentalKotlinAndroidExtensions;
    private final boolean lintExclude;
    private final boolean testExclude;
    private final boolean isTest;
    @Nullable
    private String mainManifest;
    @Nullable
    private List<String> secondaryManifests;
    @Nullable
    private String originalPackageName;
    @Nullable
    private String resourceUnionPackageName;
    @Nullable
    private final String versionName;
    @Nullable
    private final Integer versionCode;

    protected AndroidTarget(Project project, String name, boolean isTest) {
        super(project, name);
        boolean hasKotlinExtension;
        this.isTest = isTest;
        this.applicationIdSuffix = Strings.nullToEmpty((String)this.getBaseVariant().getMergedFlavor().getApplicationIdSuffix()) + Strings.nullToEmpty((String)this.getBaseVariant().getBuildType().getApplicationIdSuffix());
        if (isTest) {
            String applicationIdString = AndroidTarget.minus(AndroidTarget.minus(this.getBaseVariant().getApplicationId(), ".test"), this.applicationIdSuffix);
            this.applicationId = AndroidTarget.minus(applicationIdString, this.applicationIdSuffix);
        } else {
            this.applicationId = AndroidTarget.minus(this.getBaseVariant().getApplicationId(), this.applicationIdSuffix);
        }
        this.versionName = this.getBaseVariant().getMergedFlavor().getVersionName();
        this.versionCode = this.getBaseVariant().getMergedFlavor().getVersionCode();
        this.debuggable = this.getBaseVariant().getBuildType().isDebuggable();
        this.generateR2 = project.getPlugins().hasPlugin("com.jakewharton.butterknife");
        this.isKotlinAndroid = project.getPlugins().hasPlugin(KotlinAndroidPluginWrapper.class);
        this.isKapt = project.getPlugins().hasPlugin("kotlin-kapt");
        this.hasKotlinAndroidExtensions = project.getPlugins().hasPlugin("kotlin-android-extensions");
        this.lintExclude = ((List)this.getProp(this.getOkbuck().lintExclude, ImmutableList.of())).contains(name);
        this.testExclude = ((List)this.getProp(this.getOkbuck().testExclude, ImmutableList.of())).contains(name);
        this.resourceUnionPackageName = this.getOkbuck().resourceUnionPackage;
        try {
            AndroidExtensionsExtension androidExtensions = (AndroidExtensionsExtension)project.getExtensions().getByType(AndroidExtensionsExtension.class);
            hasKotlinExtension = this.hasKotlinAndroidExtensions && androidExtensions.isExperimental();
        }
        catch (Exception ignored) {
            hasKotlinExtension = false;
        }
        this.hasExperimentalKotlinAndroidExtensions = hasKotlinExtension;
        if (this.getBaseVariant().getMergedFlavor().getMinSdkVersion() == null || this.getBaseVariant().getMergedFlavor().getTargetSdkVersion() == null) {
            this.targetSdk = DEFAULT_SDK;
            this.minSdk = DEFAULT_SDK;
            throw new IllegalStateException("module `" + project.getName() + "` must specify minSdkVersion and targetSdkVersion in build.gradle");
        }
        this.minSdk = this.getBaseVariant().getMergedFlavor().getMinSdkVersion().getApiString();
        this.targetSdk = this.getBaseVariant().getMergedFlavor().getTargetSdkVersion().getApiString();
    }

    protected AndroidTarget(Project project, String name) {
        this(project, name, false);
    }

    protected abstract BaseVariant getBaseVariant();

    @Override
    public Scope getMain() {
        return Scope.builder(this.getProject()).configuration(this.getBaseVariant().getRuntimeConfiguration()).sourceDirs(this.getSources(this.getBaseVariant())).javaResourceDirs(this.getJavaResources(this.getBaseVariant())).customOptions("extra_arguments", AndroidTarget.getJavaCompilerOptions(this.getBaseVariant())).customOptions("extra_kotlinc_arguments", this.getKotlinCompilerOptions()).customOptions(this.getKotlinFriendPaths(false)).customOptions("kotlinc_plugins", this.getKotlinCompilerPlugins()).build();
    }

    @Override
    public Scope getTest() {
        Scope.Builder builder = Scope.builder(this.getProject());
        UnitTestVariant unitTestVariant = this.getUnitTestVariant();
        if (unitTestVariant != null) {
            builder.configuration(unitTestVariant.getRuntimeConfiguration());
            builder.sourceDirs(this.getSources((BaseVariant)unitTestVariant));
            builder.javaResourceDirs(this.getJavaResources((BaseVariant)unitTestVariant));
            builder.customOptions("extra_arguments", AndroidTarget.getJavaCompilerOptions((BaseVariant)unitTestVariant));
            builder.customOptions("extra_kotlinc_arguments", this.getKotlinCompilerOptions());
            builder.customOptions(this.getKotlinFriendPaths(true));
            builder.customOptions("kotlinc_plugins", this.getKotlinCompilerPlugins());
        }
        return builder.build();
    }

    @Override
    public List<Scope> getAptScopes() {
        Configuration configuration = this.getAptConfigurationFromVariant(this.getBaseVariant());
        AnnotationProcessorCache apCache = ProjectUtil.getAnnotationProcessorCache(this.getProject());
        return configuration != null ? apCache.getAnnotationProcessorScopes(this.getProject(), configuration) : ImmutableList.of();
    }

    @Override
    public List<Scope> getTestAptScopes() {
        Configuration configuration = this.getAptConfigurationFromVariant((BaseVariant)this.getUnitTestVariant());
        AnnotationProcessorCache apCache = ProjectUtil.getAnnotationProcessorCache(this.getProject());
        return configuration != null ? apCache.getAnnotationProcessorScopes(this.getProject(), configuration) : ImmutableList.of();
    }

    @Override
    public Scope getApt() {
        Configuration configuration = this.getAptConfigurationFromVariant(this.getBaseVariant());
        return configuration != null ? this.getAptScopeForConfiguration(configuration) : Scope.builder(this.getProject()).build();
    }

    @Override
    public Scope getTestApt() {
        Configuration configuration = this.getAptConfigurationFromVariant((BaseVariant)this.getUnitTestVariant());
        return configuration != null ? this.getAptScopeForConfiguration(configuration) : Scope.builder(this.getProject()).build();
    }

    @Override
    public Scope getProvided() {
        return Scope.builder(this.getProject()).configuration(this.getBaseVariant().getCompileConfiguration()).build();
    }

    @Override
    public Scope getTestProvided() {
        return Scope.builder(this.getProject()).configuration(this.getUnitTestVariant() != null ? this.getUnitTestVariant().getCompileConfiguration() : null).build();
    }

    @Override
    public LintOptions getLintOptions() {
        return this.getAndroidExtension().getLintOptions();
    }

    public boolean getRobolectricEnabled() {
        return this.getOkbuck().getTestExtension().robolectric && !this.testExclude;
    }

    public boolean getLintEnabled() {
        return !this.getOkbuck().getLintExtension().disabled && !this.lintExclude;
    }

    @Override
    public String getSourceCompatibility() {
        return JvmTarget.javaVersion(this.getAndroidExtension().getCompileOptions().getSourceCompatibility());
    }

    @Override
    public String getTargetCompatibility() {
        return JvmTarget.javaVersion(this.getAndroidExtension().getCompileOptions().getTargetCompatibility());
    }

    @Override
    public TestOptions getTestOptions() {
        String testTaskName = "test" + StringUtils.capitalize((String)this.getName()) + "UnitTest";
        ImmutableList testTasks = ImmutableList.copyOf((Collection)this.getProject().getTasks().withType(Test.class));
        Optional<Test> optionalTest = testTasks.stream().filter(test -> test.getName().equals(testTaskName)).findFirst();
        List jvmArgs = optionalTest.map(Test::getAllJvmArgs).orElseGet(Collections::emptyList);
        Map env = optionalTest.map(Test::getEnvironment).orElseGet(Collections::emptyMap);
        System.getenv().keySet().forEach(env::remove);
        return new TestOptions(jvmArgs, env);
    }

    public List<String> getBuildConfigFields() {
        ArrayList<String> buildConfig = new ArrayList<String>();
        buildConfig.add(String.format("String APPLICATION_ID = \"%s\"", this.getApplicationIdWithSuffix()));
        buildConfig.add(String.format("String BUILD_TYPE = \"%s\"", this.getBuildType()));
        buildConfig.add(String.format("String FLAVOR = \"%s\"", this.getFlavor()));
        if (this.versionCode != null) {
            buildConfig.add(String.format("int VERSION_CODE = %s", this.versionCode));
        }
        if (this.versionName != null) {
            buildConfig.add(String.format("String VERSION_NAME = \"%s\"", this.versionName));
        }
        HashMap extraBuildConfig = new HashMap();
        extraBuildConfig.putAll(this.getBaseVariant().getMergedFlavor().getBuildConfigFields());
        extraBuildConfig.putAll(this.getBaseVariant().getBuildType().getBuildConfigFields());
        buildConfig.addAll(extraBuildConfig.keySet().stream().sorted().map(key -> {
            ClassField classField = (ClassField)extraBuildConfig.get(key);
            if (classField == null) {
                throw new IllegalStateException("Invalid buildconfig value!");
            }
            return String.format("%s %s = %s", classField.getType(), key, classField.getValue());
        }).collect(Collectors.toList()));
        return buildConfig;
    }

    String getFlavor() {
        return this.getBaseVariant().getFlavorName();
    }

    String getBuildType() {
        return this.getBaseVariant().getBuildType().getName();
    }

    public Set<String> getResDirs() {
        return this.getBaseVariant().getSourceSets().stream().map(i -> this.getAvailable(i.getResDirectories())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nullable
    public String getProjectResDir() {
        SourceProvider main;
        Set<String> mainResDirectories;
        List sourceSets = this.getBaseVariant().getSourceSets();
        if (!sourceSets.isEmpty() && (mainResDirectories = this.getAvailable((main = (SourceProvider)sourceSets.get(0)).getResDirectories())).size() > 0) {
            return mainResDirectories.iterator().next();
        }
        return null;
    }

    Map<String, String> getResVariantDirs() {
        HashMap<String, String> variantDirs = new HashMap<String, String>();
        for (SourceProvider provider : this.getBaseVariant().getSourceSets()) {
            for (String dir : this.getAvailable(provider.getResDirectories())) {
                variantDirs.put(dir, provider.getName());
            }
        }
        return variantDirs;
    }

    public Set<String> getAssetDirs() {
        return this.getBaseVariant().getSourceSets().stream().map(i -> this.getAvailable(i.getAssetsDirectories())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getAidl() {
        return this.getBaseVariant().getSourceSets().stream().map(i -> this.getAvailable(i.getAidlDirectories())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getJniLibs() {
        return this.getBaseVariant().getSourceSets().stream().map(i -> this.getAvailable(i.getJniLibsDirectories())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nullable
    public String getMainManifest() {
        if (this.mainManifest == null) {
            this.ensureManifest();
        }
        return this.mainManifest;
    }

    @Nullable
    public List<String> getSecondaryManifests() {
        return this.secondaryManifests;
    }

    @Initializer
    void ensureManifest() {
        Set manifests = this.getBaseVariant().getSourceSets().stream().map(SourceProvider::getManifestFile).map(file -> this.getAvailable((Collection<File>)ImmutableSet.of((Object)file))).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        if (manifests.isEmpty()) {
            return;
        }
        this.secondaryManifests = new ArrayList<String>(manifests);
        this.mainManifest = this.secondaryManifests.remove(0);
    }

    static List<String> getJavaCompilerOptions(BaseVariant baseVariant) {
        if (baseVariant != null && baseVariant.getJavaCompileProvider() instanceof JavaCompile) {
            List options = ((JavaCompile)baseVariant.getJavaCompileProvider()).getOptions().getCompilerArgs();
            AndroidTarget.filterOptions(options, (List<String>)ImmutableList.of((Object)"-s", (Object)"-processorpath"));
            return options;
        }
        return ImmutableList.of();
    }

    @Override
    protected List<String> getKotlinCompilerPlugins() {
        ImmutableList.Builder pluginBuilder = ImmutableList.builder();
        if (this.getHasKotlinAndroidExtensions()) {
            pluginBuilder.add((Object)"//.okbuck/workspace/kotlin_home:android-extensions-compiler.jar");
        }
        pluginBuilder.addAll(super.getKotlinCompilerPlugins());
        return pluginBuilder.build();
    }

    @Override
    protected List<String> getKotlinCompilerOptions() {
        if (!this.getHasKotlinAndroidExtensions()) {
            return super.getKotlinCompilerOptions();
        }
        ImmutableList.Builder extraKotlincArgs = ImmutableList.builder();
        StringBuilder resDirs = new StringBuilder();
        StringBuilder options = new StringBuilder();
        String module = this.getProject().getPath().replace(":", File.separator).substring(1) + File.separator;
        this.getResVariantDirs().forEach((dir, variant) -> {
            String pathToRes = module + dir;
            resDirs.append(KOTLIN_EXTENSIONS_OPTION);
            resDirs.append("variant=");
            resDirs.append((String)variant);
            resDirs.append(";");
            resDirs.append(pathToRes);
            resDirs.append(",");
        });
        options.append(resDirs.toString());
        options.append(KOTLIN_EXTENSIONS_OPTION);
        options.append("package=");
        options.append(this.getResPackage());
        if (this.getHasExperimentalKotlinAndroidExtensions()) {
            options.append(",");
            options.append(KOTLIN_EXTENSIONS_OPTION);
            options.append("experimental=true");
        }
        extraKotlincArgs.add((Object)"-P");
        extraKotlincArgs.add((Object)options.toString());
        extraKotlincArgs.addAll(super.getKotlinCompilerOptions());
        return extraKotlincArgs.build();
    }

    static void filterOptions(List<String> options, List<String> remove) {
        remove.forEach(key -> {
            int index = options.indexOf(key);
            if (index != -1) {
                options.remove(index + 1);
                options.remove(index);
            }
        });
    }

    @Nullable
    private UnitTestVariant getUnitTestVariant() {
        if (this.getBaseVariant() instanceof TestedVariant) {
            return ((TestedVariant)this.getBaseVariant()).getUnitTestVariant();
        }
        return null;
    }

    @Nullable
    TestVariant getInstrumentationTestVariant() {
        TestVariant testVariant;
        if (this.getBaseVariant() instanceof TestedVariant && (testVariant = ((TestedVariant)this.getBaseVariant()).getTestVariant()) != null) {
            HashSet manifests = new HashSet();
            testVariant.getSourceSets().forEach(provider -> manifests.addAll(this.getAvailable((Collection<File>)ImmutableSet.of((Object)provider.getManifestFile()))));
            return manifests.isEmpty() ? null : testVariant;
        }
        return null;
    }

    public RuleType getRuleType() {
        if (this.isKotlin()) {
            return RuleType.KOTLIN_ANDROID_MODULE;
        }
        return RuleType.ANDROID_MODULE;
    }

    public RuleType getTestRuleType() {
        if (this.isKotlin()) {
            return RuleType.KOTLIN_ROBOLECTRIC_TEST;
        }
        return RuleType.ROBOLECTRIC_TEST;
    }

    public boolean isKotlin() {
        return this.isKotlinAndroid;
    }

    @Nullable
    private Configuration getAptConfigurationFromVariant(@Nullable BaseVariant variant) {
        Configuration configuration = null;
        if (this.isKapt) {
            configuration = this.getProject().getConfigurations().getByName("kapt" + StringUtils.capitalize((String)this.getBaseVariant().getName()));
        } else if (variant != null) {
            configuration = variant.getAnnotationProcessorConfiguration();
        }
        return configuration;
    }

    public BaseExtension getAndroidExtension() {
        return (BaseExtension)this.getProject().getExtensions().getByName("android");
    }

    public Set<File> getSources(BaseVariant variant) {
        ImmutableSet.Builder srcs = new ImmutableSet.Builder();
        Set javaSrcs = variant.getSourceSets().stream().map(SourceProvider::getJavaDirectories).flatMap(Collection::stream).collect(Collectors.toSet());
        srcs.addAll(javaSrcs);
        if (this.isKotlinAndroid) {
            srcs.addAll((Iterable)javaSrcs.stream().filter(i -> i.getName().equals("java")).map(i -> this.getProject().file((Object)i.getAbsolutePath().replaceFirst("/java$", "/kotlin"))).collect(Collectors.toSet()));
        }
        return srcs.build();
    }

    public Set<File> getJavaResources(BaseVariant variant) {
        return variant.getSourceSets().stream().map(SourceProvider::getResourcesDirectories).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    String getOriginalPackage() {
        if (this.originalPackageName == null) {
            Document manifestXml = XmlUtil.loadXml(this.getProject().file((Object)this.getMainManifest()));
            this.originalPackageName = manifestXml.getDocumentElement().getAttribute("package").trim();
        }
        return this.originalPackageName;
    }

    final String getApplicationIdSuffix() {
        return this.applicationIdSuffix;
    }

    final String getApplicationIdBase() {
        return this.applicationId;
    }

    public String getApplicationIdWithSuffix() {
        if (this.getIsTest()) {
            return AndroidTarget.minus(this.getApplicationIdBase(), ".test") + this.getApplicationIdSuffix() + ".test";
        }
        return this.getApplicationIdBase() + this.getApplicationIdSuffix();
    }

    public String getPackage() {
        return this.getApplicationIdBase();
    }

    public String getResPackage() {
        if (this.resourceUnionPackageName != null) {
            return this.resourceUnionPackageName;
        }
        return this.getOriginalPackage();
    }

    public final String getMinSdk() {
        return this.minSdk;
    }

    public final String getTargetSdk() {
        return this.targetSdk;
    }

    public final String getVersionName() {
        return this.versionName == null ? "" : this.versionName;
    }

    public final Integer getVersionCode() {
        return this.versionCode == null ? 0 : this.versionCode;
    }

    public final boolean getDebuggable() {
        return this.debuggable;
    }

    public final boolean getGenerateR2() {
        return this.generateR2;
    }

    final boolean getIsKapt() {
        return this.isKapt;
    }

    final boolean getHasKotlinAndroidExtensions() {
        return this.hasKotlinAndroidExtensions;
    }

    final boolean getHasExperimentalKotlinAndroidExtensions() {
        return this.hasExperimentalKotlinAndroidExtensions;
    }

    public boolean getIsTest() {
        return this.isTest;
    }

    static String minus(String s, String text) {
        int index = s.indexOf(text);
        if (index == -1) {
            return s;
        }
        int end = index + text.length();
        return s.length() > end ? s.substring(0, index) + s.substring(end) : s.substring(0, index);
    }

    @Override
    public <T> T getProp(Map<String, T> map, @Nullable T defaultValue) {
        String nameKey = this.getIdentifier() + StringUtils.capitalize((String)this.getName());
        String flavorKey = this.getIdentifier() + StringUtils.capitalize((String)this.getFlavor());
        String buildTypeKey = this.getIdentifier() + StringUtils.capitalize((String)this.getBuildType());
        if (map.containsKey(nameKey)) {
            return map.get(nameKey);
        }
        if (map.containsKey(flavorKey)) {
            return map.get(flavorKey);
        }
        if (map.containsKey(buildTypeKey)) {
            return map.get(buildTypeKey);
        }
        return map.getOrDefault(this.getIdentifier(), defaultValue);
    }
}

