/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.android;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.model.base.Scope;
import com.uber.okbuck.core.model.base.Target;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.XmlUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExoPackageScope
extends Scope {
    private final Scope base;
    @Nullable
    private final String manifest;

    ExoPackageScope(Project project, Scope base, List<String> exoPackageDependencies, @Nullable String manifest) {
        super(project, null, (Set<File>)ImmutableSet.of(), (Set<File>)ImmutableSet.of(), base.getCustomOptions());
        this.base = base;
        this.manifest = manifest;
        this.extractDependencies(base, exoPackageDependencies);
    }

    @Nullable
    public String getAppClass() {
        Optional<String> optionalAppClass;
        if (this.manifest == null) {
            return null;
        }
        String appClass = null;
        File manifestFile = this.project.file((Object)this.manifest);
        Document manifestXml = XmlUtil.loadXml(manifestFile);
        try {
            NodeList nodeList = manifestXml.getElementsByTagName("application");
            Preconditions.checkArgument((nodeList.getLength() == 1 ? 1 : 0) != 0);
            Element application = (Element)nodeList.item(0);
            appClass = application.getAttribute("android:name").replaceAll("\\.", "/").replaceAll("^/", "");
        }
        catch (Exception nodeList) {
            // empty catch block
        }
        String finalAppClass = appClass;
        if (appClass != null && !appClass.isEmpty() && (optionalAppClass = this.base.getSources().stream().map(sourceDir -> {
            ConfigurableFileTree found = this.project.fileTree((Map)ImmutableMap.of((Object)"dir", (Object)sourceDir, (Object)"includes", (Object)ImmutableList.of((Object)("**/" + finalAppClass + ".java"))));
            try {
                return FileUtil.getRelativePath(this.project.getProjectDir(), found.getSingleFile());
            }
            catch (IllegalStateException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst()).isPresent()) {
            return optionalAppClass.get();
        }
        return finalAppClass;
    }

    private void extractDependencies(Scope base, List<String> exoPackageDependencies) {
        exoPackageDependencies.forEach(exoPackageDep -> {
            boolean qualified;
            String last;
            String first;
            if (exoPackageDep.contains(":")) {
                List parts = Splitter.on((char)':').splitToList((CharSequence)exoPackageDep);
                first = (String)parts.get(0);
                last = (String)parts.get(1);
                qualified = true;
            } else {
                first = last = exoPackageDep;
                qualified = false;
            }
            Optional<OExternalDependency> externalDepOptional = base.getExternalDeps(false).stream().filter(dependency -> {
                if (qualified) {
                    return dependency.getGroup().equals(first) && dependency.getName().equals(last);
                }
                return dependency.getName().equals(last);
            }).findFirst();
            if (externalDepOptional.isPresent()) {
                OExternalDependency externalDependency = externalDepOptional.get();
                this.allExternal.put(externalDependency.getVersionless(), externalDependency);
                this.firstLevelExternal.put(externalDependency.getVersionless(), externalDependency);
            } else {
                Optional<Target> variantDepOptional = base.getTargetDeps(false).stream().filter(variant -> {
                    if (qualified) {
                        return variant.getName().equals(last) && variant.getPath().equals(first);
                    }
                    return variant.getPath().equals(first);
                }).findFirst();
                variantDepOptional.ifPresent(this.allTargetDeps::add);
                variantDepOptional.ifPresent(this.firstLevelTargetDeps::add);
            }
        });
    }
}

