/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.base;

import com.android.build.api.attributes.VariantAttr;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.uber.okbuck.core.annotation.JvmPlugin;
import com.uber.okbuck.core.dependency.DependencyCache;
import com.uber.okbuck.core.dependency.DependencyFactory;
import com.uber.okbuck.core.dependency.DependencyUtils;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.dependency.VersionlessDependency;
import com.uber.okbuck.core.model.base.Target;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectCache;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import com.uber.okbuck.extension.JetifierExtension;
import com.uber.okbuck.extension.OkBuckExtension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.specs.Spec;

public class Scope {
    private final Set<String> javaResources;
    private final Set<String> sources;
    @Nullable
    private final Configuration configuration;
    private final DependencyCache depCache;
    private final Map<String, List<String>> customOptions;
    protected final Project project;
    protected final Set<Target> firstLevelTargetDeps = new HashSet<Target>();
    protected final Map<VersionlessDependency, OExternalDependency> firstLevelExternal = new HashMap<VersionlessDependency, OExternalDependency>();
    protected final Set<Target> allTargetDeps = new HashSet<Target>();
    protected final Map<VersionlessDependency, OExternalDependency> allExternal = new HashMap<VersionlessDependency, OExternalDependency>();
    @Nullable
    private Set<String> annotationProcessors;
    private static final Spec<ComponentIdentifier> PROJECT_FILTER = componentIdentifier -> componentIdentifier instanceof ProjectComponentIdentifier;
    private static final Spec<ComponentIdentifier> EXTERNAL_DEP_FILTER = componentIdentifier -> !(componentIdentifier instanceof ProjectComponentIdentifier);

    public final Set<String> getJavaResources() {
        return this.javaResources;
    }

    public final Set<String> getSources() {
        return this.sources;
    }

    public Map<String, List<String>> getCustomOptions() {
        return this.customOptions;
    }

    Scope(Project project, @Nullable Configuration configuration, Set<File> sourceDirs, Set<File> javaResourceDirs, Map<String, List<String>> customOptions, DependencyCache depCache) {
        this.project = project;
        this.sources = FileUtil.available(project, sourceDirs);
        this.javaResources = FileUtil.available(project, javaResourceDirs);
        this.customOptions = customOptions;
        this.depCache = depCache;
        this.configuration = configuration;
        if (configuration != null) {
            DependencyUtils.enforceChangingDeps(project, configuration);
            this.extractConfiguration(configuration);
        }
    }

    protected Scope(Project project, @Nullable Configuration configuration, Set<File> sourceDirs, Set<File> javaResourceDirs, Map<String, List<String>> customOptions) {
        this(project, configuration, sourceDirs, javaResourceDirs, customOptions, ProjectUtil.getDependencyCache(project));
    }

    public Set<Target> getTargetDeps(boolean firstLevel) {
        if (this.configuration != null && firstLevel) {
            return this.firstLevelTargetDeps;
        }
        return this.allTargetDeps;
    }

    public final Set<Target> getTargetDeps() {
        ExternalDependenciesExtension externalDependenciesExtension = ProjectUtil.getExternalDependencyExtension(this.project);
        return this.getTargetDeps(externalDependenciesExtension.exportedDepsEnabled());
    }

    public Set<OExternalDependency> getExternalDeps(boolean firstLevel) {
        if (this.configuration != null && firstLevel) {
            return new HashSet<OExternalDependency>(this.firstLevelExternal.values());
        }
        return new HashSet<OExternalDependency>(this.allExternal.values());
    }

    public final Set<OExternalDependency> getExternalDeps() {
        OkBuckExtension okBuckExtension = ProjectUtil.getOkBuckExtension(this.project);
        ExternalDependenciesExtension externalDependenciesExtension = okBuckExtension.getExternalDependenciesExtension();
        return this.getExternalDeps(externalDependenciesExtension.exportedDepsEnabled());
    }

    public Set<String> getAnnotationProcessors() {
        if (this.configuration == null) {
            return ImmutableSet.of();
        }
        if (this.annotationProcessors == null) {
            Stream[] streamArray = new Stream[2];
            streamArray[0] = this.getExternalDeps(true).stream().map(this.depCache::getAnnotationProcessors).flatMap(Collection::stream);
            streamArray[1] = this.getTargetDeps(true).stream().map(target -> {
                OkBuckExtension okBuckExtension = target.getOkbuck();
                return (List)target.getProp(okBuckExtension.annotationProcessors, ImmutableList.of());
            }).flatMap(Collection::stream);
            this.annotationProcessors = Streams.concat((Stream[])streamArray).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        }
        return this.annotationProcessors;
    }

    public boolean hasAutoValueExtensions() {
        return this.getExternalDeps().stream().anyMatch(this.depCache::hasAutoValueExtension);
    }

    public JvmPlugin getAnnotationProcessorPlugin() {
        JvmPlugin.Builder jvmPluginBuilder = JvmPlugin.builder();
        Set<OExternalDependency> dependencies = this.getExternalDeps(true);
        if (dependencies.size() > 1) {
            Optional<OExternalDependency> optionalAutoValue = dependencies.stream().filter(dep -> dep.getGroup().equals("com.google.auto.value") && dep.getName().equals("auto-value")).findAny();
            Preconditions.checkArgument((boolean)optionalAutoValue.isPresent(), (String)"Multiple annotation processor dependencies should have auto value %s", dependencies);
            Preconditions.checkNotNull((Object)this.configuration);
            String configurationName = this.configuration.getName();
            OExternalDependency autoValue = optionalAutoValue.get();
            String processorUID = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, configurationName);
            jvmPluginBuilder.setPluginUID(processorUID).setPluginDependency(autoValue);
        } else if (dependencies.size() == 1) {
            OExternalDependency dependency = (OExternalDependency)dependencies.stream().findAny().get();
            jvmPluginBuilder.setPluginUID(dependency.getBaseTargetName()).setPluginDependency(dependency);
        } else {
            Optional<Target> target = this.getTargetDeps(true).stream().findAny();
            String processorUID = ((Target)target.get()).getIdentifier().replace(":", "-");
            jvmPluginBuilder.setPluginUID(processorUID).setPluginTarget(target);
        }
        return jvmPluginBuilder.build();
    }

    private static Set<ResolvedArtifactResult> getArtifacts(Configuration configuration, String value, Spec<ComponentIdentifier> filter) {
        return configuration.getIncoming().artifactView(config -> {
            config.attributes(container -> container.attribute(Attribute.of((String)"artifactType", String.class), (Object)value));
            config.componentFilter(filter);
        }).getArtifacts().getArtifacts();
    }

    private static ImmutableSet<ResolvedArtifactResult> getArtifacts(Configuration configuration, Spec<ComponentIdentifier> filter, ImmutableList<String> artifactTypes) {
        ImmutableSet.Builder artifactResultsBuilder = ImmutableSet.builder();
        artifactTypes.forEach(artifactType -> artifactResultsBuilder.addAll((Iterable)Scope.getArtifacts(configuration, artifactType, filter).stream().filter(it -> !it.getFile().getName().equals("classes.jar")).collect(Collectors.toSet())));
        return artifactResultsBuilder.build();
    }

    private void extractConfiguration(Configuration configuration) {
        DependencyFactory factory = ProjectUtil.getDependencyFactory(this.project);
        ExternalDependenciesExtension externalDependenciesExtension = ProjectUtil.getExternalDependencyExtension(this.project);
        this.depCache.addDependencies(configuration.getAllDependencies());
        if (externalDependenciesExtension.resoleOnlyThirdParty() && configuration.getName().toLowerCase().contains("classpath")) {
            return;
        }
        Set<String> projectFirstLevel = configuration.getAllDependencies().withType(ProjectDependency.class).stream().map(dependency -> dependency.getDependencyProject().getPath()).collect(Collectors.toSet());
        Set<VersionlessDependency> externalFirstLevel = configuration.getAllDependencies().withType(ExternalDependency.class).stream().map(factory::fromDependency).flatMap(Collection::stream).collect(Collectors.toSet());
        Set allModuleDependencies = null;
        if (externalDependenciesExtension.versionedExportedDepsEnabled()) {
            ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
            if (resolvedConfiguration.hasError()) {
                resolvedConfiguration.rethrowFailure();
            }
            Set firstLevelModuleDependencies = resolvedConfiguration.getLenientConfiguration().getFirstLevelModuleDependencies();
            allModuleDependencies = resolvedConfiguration.getLenientConfiguration().getAllModuleDependencies();
            Set directProjectDeps = firstLevelModuleDependencies.stream().map(DependencyUtils::filterProjectDeps).flatMap(Collection::stream).collect(Collectors.toSet());
            projectFirstLevel.addAll(directProjectDeps);
            Set transitiveProjectDeps = allModuleDependencies.stream().filter(DependencyUtils::isExternal).map(ResolvedDependency::getChildren).flatMap(Collection::stream).distinct().map(DependencyUtils::filterProjectDeps).flatMap(Collection::stream).collect(Collectors.toSet());
            projectFirstLevel.addAll(transitiveProjectDeps);
            Set firstLevelExternal = firstLevelModuleDependencies.stream().map(DependencyFactory::fromDependency).flatMap(Collection::stream).collect(Collectors.toSet());
            externalFirstLevel.addAll(firstLevelExternal);
        }
        this.extractConfigurationImpl(configuration, projectFirstLevel, externalFirstLevel);
        if (externalDependenciesExtension.versionedExportedDepsEnabled()) {
            Preconditions.checkNotNull(allModuleDependencies);
            allModuleDependencies.forEach(rDep -> {
                Set<OExternalDependency> childEDeps = DependencyFactory.childrenFromDependency(rDep).stream().map(this.allExternal::get).filter(Objects::nonNull).collect(Collectors.toSet());
                DependencyFactory.fromDependency(rDep).stream().map(this.allExternal::get).filter(Objects::nonNull).forEach(eDep -> eDep.addDeps(childEDeps));
                if (rDep.getModuleArtifacts().size() == 0) {
                    childEDeps.forEach(i -> this.firstLevelExternal.put(i.getVersionless(), (OExternalDependency)i));
                }
            });
            configuration.getAllDependencies().stream().filter(dependency -> dependency instanceof ExternalDependency).map(dependency -> (ExternalDependency)dependency).forEach(dependency -> {
                Set<VersionlessDependency> vDeps = factory.fromDependency((ExternalDependency)dependency);
                vDeps.forEach(vDep -> {
                    OExternalDependency eDep = this.allExternal.getOrDefault(vDep, null);
                    if (eDep != null) {
                        eDep.addExcludeRules(dependency.getExcludeRules());
                    }
                });
            });
        }
        this.firstLevelExternal.values().forEach(external -> external.updateFirstLevel(true));
    }

    private void extractConfigurationImpl(Configuration configuration, Set<String> projectFirstLevel, Set<VersionlessDependency> externalFirstLevel) {
        DependencyFactory factory = ProjectUtil.getDependencyFactory(this.project);
        ImmutableSet<ResolvedArtifactResult> jarArtifacts = Scope.getArtifacts(configuration, PROJECT_FILTER, (ImmutableList<String>)ImmutableList.of((Object)"jar"));
        jarArtifacts.forEach(artifact -> {
            if (!DependencyUtils.isConsumable(artifact.getFile())) {
                return;
            }
            ProjectComponentIdentifier identifier = (ProjectComponentIdentifier)artifact.getId().getComponentIdentifier();
            VariantAttr variantAttr = (VariantAttr)artifact.getVariant().getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
            String variant = variantAttr == null ? null : variantAttr.getName();
            Project identifierProject = this.project.project(identifier.getProjectPath());
            Target target = ProjectCache.getTargetCache(identifierProject).getTargetForVariant(variant);
            this.allTargetDeps.add(target);
            if (projectFirstLevel.contains(identifierProject.getPath())) {
                this.firstLevelTargetDeps.add(target);
            }
        });
        ImmutableSet<ResolvedArtifactResult> aarOrJarArtifacts = Scope.getArtifacts(configuration, EXTERNAL_DEP_FILTER, (ImmutableList<String>)ImmutableList.of((Object)"aar", (Object)"jar"));
        OkBuckExtension okBuckExtension = ProjectUtil.getOkBuckExtension(this.project);
        ExternalDependenciesExtension externalDependenciesExtension = okBuckExtension.getExternalDependenciesExtension();
        JetifierExtension jetifierExtension = okBuckExtension.getJetifierExtension();
        Set<ResolvedArtifactResult> consumableArtifacts = aarOrJarArtifacts.stream().filter(artifact -> DependencyUtils.isConsumable(artifact.getFile())).collect(Collectors.toSet());
        Map<ComponentIdentifier, ResolvedArtifactResult> componentIdToSourcesArtifactMap = ProjectUtil.downloadSources(this.project, consumableArtifacts);
        consumableArtifacts.forEach(artifact -> {
            ComponentIdentifier identifier = artifact.getId().getComponentIdentifier();
            ResolvedArtifactResult sourcesArtifact = (ResolvedArtifactResult)componentIdToSourcesArtifactMap.get(identifier);
            if (identifier instanceof ModuleComponentIdentifier && ((ModuleComponentIdentifier)identifier).getVersion().length() > 0) {
                ModuleComponentIdentifier moduleIdentifier = (ModuleComponentIdentifier)identifier;
                OExternalDependency externalDependency = factory.from(moduleIdentifier.getGroup(), moduleIdentifier.getModule(), moduleIdentifier.getVersion(), artifact.getFile(), sourcesArtifact != null ? sourcesArtifact.getFile() : null, externalDependenciesExtension, jetifierExtension);
                externalDependency = this.depCache.get(externalDependency);
                this.allExternal.put(externalDependency.getVersionless(), externalDependency);
                if (externalFirstLevel.contains(externalDependency.getVersionless())) {
                    this.firstLevelExternal.put(externalDependency.getVersionless(), externalDependency);
                }
            } else {
                String rootProjectPath = this.project.getRootProject().getProjectDir().getAbsolutePath();
                String artifactPath = artifact.getFile().getAbsolutePath();
                try {
                    if (!FilenameUtils.directoryContains((String)rootProjectPath, (String)artifactPath) && !DependencyUtils.isWhiteListed(artifact.getFile())) {
                        throw new IllegalStateException(String.format("Local dependencies should be under project root. Dependencies outside the project can cause hard to reproduce builds. Please move dependency: %s inside %s", artifact.getFile(), this.project.getRootProject().getProjectDir()));
                    }
                    OExternalDependency localExternalDependency = factory.fromLocal(artifact.getFile(), sourcesArtifact != null ? sourcesArtifact.getFile() : null, externalDependenciesExtension, jetifierExtension);
                    localExternalDependency = this.depCache.get(localExternalDependency);
                    this.allExternal.put(localExternalDependency.getVersionless(), localExternalDependency);
                    this.firstLevelExternal.put(localExternalDependency.getVersionless(), localExternalDependency);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope scope = (Scope)o;
        return Objects.equals(this.javaResources, scope.javaResources) && Objects.equals(this.sources, scope.sources) && Objects.equals(this.configuration, scope.configuration) && Objects.equals(this.customOptions, scope.customOptions) && Objects.equals(this.project, scope.project);
    }

    public int hashCode() {
        return Objects.hash(this.javaResources, this.sources, this.configuration, this.customOptions, this.project);
    }

    public static Builder builder(Project project) {
        return new Builder(project);
    }

    public static final class Builder {
        private final Project project;
        private Set<File> javaResourceDirs = ImmutableSet.of();
        private Set<File> sourceDirs = ImmutableSet.of();
        @Nullable
        private Configuration configuration = null;
        private DependencyCache depCache;
        private final Map<String, List<String>> compilerOptions = new LinkedHashMap<String, List<String>>();

        private Builder(Project project) {
            this.project = project;
            this.depCache = ProjectUtil.getDependencyCache(project);
        }

        public Builder javaResourceDirs(Set<File> javaResourceDirs) {
            this.javaResourceDirs = javaResourceDirs;
            return this;
        }

        public Builder sourceDirs(Set<File> sourceDirs) {
            this.sourceDirs = sourceDirs;
            return this;
        }

        public Builder configuration(@Nullable Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder configuration(String configuration) {
            this.configuration = DependencyUtils.useful(configuration, this.project);
            return this;
        }

        public Builder depCache(DependencyCache depCache) {
            this.depCache = depCache;
            return this;
        }

        public Builder customOptions(String key, List<String> values) {
            List existingOptions = this.compilerOptions.computeIfAbsent(key, key1 -> new ArrayList());
            existingOptions.addAll(values);
            return this;
        }

        public Builder customOptions(Map<String, List<String>> options) {
            options.keySet().forEach(key -> {
                List existingOptions = this.compilerOptions.computeIfAbsent((String)key, key1 -> new ArrayList());
                existingOptions.addAll((Collection)options.get(key));
            });
            return this;
        }

        public Scope build() {
            Configuration useful = DependencyUtils.useful(this.configuration);
            String key = useful != null ? useful.getName() : "--none--";
            return ProjectCache.getScopeCache(this.project).computeIfAbsent(key, t -> new Scope(this.project, useful, this.sourceDirs, this.javaResourceDirs, this.compilerOptions, this.depCache));
        }
    }
}

