/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.base;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.OkBuckExtension;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;

public abstract class Target {
    private final Project project;
    private final Project rootProject;
    private final String name;
    private final String identifier;
    private final String path;

    protected Target(Project project, String name) {
        this.project = project;
        this.name = name;
        this.identifier = project.getPath().replaceFirst(":", "");
        this.path = this.identifier.replaceAll(":", File.separator.replace("\\", "\\\\"));
        this.rootProject = project.getRootProject();
    }

    public Project getProject() {
        return this.project;
    }

    public Project getRootProject() {
        return this.rootProject;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getPath() {
        return this.path;
    }

    public OkBuckExtension getOkbuck() {
        return ProjectUtil.getOkBuckExtension(this.project);
    }

    protected Set<String> getAvailable(Collection<File> files) {
        return FileUtil.available(this.project, files);
    }

    protected <T> T getProp(Map<String, T> map, T defaultValue) {
        return map.getOrDefault(this.getIdentifier() + this.getName(), map.getOrDefault(this.getIdentifier(), defaultValue));
    }

    public Collection<String> getExtraOpts(RuleType ruleType) {
        Map propertyMap = (Map)this.getProp(this.getOkbuck().extraBuckOpts, ImmutableMap.of());
        return propertyMap.isEmpty() ? ImmutableSet.of() : propertyMap.computeIfAbsent(ruleType.name().toLowerCase(), k -> ImmutableSet.of());
    }
}

