/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.base;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.google.common.collect.ImmutableMap;
import com.uber.okbuck.core.model.android.AndroidAppTarget;
import com.uber.okbuck.core.model.android.AndroidLibTarget;
import com.uber.okbuck.core.model.base.ProjectType;
import com.uber.okbuck.core.model.base.Target;
import com.uber.okbuck.core.model.jvm.JvmTarget;
import com.uber.okbuck.core.util.ProjectUtil;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public final class TargetCache {
    private final Project project;
    @Nullable
    private Map<String, Target> targets;

    public TargetCache(Project project) {
        this.project = project;
    }

    public synchronized Map<String, Target> getTargets() {
        if (this.targets == null) {
            ProjectType type = ProjectUtil.getType(this.project);
            switch (type) {
                case ANDROID_APP: {
                    this.targets = (Map)((AppExtension)this.project.getExtensions().getByType(AppExtension.class)).getApplicationVariants().stream().collect(ImmutableMap.toImmutableMap(BaseVariant::getName, v -> new AndroidAppTarget(this.project, v.getName())));
                    break;
                }
                case ANDROID_LIB: {
                    this.targets = (Map)((LibraryExtension)this.project.getExtensions().getByType(LibraryExtension.class)).getLibraryVariants().stream().collect(ImmutableMap.toImmutableMap(BaseVariant::getName, v -> new AndroidLibTarget(this.project, v.getName())));
                    break;
                }
                case KOTLIN_LIB: {
                    this.targets = ImmutableMap.of((Object)"main", (Object)new JvmTarget(this.project, "main", "kapt", "kaptTest", "kaptIntegrationTest"));
                    break;
                }
                case GROOVY_LIB: 
                case SCALA_LIB: 
                case JAVA_LIB: {
                    this.targets = ImmutableMap.of((Object)"main", (Object)new JvmTarget(this.project, "main"));
                    break;
                }
                default: {
                    this.targets = ImmutableMap.of();
                }
            }
        }
        return this.targets;
    }

    @Nullable
    Target getTargetForVariant(@Nullable String variant) {
        Target result = null;
        ProjectType type = ProjectUtil.getType(this.project);
        switch (type) {
            case ANDROID_LIB: {
                result = this.getTargets().get(variant);
                if (result != null) break;
                throw new IllegalStateException("No target found for " + this.project.getDisplayName() + " for variant " + variant);
            }
            case KOTLIN_LIB: 
            case GROOVY_LIB: 
            case SCALA_LIB: 
            case JAVA_LIB: {
                result = this.getTargets().values().iterator().next();
                break;
            }
        }
        return result;
    }
}

