/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.model.jvm;

import com.android.builder.model.LintOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.uber.okbuck.composer.jvm.JvmBuckRuleComposer;
import com.uber.okbuck.core.annotation.AnnotationProcessorCache;
import com.uber.okbuck.core.annotation.JvmPlugin;
import com.uber.okbuck.core.dependency.DependencyFactory;
import com.uber.okbuck.core.dependency.DependencyUtils;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.manager.LintManager;
import com.uber.okbuck.core.model.base.Scope;
import com.uber.okbuck.core.model.base.SourceSetType;
import com.uber.okbuck.core.model.base.Target;
import com.uber.okbuck.core.model.jvm.TestOptions;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.kotlin.allopen.gradle.AllOpenGradleSubplugin;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinSingleTargetExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCommonCompilation;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

public class JvmTarget
extends Target {
    public static final String MAIN = "main";
    protected static final String JAVA_COMPILER_EXTRA_ARGUMENTS = "extra_arguments";
    protected static final String KOTLIN_COMPILER_PLUGINS = "kotlinc_plugins";
    protected static final String KOTLIN_COMPILER_EXTRA_ARGUMENTS = "extra_kotlinc_arguments";
    private static final String INTEGRATION_TEST_SOURCE_SET_NAME = "integrationTest";
    private static final String INTEGRATION_TEST_TASK_NAME = "integrationTest";
    private static final String INTEGRATION_TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "integrationTestAnnotationProcessor";
    private static final String INTEGRATION_TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "integrationTestRuntimeClasspath";
    private static final String INTEGRATION_TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "integrationTestCompileClasspath";
    private static final String COMPILE_INTEGRATION_TEST_JAVA_TASK_NAME = "compileIntegrationTestJava";
    private final String aptConfigurationName;
    private final String testAptConfigurationName;
    private final String integrationTestAptConfigurationName;
    private final SourceSetContainer sourceSets;
    protected final boolean isKotlin;

    public JvmTarget(Project project, String name) {
        this(project, name, "annotationProcessor", "testAnnotationProcessor", INTEGRATION_TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME);
    }

    public JvmTarget(Project project, String name, String aptConfigurationName, String testAptConfigurationName, String integrationTestAptConfigurationName) {
        super(project, name);
        this.aptConfigurationName = aptConfigurationName;
        this.testAptConfigurationName = testAptConfigurationName;
        this.integrationTestAptConfigurationName = integrationTestAptConfigurationName;
        this.sourceSets = ((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        this.isKotlin = project.getPlugins().stream().anyMatch(plugin -> plugin instanceof KotlinBasePluginWrapper);
    }

    public TestOptions getTestOptions() {
        Test testTask = (Test)this.getProject().getTasks().getByName("test");
        Map env = testTask.getEnvironment();
        env.keySet().removeAll(System.getenv().keySet());
        return new TestOptions(testTask.getAllJvmArgs(), testTask.getEnvironment());
    }

    public TestOptions getIntegrationTestOptions() {
        Test testTask = (Test)this.getProject().getTasks().getByName("integrationTest");
        Map env = testTask.getEnvironment();
        env.keySet().removeAll(System.getenv().keySet());
        return new TestOptions(testTask.getAllJvmArgs(), testTask.getEnvironment());
    }

    public List<Scope> getAptScopes() {
        AnnotationProcessorCache apCache = ProjectUtil.getAnnotationProcessorCache(this.getProject());
        return apCache.getAnnotationProcessorScopes(this.getProject(), this.aptConfigurationName);
    }

    public List<Scope> getTestAptScopes() {
        AnnotationProcessorCache apCache = ProjectUtil.getAnnotationProcessorCache(this.getProject());
        return apCache.getAnnotationProcessorScopes(this.getProject(), this.testAptConfigurationName);
    }

    public List<Scope> getIntegrationTestAptScopes() {
        AnnotationProcessorCache apCache = ProjectUtil.getAnnotationProcessorCache(this.getProject());
        return apCache.getAnnotationProcessorScopes(this.getProject(), this.integrationTestAptConfigurationName);
    }

    public Scope getApt() {
        return this.getAptScopeForConfiguration(this.aptConfigurationName);
    }

    public Scope getTestApt() {
        return this.getAptScopeForConfiguration(this.testAptConfigurationName);
    }

    public Scope getIntegrationTestApt() {
        return this.getAptScopeForConfiguration(this.integrationTestAptConfigurationName);
    }

    protected Scope getAptScopeForConfiguration(String configurationName) {
        if (!this.getOkbuck().legacyAnnotationProcessorSupport || !ProjectUtil.getAnnotationProcessorCache(this.getProject()).hasEmptyAnnotationProcessors(this.getProject(), configurationName)) {
            return Scope.builder(this.getProject()).build();
        }
        return Scope.builder(this.getProject()).configuration(configurationName).build();
    }

    protected Scope getAptScopeForConfiguration(Configuration configuration) {
        return this.getAptScopeForConfiguration(configuration.getName());
    }

    public Scope getProvided() {
        return Scope.builder(this.getProject()).configuration("compileClasspath").build();
    }

    public Scope getTestProvided() {
        return Scope.builder(this.getProject()).configuration("testCompileClasspath").build();
    }

    public Scope getIntegrationTestProvided() {
        return Scope.builder(this.getProject()).configuration(INTEGRATION_TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME).build();
    }

    public Set<OExternalDependency> getApiExternalDeps() {
        Configuration apiConfiguration = this.getApiConfiguration();
        if (apiConfiguration != null) {
            DependencyFactory factory = ProjectUtil.getDependencyFactory(this.getProject());
            Set versionlessApiDependencies = apiConfiguration.getAllDependencies().withType(ExternalDependency.class).stream().map(factory::fromDependency).flatMap(Collection::stream).collect(Collectors.toSet());
            return this.getMain().getExternalDeps().stream().filter(dependency -> versionlessApiDependencies.contains(dependency.getVersionless())).collect(Collectors.toSet());
        }
        return ImmutableSet.of();
    }

    public Set<Target> getApiTargetDeps() {
        Configuration apiConfiguration = this.getApiConfiguration();
        if (apiConfiguration != null) {
            Set projectApiDependencies = apiConfiguration.getAllDependencies().withType(ProjectDependency.class).stream().map(p -> p.getDependencyProject().getPath()).collect(Collectors.toSet());
            return this.getMain().getTargetDeps().stream().filter(dependency -> projectApiDependencies.contains(dependency.getProject().getPath())).collect(Collectors.toSet());
        }
        return ImmutableSet.of();
    }

    @Nullable
    private Configuration getApiConfiguration() {
        ExternalDependenciesExtension extension = ProjectUtil.getExternalDependencyExtension(this.getProject());
        if (extension.exportedDepsEnabled()) {
            Configuration apiConfiguration = DependencyUtils.getConfiguration("apiElements", this.getProject());
            if (apiConfiguration == null) {
                apiConfiguration = DependencyUtils.getConfiguration("api", this.getProject());
            }
            return apiConfiguration;
        }
        return null;
    }

    public Scope getLint() {
        LintManager manager = ProjectUtil.getLintManager(this.getProject());
        return Scope.builder(this.getProject()).configuration("buckLint").depCache(manager.getLintDepsCache()).build();
    }

    @Nullable
    public LintOptions getLintOptions() {
        return null;
    }

    public Set<JvmPlugin> getApPlugins() {
        return this.getAptScopes().stream().filter(scope -> !scope.getAnnotationProcessors().isEmpty()).map(Scope::getAnnotationProcessorPlugin).collect(Collectors.toSet());
    }

    public Set<JvmPlugin> getTestApPlugins() {
        return this.getTestAptScopes().stream().filter(scope -> !scope.getAnnotationProcessors().isEmpty()).map(Scope::getAnnotationProcessorPlugin).collect(Collectors.toSet());
    }

    public Set<JvmPlugin> getIntegrationTestApPlugins() {
        return this.getIntegrationTestAptScopes().stream().filter(scope -> !scope.getAnnotationProcessors().isEmpty()).map(Scope::getAnnotationProcessorPlugin).collect(Collectors.toSet());
    }

    public Scope getMain() {
        JavaCompile compileJavaTask = (JavaCompile)this.getProject().getTasks().getByName("compileJava");
        return Scope.builder(this.getProject()).configuration("runtimeClasspath").sourceDirs(this.getMainSrcDirs()).javaResourceDirs(this.getMainJavaResourceDirs()).customOptions(JAVA_COMPILER_EXTRA_ARGUMENTS, compileJavaTask.getOptions().getCompilerArgs()).customOptions(KOTLIN_COMPILER_EXTRA_ARGUMENTS, this.getKotlinCompilerOptions()).customOptions(this.getKotlinFriendPaths(false)).customOptions(KOTLIN_COMPILER_PLUGINS, this.getKotlinCompilerPlugins()).build();
    }

    public Scope getTest() {
        JavaCompile testCompileJavaTask = (JavaCompile)this.getProject().getTasks().getByName("compileTestJava");
        return Scope.builder(this.getProject()).configuration("testRuntimeClasspath").sourceDirs(this.getTestSrcDirs()).javaResourceDirs(this.getTestJavaResourceDirs()).customOptions(JAVA_COMPILER_EXTRA_ARGUMENTS, testCompileJavaTask.getOptions().getCompilerArgs()).customOptions(KOTLIN_COMPILER_EXTRA_ARGUMENTS, this.getKotlinCompilerOptions()).customOptions(this.getKotlinFriendPaths(true)).customOptions(KOTLIN_COMPILER_PLUGINS, this.getKotlinCompilerPlugins()).build();
    }

    public Scope getIntegrationTest() {
        JavaCompile integrationTestCompileJavaTask;
        try {
            integrationTestCompileJavaTask = (JavaCompile)this.getProject().getTasks().getByName(COMPILE_INTEGRATION_TEST_JAVA_TASK_NAME);
        }
        catch (UnknownTaskException e) {
            integrationTestCompileJavaTask = (JavaCompile)this.getProject().getTasks().getByName("compileTestJava");
        }
        return Scope.builder(this.getProject()).configuration(INTEGRATION_TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME).sourceDirs(this.getIntegrationTestSrcDirs()).javaResourceDirs(this.getIntegrationTestJavaResourceDirs()).customOptions(JAVA_COMPILER_EXTRA_ARGUMENTS, integrationTestCompileJavaTask.getOptions().getCompilerArgs()).customOptions(KOTLIN_COMPILER_EXTRA_ARGUMENTS, this.getKotlinCompilerOptions()).customOptions(this.getKotlinFriendPaths(true)).customOptions(KOTLIN_COMPILER_PLUGINS, this.getKotlinCompilerPlugins()).build();
    }

    public String getSourceCompatibility() {
        return JvmTarget.javaVersion(((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceCompatibility());
    }

    public String getTargetCompatibility() {
        return JvmTarget.javaVersion(((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getTargetCompatibility());
    }

    public String getMavenCoords() {
        String group = this.getProject().getGroup().toString();
        String id = ((BasePluginConvention)this.getProject().getConvention().getPlugin(BasePluginConvention.class)).getArchivesBaseName();
        String version = this.getProject().getVersion().toString();
        return String.join((CharSequence)":", group, id, version);
    }

    public boolean hasApplication() {
        return this.getProject().getPlugins().hasPlugin(ApplicationPlugin.class);
    }

    @Nullable
    public String getMainClass() {
        return ((ApplicationPluginConvention)this.getProject().getConvention().getPlugin(ApplicationPluginConvention.class)).getMainClassName();
    }

    public Set<String> getExcludes() {
        Jar jarTask = (Jar)this.getProject().getTasks().findByName("jar");
        return jarTask != null ? jarTask.getExcludes() : ImmutableSet.of();
    }

    private Set<File> getMainSrcDirs() {
        return ((SourceSet)this.sourceSets.getByName(MAIN)).getAllJava().getSrcDirs();
    }

    private Set<File> getMainJavaResourceDirs() {
        return ((SourceSet)this.sourceSets.getByName(MAIN)).getResources().getSrcDirs();
    }

    private Set<File> getTestSrcDirs() {
        return ((SourceSet)this.sourceSets.getByName("test")).getAllJava().getSrcDirs();
    }

    private Set<File> getTestJavaResourceDirs() {
        return ((SourceSet)this.sourceSets.getByName("test")).getResources().getSrcDirs();
    }

    private Set<File> getIntegrationTestSrcDirs() {
        try {
            return ((SourceSet)this.sourceSets.getByName("integrationTest")).getAllJava().getSrcDirs();
        }
        catch (UnknownDomainObjectException e) {
            return Collections.emptySet();
        }
    }

    private Set<File> getIntegrationTestJavaResourceDirs() {
        try {
            return ((SourceSet)this.sourceSets.getByName("integrationTest")).getResources().getSrcDirs();
        }
        catch (UnknownDomainObjectException e) {
            return Collections.emptySet();
        }
    }

    public static String javaVersion(JavaVersion version) {
        return version.getMajorVersion();
    }

    public Map<String, List<String>> getKotlinFriendPaths(boolean isTest) {
        if (!this.isKotlin || !isTest) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)"friend_paths", (Object)ImmutableList.of((Object)(":" + JvmBuckRuleComposer.src(this))));
    }

    protected List<String> getKotlinCompilerPlugins() {
        ImmutableList<SubpluginOption> subpluginOptions = this.getAllOpenSubpluginOptions();
        if (subpluginOptions.size() > 0) {
            return ImmutableList.of((Object)"//.okbuck/workspace/kotlin_home:allopen-compiler-plugin.jar");
        }
        return ImmutableList.of();
    }

    protected List<String> getKotlinCompilerOptions() {
        if (!this.isKotlin) {
            return ImmutableList.of();
        }
        ImmutableList.Builder optionBuilder = ImmutableList.builder();
        optionBuilder.addAll(this.readKotlinCompilerArguments());
        for (SubpluginOption option : this.getAllOpenSubpluginOptions()) {
            optionBuilder.add((Object)"-P");
            optionBuilder.add((Object)("plugin:org.jetbrains.kotlin.allopen:" + option.getKey() + "=" + option.getValue()));
        }
        return optionBuilder.build();
    }

    private List<String> readKotlinCompilerArguments() {
        try {
            String jdkHome;
            Optional kotlinCompileTask = this.getProject().getTasks().withType(KotlinCompile.class).stream().findFirst();
            if (!kotlinCompileTask.isPresent()) {
                return Collections.emptyList();
            }
            ImmutableMap.Builder optionBuilder = ImmutableMap.builder();
            KotlinJvmOptions options = ((KotlinCompile)kotlinCompileTask.get()).getKotlinOptions();
            LinkedHashMap freeArgs = Maps.newLinkedHashMap();
            options.getFreeCompilerArgs().forEach(arg -> freeArgs.put(arg, Optional.empty()));
            optionBuilder.putAll((Map)freeArgs);
            if (options.getAllWarningsAsErrors()) {
                optionBuilder.put((Object)"-Werror", Optional.empty());
            }
            if (options.getSuppressWarnings()) {
                optionBuilder.put((Object)"-nowarn", Optional.empty());
            }
            if (options.getVerbose()) {
                optionBuilder.put((Object)"-verbose", Optional.empty());
            }
            optionBuilder.put((Object)"-jvm-target", Optional.of(options.getJvmTarget()));
            if (options.getIncludeRuntime()) {
                optionBuilder.put((Object)"-include-runtime", Optional.empty());
            }
            if ((jdkHome = options.getJdkHome()) != null) {
                optionBuilder.put((Object)"-jdk-home", Optional.of(jdkHome));
            }
            if (options.getNoJdk()) {
                optionBuilder.put((Object)"-no-jdk", Optional.empty());
            }
            if (options.getNoStdlib()) {
                optionBuilder.put((Object)"-no-stdlib", Optional.empty());
            }
            if (options.getNoReflect()) {
                optionBuilder.put((Object)"-no-reflect", Optional.empty());
            }
            if (options.getJavaParameters()) {
                optionBuilder.put((Object)"-java-parameters", Optional.empty());
            }
            return optionBuilder.build().entrySet().stream().filter(JvmTarget.distinctByKey(Map.Entry::getKey)).sorted(Comparator.comparing(Map.Entry::getKey, String.CASE_INSENSITIVE_ORDER)).flatMap(entry -> {
                if (((Optional)entry.getValue()).isPresent()) {
                    return ImmutableList.of((Object)((String)entry.getKey()), (Object)((String)((Optional)entry.getValue()).get())).stream();
                }
                return ImmutableList.of((Object)((String)entry.getKey())).stream();
            }).collect(Collectors.toList());
        }
        catch (UnknownDomainObjectException ignored) {
            return Collections.emptyList();
        }
    }

    private ImmutableList<SubpluginOption> getAllOpenSubpluginOptions() {
        if (!this.getProject().getPlugins().hasPlugin("kotlin-allopen")) {
            return ImmutableList.of();
        }
        KotlinSingleTargetExtension extension = (KotlinSingleTargetExtension)this.getProject().getExtensions().findByType(KotlinSingleTargetExtension.class);
        if (extension == null) {
            return ImmutableList.of();
        }
        AllOpenGradleSubplugin subPlugin = (AllOpenGradleSubplugin)this.getProject().getPlugins().getPlugin("kotlin-allopen");
        KotlinCommonCompilation fakeCompilation = new KotlinCommonCompilation(extension.getTarget(), "fakeCompilation");
        return new ImmutableList.Builder().addAll((Iterable)subPlugin.applyToCompilation((KotlinCompilation)fakeCompilation).get()).build();
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public Set<Target> getTargetDeps(SourceSetType sourceSetType) {
        switch (sourceSetType) {
            case TEST: {
                return Sets.intersection(this.getTest().getTargetDeps(), this.getTestProvided().getTargetDeps());
            }
            case INTEGRATION_TEST: {
                return Sets.intersection(this.getIntegrationTest().getTargetDeps(), this.getIntegrationTestProvided().getTargetDeps());
            }
        }
        return Sets.difference((Set)Sets.intersection(this.getMain().getTargetDeps(), this.getProvided().getTargetDeps()), this.getApiTargetDeps());
    }

    public Set<Target> getTargetExportedDeps(SourceSetType sourceSetType) {
        switch (sourceSetType) {
            case TEST: 
            case INTEGRATION_TEST: {
                return ImmutableSet.of();
            }
        }
        return this.getApiTargetDeps();
    }

    public Set<Target> getTargetAptDeps(SourceSetType sourceSetType) {
        switch (sourceSetType) {
            case TEST: {
                return this.getTestApt().getTargetDeps();
            }
            case INTEGRATION_TEST: {
                return this.getIntegrationTestApt().getTargetDeps();
            }
        }
        return this.getApt().getTargetDeps();
    }

    public Set<Target> getTargetProvidedDeps(SourceSetType sourceSetType) {
        switch (sourceSetType) {
            case TEST: {
                return Sets.difference(this.getTestProvided().getTargetDeps(), this.getTest().getTargetDeps());
            }
            case INTEGRATION_TEST: {
                return Sets.difference(this.getIntegrationTestProvided().getTargetDeps(), this.getIntegrationTest().getTargetDeps());
            }
        }
        return Sets.difference(this.getProvided().getTargetDeps(), this.getMain().getTargetDeps());
    }

    public Set<OExternalDependency> getExternalDeps(SourceSetType sourceSetType) {
        switch (sourceSetType) {
            case TEST: {
                return JvmTarget.versionlessIntersection(this.getTest().getExternalDeps(), this.getTestProvided().getExternalDeps());
            }
            case INTEGRATION_TEST: {
                return JvmTarget.versionlessIntersection(this.getIntegrationTest().getExternalDeps(), this.getIntegrationTestProvided().getExternalDeps());
            }
        }
        return JvmTarget.versionlessDifference(JvmTarget.versionlessIntersection(this.getMain().getExternalDeps(), this.getProvided().getExternalDeps()), this.getApiExternalDeps());
    }

    public Set<OExternalDependency> getExternalAarDeps(SourceSetType sourceSetType) {
        return OExternalDependency.filterAar(this.getExternalDeps(sourceSetType));
    }

    public Set<OExternalDependency> getExternalExportedDeps(SourceSetType sourceSetType) {
        switch (sourceSetType) {
            case TEST: 
            case INTEGRATION_TEST: {
                return ImmutableSet.of();
            }
        }
        return this.getApiExternalDeps();
    }

    public Set<OExternalDependency> getExternalExportedAarDeps(SourceSetType sourceSetType) {
        return OExternalDependency.filterAar(this.getExternalExportedDeps(sourceSetType));
    }

    public Set<OExternalDependency> getExternalAptDeps(SourceSetType sourceSetType) {
        switch (sourceSetType) {
            case TEST: {
                return OExternalDependency.filterJar(this.getTestApt().getExternalDeps());
            }
            case INTEGRATION_TEST: {
                return OExternalDependency.filterJar(this.getIntegrationTestApt().getExternalDeps());
            }
        }
        return OExternalDependency.filterJar(this.getApt().getExternalDeps());
    }

    public Set<OExternalDependency> getExternalProvidedDeps(SourceSetType sourceSetType) {
        switch (sourceSetType) {
            case TEST: {
                return JvmTarget.versionlessDifference(this.getTestProvided().getExternalDeps(), this.getTest().getExternalDeps());
            }
            case INTEGRATION_TEST: {
                return JvmTarget.versionlessDifference(this.getIntegrationTestProvided().getExternalDeps(), this.getIntegrationTest().getExternalDeps());
            }
        }
        return JvmTarget.versionlessDifference(this.getProvided().getExternalDeps(), this.getMain().getExternalDeps());
    }

    private static Set<OExternalDependency> versionlessDifference(Set<OExternalDependency> set1, Set<OExternalDependency> set2) {
        Set versionlessSet2 = set2.stream().map(OExternalDependency::getVersionless).collect(Collectors.toSet());
        return set1.stream().filter(externalDependency -> !versionlessSet2.contains(externalDependency.getVersionless())).collect(Collectors.toSet());
    }

    private static Set<OExternalDependency> versionlessIntersection(Set<OExternalDependency> set1, Set<OExternalDependency> set2) {
        Set versionlessSet2 = set2.stream().map(OExternalDependency::getVersionless).collect(Collectors.toSet());
        return set1.stream().filter(externalDependency -> versionlessSet2.contains(externalDependency.getVersionless())).collect(Collectors.toSet());
    }
}

