/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.task;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.uber.okbuck.core.model.base.ProjectType;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.MoreCollectors;
import com.uber.okbuck.core.util.ProjectUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class OkBuckCleanTask
extends DefaultTask {
    @Input
    public Set<Project> projects;

    @Inject
    public OkBuckCleanTask(Set<Project> projects) {
        this.projects = projects;
    }

    @TaskAction
    void clean() throws IOException {
        Object lastProjectPaths;
        Project rootProject = this.getProject();
        Path rootProjectPath = rootProject.getProjectDir().toPath();
        File okbuckState = rootProject.file((Object)".okbuck/state/STATE");
        if (okbuckState.exists()) {
            try (Stream<String> lines = Files.lines(okbuckState.toPath());){
                lastProjectPaths = (Set)lines.map(String::trim).filter(s -> !Strings.isNullOrEmpty((String)s)).collect(MoreCollectors.toImmutableSet());
            }
        } else {
            lastProjectPaths = ImmutableSet.of();
            okbuckState.getParentFile().mkdirs();
            okbuckState.createNewFile();
        }
        Set currentProjectPaths = (Set)this.projects.stream().filter(project -> ProjectUtil.getType(project) != ProjectType.UNKNOWN).map(project -> project.getRootProject().getProjectDir().toPath().relativize(project.getProjectDir().toPath()).toString()).collect(MoreCollectors.toImmutableSet());
        Sets.SetView difference = Sets.difference((Set)lastProjectPaths, (Set)currentProjectPaths);
        difference.stream().map(p -> rootProjectPath.resolve((String)p).resolve(ProjectUtil.getOkBuckExtension((Project)rootProject).buildFileName)).forEach(FileUtil::deleteQuietly);
        FileUtil.deleteQuietly(rootProjectPath.resolve(".okbuck/cache"));
        FileUtil.deleteQuietly(rootProjectPath.resolve(".okbuck/gen"));
        FileUtil.deleteQuietly(rootProjectPath.resolve(".buckconfig.local"));
        Files.write(okbuckState.toPath(), (Iterable<? extends CharSequence>)((Iterable)currentProjectPaths.stream().sorted().collect(MoreCollectors.toImmutableList())), new OpenOption[0]);
    }

    @Internal
    public String getDescription() {
        return "Delete stale configuration files generated by OkBuck";
    }

    @Internal
    public String getGroup() {
        return "okbuck";
    }

    public Set<Project> getProjects() {
        return this.projects;
    }
}

