/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.uber.okbuck.composer.base.BuckRuleComposer;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.manager.BuckFileManager;
import com.uber.okbuck.core.model.base.ProjectType;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProguardUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import com.uber.okbuck.extension.KotlinExtension;
import com.uber.okbuck.extension.OkBuckExtension;
import com.uber.okbuck.extension.RuleOverridesExtension;
import com.uber.okbuck.extension.ScalaExtension;
import com.uber.okbuck.generator.OkbuckBuckConfigGenerator;
import com.uber.okbuck.template.config.OkbuckAndroidModules;
import com.uber.okbuck.template.config.OkbuckPrebuilt;
import com.uber.okbuck.template.config.OkbuckTargets;
import com.uber.okbuck.template.core.Rule;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class OkBuckTask
extends DefaultTask {
    public static final String CLASSPATH_ABI_MACRO = "classpath_abi";
    @Nested
    public OkBuckExtension okBuckExtension;
    @Nested
    public KotlinExtension kotlinExtension;
    @Nested
    public ScalaExtension scalaExtension;
    private BuckFileManager buckFileManager;

    @Inject
    public OkBuckTask(OkBuckExtension okBuckExtension, KotlinExtension kotlinExtension, ScalaExtension scalaExtension, BuckFileManager buckFileManager) {
        this.okBuckExtension = okBuckExtension;
        this.kotlinExtension = kotlinExtension;
        this.scalaExtension = scalaExtension;
        this.buckFileManager = buckFileManager;
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
    }

    @TaskAction
    void okbuck() {
        String scalaLibraryLocation;
        boolean hasScalaLib;
        boolean hasGroovyLib = this.okBuckExtension.buckProjects.stream().anyMatch(project -> ProjectUtil.getType(project) == ProjectType.GROOVY_LIB);
        if (hasGroovyLib) {
            ProjectUtil.getGroovyManager(this.getProject()).setupGroovyHome();
        }
        if (hasScalaLib = this.okBuckExtension.buckProjects.stream().anyMatch(project -> ProjectUtil.getType(project) == ProjectType.SCALA_LIB)) {
            Set<OExternalDependency> scalaDeps = ProjectUtil.getScalaManager(this.getProject()).setupScalaHome(this.scalaExtension.version);
            scalaLibraryLocation = BuckRuleComposer.external(scalaDeps.stream().filter(it -> it.getTargetName().contains("scala-library")).findFirst().get());
        } else {
            scalaLibraryLocation = "";
        }
        if (this.kotlinExtension.version != null) {
            ProjectUtil.getKotlinManager(this.getProject()).setupKotlinHome(this.kotlinExtension);
        }
        this.generate(this.okBuckExtension, hasGroovyLib ? "//.okbuck/workspace/groovy_installation:groovy_home" : null, this.kotlinExtension.version != null ? "//.okbuck/workspace/kotlin_home:kotlin_home" : null, hasScalaLib ? ".okbuck/workspace/scala_installation" : null, hasScalaLib ? scalaLibraryLocation : null);
    }

    @Internal
    public String getGroup() {
        return "okbuck";
    }

    @Internal
    public String getDescription() {
        return "Okbuck task for the root project. Also sets up groovy and kotlin if required.";
    }

    @OutputFile
    public File getOkbuckTargets() {
        return this.getProject().file((Object)".okbuck/defs/okbuck_targets.bzl");
    }

    @OutputFile
    public File getOkbuckPrebuilt() {
        return this.getProject().file((Object)".okbuck/defs/okbuck_prebuilt.bzl");
    }

    @OutputFile
    public File getOkbuckPrebuiltBuildFile() {
        return this.getProject().file((Object)(".okbuck/defs/" + this.okBuckExtension.buildFileName));
    }

    @OutputFile
    public File getOkbuckAndroidModules() {
        return this.getProject().file((Object)".okbuck/defs/okbuck_android_modules.bzl");
    }

    @OutputFile
    public File getDotBuckConfig() {
        return this.getProject().file((Object)".buckconfig");
    }

    @OutputFile
    public File getOkbuckBuckConfig() {
        return this.getProject().file((Object)".okbuck/config/okbuck.buckconfig");
    }

    public OkBuckExtension getOkBuckExtension() {
        return this.okBuckExtension;
    }

    public KotlinExtension getKotlinExtension() {
        return this.kotlinExtension;
    }

    public ScalaExtension getScalaExtension() {
        return this.scalaExtension;
    }

    private void generate(OkBuckExtension okbuckExt, @Nullable String groovyHome, @Nullable String kotlinHome, @Nullable String scalaCompiler, @Nullable String scalaLibrary) {
        try {
            this.getDotBuckConfig().createNewFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        Map<String, RuleOverridesExtension.OverrideSetting> overrides = okbuckExt.getRuleOverridesExtension().getOverrides();
        new OkbuckTargets().resourceExcludes(this.okBuckExtension.excludeResources.stream().map(s -> "'" + s + "'").collect(Collectors.toSet())).classpathMacro(CLASSPATH_ABI_MACRO).lintJvmArgs(okbuckExt.getLintExtension().jvmArgs).enableLint(!okbuckExt.getLintExtension().disabled).jetifierConfigurationTarget(BuckRuleComposer.fileRule(okbuckExt.getJetifierExtension().customConfigFile)).externalDependencyCache(okbuckExt.getExternalDependenciesExtension().getCache()).classpathExclusionRegex(okbuckExt.getLintExtension().classpathExclusionRegex).useCompilationClasspath(okbuckExt.getLintExtension().useCompilationClasspath).render(this.getOkbuckTargets());
        TreeMultimap prebuiltLoadStatements = TreeMultimap.create();
        RuleOverridesExtension.OverrideSetting prebuiltSetting = overrides.get(RuleType.PREBUILT.getBuckName());
        RuleOverridesExtension.OverrideSetting aarSetting = overrides.get(RuleType.ANDROID_PREBUILT_AAR.getBuckName());
        RuleOverridesExtension.OverrideSetting jarSetting = overrides.get(RuleType.PREBUILT_JAR.getBuckName());
        prebuiltLoadStatements.put((Object)aarSetting.getImportLocation(), (Object)aarSetting.getNewRuleName());
        prebuiltLoadStatements.put((Object)jarSetting.getImportLocation(), (Object)jarSetting.getNewRuleName());
        ExternalDependenciesExtension external = okbuckExt.getExternalDependenciesExtension();
        OkbuckPrebuilt okbuckPrebuiltRule = new OkbuckPrebuilt().okbuckPrebuiltRule(prebuiltSetting.getNewRuleName()).prebuiltAarRule(aarSetting.getNewRuleName()).prebuiltJarRule(jarSetting.getNewRuleName());
        if (external.strictVisibilityEnabled()) {
            okbuckPrebuiltRule.strictVisibilityScope(String.format("//%s/...", external.getCache()));
        }
        this.buckFileManager.writeToBuckFile((List<Rule>)ImmutableList.of((Object)((Object)okbuckPrebuiltRule)), this.getOkbuckPrebuilt(), (Multimap<String, String>)prebuiltLoadStatements);
        this.buckFileManager.writeToBuckFile("", this.getOkbuckPrebuiltBuildFile(), false);
        TreeMultimap unifiedLibsLoadStatements = TreeMultimap.create();
        RuleOverridesExtension.OverrideSetting androidResourceSetting = overrides.get(RuleType.ANDROID_RESOURCE.getBuckName());
        RuleOverridesExtension.OverrideSetting androidLibrarySetting = overrides.get(RuleType.ANDROID_LIBRARY.getBuckName());
        RuleOverridesExtension.OverrideSetting manifestSetting = overrides.get(RuleType.MANIFEST.getBuckName());
        if (androidResourceSetting != null) {
            unifiedLibsLoadStatements.put((Object)androidResourceSetting.getImportLocation(), (Object)androidResourceSetting.getNewRuleName());
        }
        unifiedLibsLoadStatements.put((Object)androidLibrarySetting.getImportLocation(), (Object)androidLibrarySetting.getNewRuleName());
        unifiedLibsLoadStatements.put((Object)manifestSetting.getImportLocation(), (Object)manifestSetting.getNewRuleName());
        OkbuckAndroidModules okbuckAndroidModules = new OkbuckAndroidModules().androidLibraryRule(androidLibrarySetting.getNewRuleName()).manifestRule(manifestSetting.getNewRuleName()).androidResourceRule(androidResourceSetting != null ? androidResourceSetting.getNewRuleName() : "native." + RuleType.ANDROID_RESOURCE.getBuckName());
        this.buckFileManager.writeToBuckFile((List<Rule>)ImmutableList.of((Object)((Object)okbuckAndroidModules)), this.getOkbuckAndroidModules(), (Multimap<String, String>)unifiedLibsLoadStatements);
        OkbuckBuckConfigGenerator.generate(okbuckExt, groovyHome, kotlinHome, scalaCompiler, scalaLibrary, ProguardUtil.getProguardJarPath(this.getProject()), this.repositoryMap(okbuckExt.getExternalDependenciesExtension().shouldDownloadInBuck() && this.okBuckExtension.getExternalDependenciesExtension().getGenerateMavenRepositories())).render(this.getOkbuckBuckConfig());
        if (okbuckExt.okBuckBuckConfig) {
            String entry = String.format("<file:%s>", FileUtil.getRelativePath(this.getProject().getRootDir(), this.getOkbuckBuckConfig()));
            String dotBuckContent = FileUtil.readString(this.getDotBuckConfig());
            if (!dotBuckContent.contains(entry)) {
                dotBuckContent = entry + "\n\n" + dotBuckContent;
                FileUtil.writeString(this.getDotBuckConfig(), dotBuckContent);
            }
        }
    }

    private LinkedHashMap<String, String> repositoryMap(boolean downloadInBuck) {
        LinkedHashMap<String, String> rawRepositories = new LinkedHashMap<String, String>();
        if (!downloadInBuck) {
            return rawRepositories;
        }
        OkBuckTask.addRepositories(this.getProject().getRootProject(), rawRepositories);
        this.getProject().getRootProject().getSubprojects().forEach(subProject -> OkBuckTask.addRepositories(subProject, rawRepositories));
        LinkedHashMap<String, String> filteredRepositories = new LinkedHashMap<String, String>();
        rawRepositories.forEach((key, value) -> {
            if (!filteredRepositories.values().contains(value) && !value.startsWith("file:")) {
                filteredRepositories.put((String)key, (String)value);
            }
        });
        return filteredRepositories;
    }

    private static void addRepositories(Project project, LinkedHashMap<String, String> repositories) {
        project.getRepositories().stream().filter(repository -> repository instanceof MavenArtifactRepository).forEach(repository -> {
            MavenArtifactRepository mavenRepository = (MavenArtifactRepository)repository;
            String name = mavenRepository.getName().toLowerCase();
            String url = mavenRepository.getUrl().toString();
            repositories.put(name, url);
        });
    }
}

