/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.util;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.uber.okbuck.core.util.MoreCollectors;
import com.uber.okbuck.core.util.symlinks.SymlinkCreator;
import com.uber.okbuck.core.util.symlinks.SymlinkCreatorFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    private static final SymlinkCreator symlinkCreator = SymlinkCreatorFactory.getSymlinkCreator();
    private static final String DS_STORE = ".DS_Store";

    private FileUtil() {
    }

    public static String getRelativePath(File root, File f) {
        Path rootPath;
        Path fPath = f.toPath().toAbsolutePath();
        if (fPath.startsWith(rootPath = root.toPath().toAbsolutePath())) {
            return rootPath.relativize(fPath).toString();
        }
        throw new IllegalStateException(fPath + " must be located inside " + rootPath);
    }

    public static String readString(File f) {
        try {
            return new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read from file " + f + " due to exception: " + e);
        }
    }

    public static void writeString(File f, String content) {
        try {
            Files.write(f.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write to file " + f + " due to exception: " + e);
        }
    }

    public static void copyResourceToProject(String resource, File destination) {
        try {
            FileUtils.copyURLToFile((URL)FileUtil.class.getResource(resource), (File)destination);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ImmutableSet<String> available(Project project, Collection<File> files) {
        return files.stream().filter(rootFile -> {
            if (rootFile.isDirectory() && rootFile.exists()) {
                boolean bl;
                block9: {
                    Stream<Path> fileTree = Files.walk(rootFile.toPath(), new FileVisitOption[0]);
                    try {
                        bl = fileTree.filter(currentFilePath -> {
                            File currentFile = currentFilePath.toFile();
                            return !currentFile.isDirectory() && !currentFile.getName().equals(DS_STORE);
                        }).iterator().hasNext();
                        if (fileTree == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fileTree != null) {
                                try {
                                    fileTree.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    fileTree.close();
                }
                return bl;
            }
            return rootFile.exists();
        }).map(f -> FileUtil.getRelativePath(project.getProjectDir(), f)).collect(MoreCollectors.toImmutableSet());
    }

    public static void deleteQuietly(Path p) {
        try {
            Files.walkFileTree(p, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isZipFile(File file) {
        boolean bl;
        if (!file.exists() || file.isDirectory() || !file.canRead() || file.length() < 4L) {
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            bl = raf.readInt() == 1347093252;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        raf.close();
        return bl;
    }

    public static void symlink(Path link, Path target) {
        try {
            LOG.info("Creating symlink {} -> {}", (Object)link, (Object)target);
            symlinkCreator.createSymbolicLink(link, target);
        }
        catch (IOException e) {
            LOG.error("Could not create symlink {} -> {}", (Object)link, (Object)target);
            throw new IllegalStateException(e);
        }
    }

    public static HashMap<String, String> readMapFromJsonFile(File file) throws IOException {
        BufferedReader fileReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
        Gson gson = new Gson();
        return (HashMap)gson.fromJson((Reader)fileReader, new TypeToken<HashMap<String, String>>(){}.getType());
    }

    public static void persistMapToJsonFile(HashMap<String, String> map, File file) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        gson.toJson(map, (Appendable)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public static void deleteQuitelyAndCreate(File dir, boolean deleteDir, String fileName) {
        if (dir.exists()) {
            if (deleteDir) {
                try {
                    FileUtils.deleteDirectory((File)dir);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not delete dependency directory: " + dir, e);
                }
            } else {
                FileUtils.listFiles((File)dir, (IOFileFilter)new NameFileFilter(fileName), (IOFileFilter)TrueFileFilter.INSTANCE).parallelStream().forEach(FileUtils::deleteQuietly);
            }
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Couldn't create dependency directory: " + dir);
        }
    }
}

