/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.util;

import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryPlugin;
import com.google.common.collect.ImmutableList;
import com.uber.okbuck.OkBuckGradlePlugin;
import com.uber.okbuck.core.annotation.AnnotationProcessorCache;
import com.uber.okbuck.core.dependency.DependencyCache;
import com.uber.okbuck.core.dependency.DependencyFactory;
import com.uber.okbuck.core.dependency.DependencyUtils;
import com.uber.okbuck.core.manager.DependencyManager;
import com.uber.okbuck.core.manager.GroovyManager;
import com.uber.okbuck.core.manager.KotlinManager;
import com.uber.okbuck.core.manager.LintManager;
import com.uber.okbuck.core.manager.ScalaManager;
import com.uber.okbuck.core.manager.TransformManager;
import com.uber.okbuck.core.model.base.ProjectType;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import com.uber.okbuck.extension.OkBuckExtension;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.scala.ScalaPlugin;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper;

public final class ProjectUtil {
    private ProjectUtil() {
    }

    public static ProjectType getType(Project project) {
        PluginContainer plugins = project.getPlugins();
        if (plugins.hasPlugin(AppPlugin.class)) {
            return ProjectType.ANDROID_APP;
        }
        if (plugins.hasPlugin(LibraryPlugin.class)) {
            return ProjectType.ANDROID_LIB;
        }
        if (plugins.hasPlugin(GroovyPlugin.class)) {
            return ProjectType.GROOVY_LIB;
        }
        if (plugins.hasPlugin(KotlinPluginWrapper.class)) {
            return ProjectType.KOTLIN_LIB;
        }
        if (plugins.hasPlugin(ScalaPlugin.class)) {
            return ProjectType.SCALA_LIB;
        }
        if (plugins.hasPlugin(JavaPlugin.class)) {
            return ProjectType.JAVA_LIB;
        }
        return ProjectType.UNKNOWN;
    }

    public static boolean isAndroidType(Project project) {
        ProjectType type = ProjectUtil.getType(project);
        return type == ProjectType.ANDROID_APP || type == ProjectType.ANDROID_LIB;
    }

    public static DependencyCache getDependencyCache(Project project) {
        return ProjectUtil.getPlugin((Project)project).depCache;
    }

    public static AnnotationProcessorCache getAnnotationProcessorCache(Project project) {
        return ProjectUtil.getPlugin((Project)project).annotationProcessorCache;
    }

    public static DependencyFactory getDependencyFactory(Project project) {
        return ProjectUtil.getPlugin((Project)project).dependencyFactory;
    }

    public static DependencyManager getDependencyManager(Project project) {
        return ProjectUtil.getPlugin((Project)project).dependencyManager;
    }

    public static LintManager getLintManager(Project project) {
        return ProjectUtil.getPlugin((Project)project).lintManager;
    }

    public static KotlinManager getKotlinManager(Project project) {
        return ProjectUtil.getPlugin((Project)project).kotlinManager;
    }

    public static ScalaManager getScalaManager(Project project) {
        return ProjectUtil.getPlugin((Project)project).scalaManager;
    }

    public static GroovyManager getGroovyManager(Project project) {
        return ProjectUtil.getPlugin((Project)project).groovyManager;
    }

    public static TransformManager getTransformManager(Project project) {
        return ProjectUtil.getPlugin((Project)project).transformManager;
    }

    public static OkBuckGradlePlugin getPlugin(Project project) {
        return (OkBuckGradlePlugin)project.getRootProject().getPlugins().getPlugin(OkBuckGradlePlugin.class);
    }

    public static OkBuckExtension getOkBuckExtension(Project project) {
        return (OkBuckExtension)project.getRootProject().getExtensions().getByName("okbuck");
    }

    public static ExternalDependenciesExtension getExternalDependencyExtension(Project project) {
        OkBuckExtension okBuckExtension = (OkBuckExtension)project.getRootProject().getExtensions().getByName("okbuck");
        return okBuckExtension.getExternalDependenciesExtension();
    }

    @Nullable
    public static String findVersionInClasspath(Project project, String group, String module) {
        return project.getBuildscript().getConfigurations().getByName("classpath").getIncoming().getArtifacts().getArtifacts().stream().flatMap(artifactResult -> artifactResult.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier ? Stream.of((ModuleComponentIdentifier)artifactResult.getId().getComponentIdentifier()) : Stream.empty()).filter(identifier -> group.equals(identifier.getGroup()) && module.equals(identifier.getModule())).findFirst().map(ModuleComponentIdentifier::getVersion).orElse(null);
    }

    public static Map<ComponentIdentifier, ResolvedArtifactResult> downloadSources(Project project, Set<ResolvedArtifactResult> artifacts) {
        if (!ProjectUtil.getOkBuckExtension(project).getIntellijExtension().downloadSources()) {
            return new HashMap<ComponentIdentifier, ResolvedArtifactResult>();
        }
        DependencyHandler dependencies = project.getDependencies();
        try {
            Set identifiers = artifacts.stream().filter(artifact -> ProjectUtil.canHaveSources(artifact.getFile())).map(artifact -> artifact.getId().getComponentIdentifier()).collect(Collectors.toSet());
            Class[] artifactTypesArray = new Class[]{SourcesArtifact.class};
            Set results = dependencies.createArtifactResolutionQuery().forComponents(identifiers).withArtifacts(JvmLibrary.class, artifactTypesArray).execute().getResolvedComponents();
            Class type = artifactTypesArray[0];
            return results.stream().map(artifactsResult -> artifactsResult.getArtifacts(type)).flatMap(Collection::stream).filter(artifactResult -> artifactResult instanceof ResolvedArtifactResult).map(artifactResult -> (ResolvedArtifactResult)artifactResult).filter(artifactResult -> FileUtil.isZipFile(artifactResult.getFile())).collect(Collectors.toMap(resolvedArtifact -> resolvedArtifact.getId().getComponentIdentifier(), resolvedArtifact -> resolvedArtifact));
        }
        catch (Throwable t) {
            System.out.println("Unable to download sources for project " + project.toString() + " with error " + t.toString());
            return new HashMap<ComponentIdentifier, ResolvedArtifactResult>();
        }
    }

    public static boolean canHaveSources(File dependencyFile) {
        return !DependencyUtils.isWhiteListed(dependencyFile) && ImmutableList.of((Object)"jar", (Object)"aar").contains((Object)FilenameUtils.getExtension((String)dependencyFile.getName()));
    }
}

