/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.extension;

import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.core.dependency.VersionlessDependency;
import com.uber.okbuck.extension.ResolutionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.tasks.Input;

public class ExternalDependenciesExtension {
    @Input
    private String cache = ".okbuck/ext";
    @Input
    private boolean cleanCacheDir = true;
    @Input
    private boolean downloadInBuck = true;
    @Input
    private boolean generateMavenRepositories = true;
    @Input
    private ResolutionAction resolutionAction = ResolutionAction.ALL;
    @Input
    private boolean enableExportedDeps = false;
    @Input
    private boolean thirdPartyResolutionOnly = false;
    @Input
    private boolean strictVisibility = false;
    @Input
    private boolean markFirstLevelAllVersions = true;
    @Input
    private Set<String> autoValueConfigurations = new HashSet<String>();
    @Input
    private List<String> allowAllVersions = Collections.singletonList("org.robolectric:android-all-instrumented");
    @Input
    private Map<String, String> dynamicDependencyVersionMap = new HashMap<String, String>();
    @Input
    private Set<String> dynamicDependenciesToIgnore = new HashSet<String>();
    @Input
    private boolean bazelDeps = false;
    @Input
    private String sha256Cache = ".okbuck/state/SHA256";
    @Nullable
    private Set<VersionlessDependency> allowAllVersionsSet;

    private synchronized Set<VersionlessDependency> getAllowAllVersionsSet() {
        if (this.allowAllVersionsSet == null) {
            this.allowAllVersionsSet = (Set)this.allowAllVersions.stream().map(VersionlessDependency::fromMavenCoords).collect(ImmutableSet.toImmutableSet());
        }
        return this.allowAllVersionsSet;
    }

    public boolean useLatest() {
        return this.resolutionAction.equals((Object)ResolutionAction.LATEST);
    }

    public boolean useLatest(VersionlessDependency versionlessDependency) {
        if (this.getAllowAllVersionsSet().contains(versionlessDependency)) {
            return false;
        }
        return this.useLatest();
    }

    public boolean useSingle() {
        return this.resolutionAction.equals((Object)ResolutionAction.SINGLE);
    }

    public boolean useSingle(VersionlessDependency versionlessDependency) {
        if (this.getAllowAllVersionsSet().contains(versionlessDependency)) {
            return false;
        }
        return this.useSingle();
    }

    public boolean strictVisibilityEnabled() {
        return this.exportedDepsEnabled() && this.strictVisibility;
    }

    public boolean shouldMarkFirstLevelAllVersions() {
        return this.markFirstLevelAllVersions;
    }

    public boolean resoleOnlyThirdParty() {
        return this.versionedExportedDepsEnabled() && this.thirdPartyResolutionOnly;
    }

    public boolean versionlessEnabled() {
        return this.useLatest() || this.useSingle();
    }

    public boolean exportedDepsEnabled() {
        return this.enableExportedDeps;
    }

    public boolean versionlessExportedDepsEnabled() {
        return this.versionlessEnabled() && this.enableExportedDeps;
    }

    public boolean versionedExportedDepsEnabled() {
        return !this.versionlessEnabled() && this.enableExportedDeps;
    }

    public boolean isVersioned(VersionlessDependency versionlessDependency) {
        if (this.getAllowAllVersionsSet().contains(versionlessDependency)) {
            return true;
        }
        return !this.versionlessEnabled();
    }

    public String getCache() {
        return this.cache;
    }

    public boolean shouldDownloadInBuck() {
        return this.downloadInBuck;
    }

    public boolean getGenerateMavenRepositories() {
        return this.generateMavenRepositories;
    }

    public Set<String> getAutoValueConfigurations() {
        return this.autoValueConfigurations;
    }

    public Map<String, String> getDynamicDependencyVersionMap() {
        return this.dynamicDependencyVersionMap;
    }

    public Set<String> getDynamicDependenciesToIgnore() {
        return this.dynamicDependenciesToIgnore;
    }

    public boolean bazelDepsEnabled() {
        return this.bazelDeps;
    }

    public String getSha256Cache() {
        return this.sha256Cache;
    }

    public boolean shouldCleanCacheDir() {
        return this.cleanCacheDir;
    }
}

