/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.extension;

import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.core.manager.JetifierManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public class JetifierExtension {
    public static final String DEFAULT_JETIFIER_VERSION = "1.0.0-beta03";
    private static final List<String> JETIFIER_DEPS = Arrays.asList("com.android.tools.build.jetifier:jetifier-core", "com.android.tools.build.jetifier:jetifier-processor", "com.google.code.gson:gson", "commons-cli:commons-cli", "org.jdom:jdom2", "org.jetbrains:annotations", "org.ow2.asm:asm-commons", "org.ow2.asm:asm-tree", "org.ow2.asm:asm-util", "org.ow2.asm:asm", "org.jetbrains.kotlin:.*");
    public String version = "1.0.0-beta03";
    public boolean aarOnly;
    public List<String> exclude = new ArrayList<String>();
    @Nullable
    public String customConfigFile;
    public boolean enabled;
    private final boolean enableJetifier;
    @Nullable
    private List<Pattern> excludePatterns;

    JetifierExtension(Project project) {
        this.enableJetifier = this.enabled || JetifierManager.isJetifierEnabled(project);
    }

    private List<Pattern> getExcludePatterns() {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ImmutableSet.Builder().addAll(this.exclude).addAll(JETIFIER_DEPS).build().stream().map(Pattern::compile).collect(Collectors.toList());
        }
        return this.excludePatterns;
    }

    public boolean shouldJetify(String group, String name, String packaging) {
        if (!this.enableJetifier) {
            return false;
        }
        if (this.aarOnly && packaging.equals("jar")) {
            return false;
        }
        return this.getExcludePatterns().stream().noneMatch(pattern -> pattern.matcher(group + ":" + name).matches());
    }
}

