/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.extension;

import com.uber.okbuck.extension.ExperimentalExtension;
import com.uber.okbuck.extension.ExportDependenciesExtension;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import com.uber.okbuck.extension.IntellijExtension;
import com.uber.okbuck.extension.JetifierExtension;
import com.uber.okbuck.extension.KotlinExtension;
import com.uber.okbuck.extension.LintExtension;
import com.uber.okbuck.extension.RuleOverridesExtension;
import com.uber.okbuck.extension.ScalaExtension;
import com.uber.okbuck.extension.TestExtension;
import com.uber.okbuck.extension.TransformExtension;
import com.uber.okbuck.extension.VisibilityExtension;
import com.uber.okbuck.extension.WrapperExtension;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public class OkBuckExtension {
    private static final String DEFAULT_BUCK_BINARY_REPO = "com.github.raviagarwal7:buck";
    private static final String DEFAULT_BUCK_BINARY_SHA = "8369cecf8b4a8d628f7852f0030587944f01bc19";
    @Input
    public String buildToolVersion = "28.0.2";
    @Input
    public String target = "android-28";
    @Input
    public Map<String, List<String>> annotationProcessors = new HashMap<String, List<String>>();
    @Input
    public Map<String, Integer> linearAllocHardLimit = new HashMap<String, Integer>();
    @Input
    public Map<String, List<String>> primaryDexPatterns = new HashMap<String, List<String>>();
    @Input
    public Map<String, Boolean> exopackage = new HashMap<String, Boolean>();
    @Input
    public Map<String, List<String>> appLibDependencies = new HashMap<String, List<String>>();
    @Input
    public Map<String, File> proguardMappingFile = new HashMap<String, File>();
    @Input
    public Map<String, List<String>> lintExclude = new HashMap<String, List<String>>();
    @Input
    public Map<String, List<String>> testExclude = new HashMap<String, List<String>>();
    @Internal
    public Set<Project> buckProjects;
    @Input
    public String buildFileName = "BUCK";
    @Input
    public boolean okBuckBuckConfig = true;
    @Input
    public Map<String, Map<String, Collection<String>>> extraBuckOpts = new HashMap<String, Map<String, Collection<String>>>();
    @Input
    public boolean resourceUnion;
    @Nullable
    @Optional
    @Input
    public String resourceUnionPackage;
    @Input
    public boolean libraryBuildConfig = true;
    @Input
    public Set<String> excludeResources = new HashSet<String>();
    @Input
    public Map<String, Boolean> extraDepCachesMap = new HashMap<String, Boolean>();
    @Input
    public boolean failOnChangingDependencies = false;
    @Input
    public boolean legacyAnnotationProcessorSupport = true;
    @Input
    @Optional
    public String buckBinary = "com.github.raviagarwal7:buck:8369cecf8b4a8d628f7852f0030587944f01bc19@pex";
    @Input
    public String buckBinaryJava11 = "com.github.raviagarwal7:buck:8369cecf8b4a8d628f7852f0030587944f01bc19:java11@pex";
    @Internal
    private final WrapperExtension wrapperExtension = new WrapperExtension();
    @Internal
    private final KotlinExtension kotlinExtension;
    @Internal
    private final ScalaExtension scalaExtension = new ScalaExtension();
    @Internal
    private final IntellijExtension intellijExtension = new IntellijExtension();
    @Internal
    private final ExperimentalExtension experimentalExtension = new ExperimentalExtension();
    @Internal
    private final TestExtension testExtension = new TestExtension();
    @Internal
    private final TransformExtension transformExtension = new TransformExtension();
    @Internal
    private final LintExtension lintExtension;
    @Internal
    private final JetifierExtension jetifierExtension;
    @Internal
    private final ExternalDependenciesExtension externalDependenciesExtension = new ExternalDependenciesExtension();
    @Internal
    private final VisibilityExtension visibilityExtension = new VisibilityExtension();
    @Internal
    private final RuleOverridesExtension ruleOverridesExtension;
    @Internal
    private final ExportDependenciesExtension exportDependenciesExtension;

    public OkBuckExtension(Project project) {
        this.buckProjects = project.getSubprojects();
        this.kotlinExtension = new KotlinExtension(project);
        this.lintExtension = new LintExtension(project);
        this.jetifierExtension = new JetifierExtension(project);
        this.ruleOverridesExtension = new RuleOverridesExtension(project);
        this.exportDependenciesExtension = new ExportDependenciesExtension(project);
    }

    public void wrapper(Action<WrapperExtension> container) {
        container.execute((Object)this.wrapperExtension);
    }

    public WrapperExtension getWrapperExtension() {
        return this.wrapperExtension;
    }

    public void kotlin(Action<KotlinExtension> container) {
        container.execute((Object)this.kotlinExtension);
    }

    public KotlinExtension getKotlinExtension() {
        return this.kotlinExtension;
    }

    public void scala(Action<ScalaExtension> container) {
        container.execute((Object)this.scalaExtension);
    }

    public ScalaExtension getScalaExtension() {
        return this.scalaExtension;
    }

    public void intellij(Action<IntellijExtension> container) {
        container.execute((Object)this.intellijExtension);
    }

    public IntellijExtension getIntellijExtension() {
        return this.intellijExtension;
    }

    public void experimental(Action<ExperimentalExtension> container) {
        container.execute((Object)this.experimentalExtension);
    }

    public ExperimentalExtension getExperimentalExtension() {
        return this.experimentalExtension;
    }

    public void test(Action<TestExtension> container) {
        container.execute((Object)this.testExtension);
    }

    public TestExtension getTestExtension() {
        return this.testExtension;
    }

    public void lint(Action<LintExtension> container) {
        container.execute((Object)this.lintExtension);
    }

    public LintExtension getLintExtension() {
        return this.lintExtension;
    }

    public void jetifier(Action<JetifierExtension> container) {
        container.execute((Object)this.jetifierExtension);
    }

    public JetifierExtension getJetifierExtension() {
        return this.jetifierExtension;
    }

    public void transform(Action<TransformExtension> container) {
        container.execute((Object)this.transformExtension);
    }

    public TransformExtension getTransformExtension() {
        return this.transformExtension;
    }

    public void externalDependencies(Action<ExternalDependenciesExtension> container) {
        container.execute((Object)this.externalDependenciesExtension);
    }

    public ExternalDependenciesExtension getExternalDependenciesExtension() {
        return this.externalDependenciesExtension;
    }

    public void visibility(Action<VisibilityExtension> container) {
        container.execute((Object)this.visibilityExtension);
    }

    public VisibilityExtension getVisibilityExtension() {
        return this.visibilityExtension;
    }

    public void ruleOverrides(Action<RuleOverridesExtension> container) {
        container.execute((Object)this.ruleOverridesExtension);
    }

    public RuleOverridesExtension getRuleOverridesExtension() {
        return this.ruleOverridesExtension;
    }

    public boolean useResourceUnion() {
        return this.resourceUnionPackage != null || this.resourceUnion;
    }

    public Map<String, List<String>> getAnnotationProcessors() {
        return this.annotationProcessors;
    }

    public String getBuildToolVersion() {
        return this.buildToolVersion;
    }

    public String getTarget() {
        return this.target;
    }

    public Map<String, Integer> getLinearAllocHardLimit() {
        return this.linearAllocHardLimit;
    }

    public Map<String, List<String>> getPrimaryDexPatterns() {
        return this.primaryDexPatterns;
    }

    public Map<String, Boolean> getExopackage() {
        return this.exopackage;
    }

    public Map<String, File> getProguardMappingFile() {
        return this.proguardMappingFile;
    }

    public Map<String, List<String>> getLintExclude() {
        return this.lintExclude;
    }

    public Map<String, List<String>> getTestExclude() {
        return this.testExclude;
    }

    public String getBuildFileName() {
        return this.buildFileName;
    }

    public boolean isOkBuckBuckConfig() {
        return this.okBuckBuckConfig;
    }

    public Map<String, Map<String, Collection<String>>> getExtraBuckOpts() {
        return this.extraBuckOpts;
    }

    public boolean isResourceUnion() {
        return this.resourceUnion;
    }

    @Nullable
    public String getResourceUnionPackage() {
        return this.resourceUnionPackage;
    }

    public boolean isLibraryBuildConfig() {
        return this.libraryBuildConfig;
    }

    public Set<String> getExcludeResources() {
        return this.excludeResources;
    }

    public Map<String, List<String>> getAppLibDependencies() {
        return this.appLibDependencies;
    }

    public Set<Project> getBuckProjects() {
        return this.buckProjects;
    }

    public String getBuckBinary() {
        return this.buckBinary;
    }

    public String getBuckBinaryJava11() {
        return this.buckBinaryJava11;
    }

    public Map<String, Boolean> getExtraDepCachesMap() {
        return this.extraDepCachesMap;
    }

    public boolean isFailOnChangingDependencies() {
        return this.failOnChangingDependencies;
    }

    public boolean isLegacyAnnotationProcessorSupport() {
        return this.legacyAnnotationProcessorSupport;
    }

    public void exportDependencies(Action<ExportDependenciesExtension> container) {
        container.execute((Object)this.exportDependenciesExtension);
    }

    public ExportDependenciesExtension getExportDependenciesExtension() {
        return this.exportDependenciesExtension;
    }
}

