/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.extension;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.uber.okbuck.core.model.base.RuleType;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public class RuleOverridesExtension {
    private static final String OKBUCK_PREFIX = "okbuck_";
    private static final ImmutableMap<RuleType, String> OKBUCK_DEFINED_RULES = ImmutableMap.builder().put((Object)RuleType.AIDL, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.PREBUILT, (Object)"//.okbuck/defs:okbuck_prebuilt.bzl").put((Object)RuleType.HTTP_FILE, (Object)"//.okbuck/defs:okbuck_prebuilt.bzl").put((Object)RuleType.PREBUILT_JAR, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.ANDROID_LIBRARY, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.ANDROID_MODULE, (Object)"//.okbuck/defs:okbuck_android_modules.bzl").put((Object)RuleType.ANDROID_PREBUILT_AAR, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.KOTLIN_ANDROID_LIBRARY, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.KOTLIN_ANDROID_MODULE, (Object)"//.okbuck/defs:okbuck_android_modules.bzl").put((Object)RuleType.KEYSTORE, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.MANIFEST, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.JAVA_INTEGRATION_TEST, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.SCALA_INTEGRATION_TEST, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.GROOVY_INTEGRATION_TEST, (Object)"//.okbuck/defs:okbuck_targets.bzl").put((Object)RuleType.KOTLIN_INTEGRATION_TEST, (Object)"//.okbuck/defs:okbuck_targets.bzl").build();
    private Map<String, OverrideSetting> overridesMap = Collections.emptyMap();
    private final List<RawOverrideSetting> overrides = new ArrayList<RawOverrideSetting>();
    @Nullable
    private String defaultImportLocation;
    @Nullable
    private String defaultRuleNamePrefix;

    protected void override(Closure<RawOverrideSetting> action) {
        RawOverrideSetting setting = new RawOverrideSetting();
        action.setDelegate((Object)setting);
        action.call((Object)setting);
        this.overrides.add(setting);
    }

    public Map<String, OverrideSetting> getOverrides() {
        return this.overridesMap;
    }

    RuleOverridesExtension(Project project) {
        project.afterEvaluate(evaluatedProject -> {
            this.validateExtension();
            this.preProcessExtension();
        });
    }

    private void preProcessExtension() {
        Map<String, OverrideSetting> configuredOverrides = this.overrides.stream().map(this::applyDefaults).collect(Collectors.toMap(RawOverrideSetting::getNativeRuleName, x$0 -> new OverrideSetting((RawOverrideSetting)x$0)));
        OKBUCK_DEFINED_RULES.forEach((ruleType, target) -> {
            String buckName = ruleType.getBuckName();
            configuredOverrides.computeIfAbsent(buckName, nativeRuleName -> new OverrideSetting((String)target, OKBUCK_PREFIX + nativeRuleName));
        });
        this.overridesMap = ImmutableMap.copyOf(configuredOverrides);
    }

    private RawOverrideSetting applyDefaults(RawOverrideSetting originalSetting) {
        return new RawOverrideSetting(originalSetting.getNativeRuleName(), Optional.ofNullable(Strings.emptyToNull((String)originalSetting.getImportLocation())).orElse(this.defaultImportLocation), Optional.ofNullable(Strings.emptyToNull((String)originalSetting.getNewRuleName())).orElse(this.defaultRuleNamePrefix + originalSetting.getNativeRuleName()));
    }

    private void validateExtension() {
        HashSet<String> usedOverrideKeys = new HashSet<String>();
        for (RawOverrideSetting baseSetting : this.overrides) {
            RawOverrideSetting setting = this.applyDefaults(baseSetting);
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)setting.getNativeRuleName()), (Object)"nativeRuleName is required for override");
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)setting.getImportLocation()), (Object)(setting.getNativeRuleName() + ": importLocation is required for override, since no defaultImportLocation is specified"));
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)setting.getNewRuleName()), (Object)(setting.getNativeRuleName() + ": newRuleName is required for override, since no defaultRuleNamePrefix is specified"));
            if (usedOverrideKeys.contains(setting.getNativeRuleName())) {
                throw new IllegalArgumentException("Multiple overrides specified for the same rule: " + setting.getNativeRuleName());
            }
            usedOverrideKeys.add(setting.getNativeRuleName());
        }
    }

    private static class RawOverrideSetting {
        @Nullable
        private String nativeRuleName;
        @Nullable
        private String importLocation;
        @Nullable
        private String newRuleName;

        public RawOverrideSetting() {
        }

        private RawOverrideSetting(@Nullable String nativeRuleName, @Nullable String importLocation, @Nullable String newRuleName) {
            this.nativeRuleName = nativeRuleName;
            this.importLocation = importLocation;
            this.newRuleName = newRuleName;
        }

        @Nullable
        public String getNativeRuleName() {
            return this.nativeRuleName;
        }

        @Nullable
        public String getImportLocation() {
            return this.importLocation;
        }

        @Nullable
        public String getNewRuleName() {
            return this.newRuleName;
        }
    }

    public static class OverrideSetting {
        private String importLocation;
        private String newRuleName;

        private OverrideSetting(RawOverrideSetting rawOverrideSetting) {
            this((String)Preconditions.checkNotNull((Object)rawOverrideSetting.getImportLocation()), (String)Preconditions.checkNotNull((Object)rawOverrideSetting.getNewRuleName()));
        }

        private OverrideSetting(String importLocation, String newRuleName) {
            this.importLocation = importLocation;
            this.newRuleName = newRuleName;
        }

        public String getImportLocation() {
            return this.importLocation;
        }

        public String getNewRuleName() {
            return this.newRuleName;
        }
    }
}

