/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.template.android;

import com.android.builder.model.LintOptions;
import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.runtime.BreakException;
import com.fizzed.rocker.runtime.ContinueException;
import com.fizzed.rocker.runtime.DefaultRockerModel;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.Java8Iterator;
import com.fizzed.rocker.runtime.PlainTextUnloadedClassLoader;
import com.uber.okbuck.template.core.Rule;
import com.uber.okbuck.template.core.RuleTemplate;
import com.uber.okbuck.template.jvm.JvmRule;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class AndroidRule
extends Rule {
    private Collection srcs;
    private Collection exts;
    private Collection resources;
    private Collection resDirs;
    private Collection excludes;
    private String sourceCompatibility;
    private String targetCompatibility;
    private String proguardConfig;
    private Collection testTargets;
    private Collection apPlugins;
    private Collection aptDeps;
    private Collection providedDeps;
    private Map options;
    private Collection jvmArgs;
    private Map env;
    private Collection exportedDeps;
    private Collection friendPaths;
    private String language;
    private String manifest;
    private String robolectricManifest;
    private String runtimeDependency;
    private boolean generateR2;
    private boolean disableLint;
    private boolean disableLintTemplate;
    private Collection customLints;
    private String lintConfigXml;
    private LintOptions lintOptions;

    public static ContentType getContentType() {
        return ContentType.RAW;
    }

    public static String getTemplateName() {
        return "AndroidRule.rocker.raw";
    }

    public static String getTemplatePackageName() {
        return "com.uber.okbuck.template.android";
    }

    public static String getHeaderHash() {
        return "1187987351";
    }

    public static String[] getArgumentNames() {
        return new String[]{"srcs", "exts", "resources", "resDirs", "excludes", "sourceCompatibility", "targetCompatibility", "proguardConfig", "testTargets", "apPlugins", "aptDeps", "providedDeps", "options", "jvmArgs", "env", "exportedDeps", "friendPaths", "language", "manifest", "robolectricManifest", "runtimeDependency", "generateR2", "disableLint", "disableLintTemplate", "customLints", "lintConfigXml", "lintOptions"};
    }

    public AndroidRule srcs(Collection srcs) {
        this.srcs = srcs;
        return this;
    }

    public Collection srcs() {
        return this.srcs;
    }

    public AndroidRule exts(Collection exts) {
        this.exts = exts;
        return this;
    }

    public Collection exts() {
        return this.exts;
    }

    public AndroidRule resources(Collection resources) {
        this.resources = resources;
        return this;
    }

    public Collection resources() {
        return this.resources;
    }

    public AndroidRule resDirs(Collection resDirs) {
        this.resDirs = resDirs;
        return this;
    }

    public Collection resDirs() {
        return this.resDirs;
    }

    public AndroidRule excludes(Collection excludes) {
        this.excludes = excludes;
        return this;
    }

    public Collection excludes() {
        return this.excludes;
    }

    public AndroidRule sourceCompatibility(String sourceCompatibility) {
        this.sourceCompatibility = sourceCompatibility;
        return this;
    }

    public String sourceCompatibility() {
        return this.sourceCompatibility;
    }

    public AndroidRule targetCompatibility(String targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
        return this;
    }

    public String targetCompatibility() {
        return this.targetCompatibility;
    }

    public AndroidRule proguardConfig(String proguardConfig) {
        this.proguardConfig = proguardConfig;
        return this;
    }

    public String proguardConfig() {
        return this.proguardConfig;
    }

    public AndroidRule testTargets(Collection testTargets) {
        this.testTargets = testTargets;
        return this;
    }

    public Collection testTargets() {
        return this.testTargets;
    }

    public AndroidRule apPlugins(Collection apPlugins) {
        this.apPlugins = apPlugins;
        return this;
    }

    public Collection apPlugins() {
        return this.apPlugins;
    }

    public AndroidRule aptDeps(Collection aptDeps) {
        this.aptDeps = aptDeps;
        return this;
    }

    public Collection aptDeps() {
        return this.aptDeps;
    }

    public AndroidRule providedDeps(Collection providedDeps) {
        this.providedDeps = providedDeps;
        return this;
    }

    public Collection providedDeps() {
        return this.providedDeps;
    }

    public AndroidRule options(Map options) {
        this.options = options;
        return this;
    }

    public Map options() {
        return this.options;
    }

    public AndroidRule jvmArgs(Collection jvmArgs) {
        this.jvmArgs = jvmArgs;
        return this;
    }

    public Collection jvmArgs() {
        return this.jvmArgs;
    }

    public AndroidRule env(Map env) {
        this.env = env;
        return this;
    }

    public Map env() {
        return this.env;
    }

    public AndroidRule exportedDeps(Collection exportedDeps) {
        this.exportedDeps = exportedDeps;
        return this;
    }

    public Collection exportedDeps() {
        return this.exportedDeps;
    }

    public AndroidRule friendPaths(Collection friendPaths) {
        this.friendPaths = friendPaths;
        return this;
    }

    public Collection friendPaths() {
        return this.friendPaths;
    }

    public AndroidRule language(String language) {
        this.language = language;
        return this;
    }

    public String language() {
        return this.language;
    }

    public AndroidRule manifest(String manifest) {
        this.manifest = manifest;
        return this;
    }

    public String manifest() {
        return this.manifest;
    }

    public AndroidRule robolectricManifest(String robolectricManifest) {
        this.robolectricManifest = robolectricManifest;
        return this;
    }

    public String robolectricManifest() {
        return this.robolectricManifest;
    }

    public AndroidRule runtimeDependency(String runtimeDependency) {
        this.runtimeDependency = runtimeDependency;
        return this;
    }

    public String runtimeDependency() {
        return this.runtimeDependency;
    }

    public AndroidRule generateR2(boolean generateR2) {
        this.generateR2 = generateR2;
        return this;
    }

    public boolean generateR2() {
        return this.generateR2;
    }

    public AndroidRule disableLint(boolean disableLint) {
        this.disableLint = disableLint;
        return this;
    }

    public boolean disableLint() {
        return this.disableLint;
    }

    public AndroidRule disableLintTemplate(boolean disableLintTemplate) {
        this.disableLintTemplate = disableLintTemplate;
        return this;
    }

    public boolean disableLintTemplate() {
        return this.disableLintTemplate;
    }

    public AndroidRule customLints(Collection customLints) {
        this.customLints = customLints;
        return this;
    }

    public Collection customLints() {
        return this.customLints;
    }

    public AndroidRule lintConfigXml(String lintConfigXml) {
        this.lintConfigXml = lintConfigXml;
        return this;
    }

    public String lintConfigXml() {
        return this.lintConfigXml;
    }

    public AndroidRule lintOptions(LintOptions lintOptions) {
        this.lintOptions = lintOptions;
        return this;
    }

    public LintOptions lintOptions() {
        return this.lintOptions;
    }

    public static AndroidRule template(Collection srcs, Collection exts, Collection resources, Collection resDirs, Collection excludes, String sourceCompatibility, String targetCompatibility, String proguardConfig, Collection testTargets, Collection apPlugins, Collection aptDeps, Collection providedDeps, Map options, Collection jvmArgs, Map env, Collection exportedDeps, Collection friendPaths, String language, String manifest, String robolectricManifest, String runtimeDependency, boolean generateR2, boolean disableLint, boolean disableLintTemplate, Collection customLints, String lintConfigXml, LintOptions lintOptions) {
        return new AndroidRule().srcs(srcs).exts(exts).resources(resources).resDirs(resDirs).excludes(excludes).sourceCompatibility(sourceCompatibility).targetCompatibility(targetCompatibility).proguardConfig(proguardConfig).testTargets(testTargets).apPlugins(apPlugins).aptDeps(aptDeps).providedDeps(providedDeps).options(options).jvmArgs(jvmArgs).env(env).exportedDeps(exportedDeps).friendPaths(friendPaths).language(language).manifest(manifest).robolectricManifest(robolectricManifest).runtimeDependency(runtimeDependency).generateR2(generateR2).disableLint(disableLint).disableLintTemplate(disableLintTemplate).customLints(customLints).lintConfigXml(lintConfigXml).lintOptions(lintOptions);
    }

    protected DefaultRockerTemplate buildTemplate() throws RenderingException {
        return new Template(this);
    }

    private static class PlainText {
        private static final String PLAIN_TEXT_0_0 = "    manifest = \"";
        private static final String PLAIN_TEXT_1_0 = "\",\n";
        private static final String PLAIN_TEXT_2_0 = "    robolectric_manifest = \"";
        private static final String PLAIN_TEXT_3_0 = "    final_r_name = \"R2\",\n";
        private static final String PLAIN_TEXT_4_0 = "    proguard_config = \"";
        private static final String PLAIN_TEXT_5_0 = "    force_final_resource_ids = False,\n    robolectric_runtime_dependency = \"";
        private static final String PLAIN_TEXT_6_0 = "    language = \"";
        private static final String PLAIN_TEXT_7_0 = "    lint_src_dirs = [\n";
        private static final String PLAIN_TEXT_8_0 = "        \"";
        private static final String PLAIN_TEXT_9_0 = "    ],\n";
        private static final String PLAIN_TEXT_10_0 = "    lint_res_dirs = [\n";
        private static final String PLAIN_TEXT_11_0 = "    custom_lints = [\n";
        private static final String PLAIN_TEXT_12_0 = "    lint_options = [\n";
        private static final String PLAIN_TEXT_13_0 = "        \"--exitcode\",\n";
        private static final String PLAIN_TEXT_14_0 = "        \"-Wall\",\n";
        private static final String PLAIN_TEXT_15_0 = "        \"--nowarn\",\n";
        private static final String PLAIN_TEXT_16_0 = "        \"-Werror\",\n";
        private static final String PLAIN_TEXT_17_0 = "        \"--nolines\",\n";
        private static final String PLAIN_TEXT_18_0 = "        \"--disable ";
        private static final String PLAIN_TEXT_19_0 = "        \"--enable ";
        private static final String PLAIN_TEXT_20_0 = "        \"--config $(location ";
        private static final String PLAIN_TEXT_21_0 = ")\",\n";
        private static final String PLAIN_TEXT_22_0 = "    disable_lint = True,\n";

        private PlainText() {
        }
    }

    public static class Template
    extends RuleTemplate {
        private static final byte[] PLAIN_TEXT_0_0;
        private static final byte[] PLAIN_TEXT_1_0;
        private static final byte[] PLAIN_TEXT_2_0;
        private static final byte[] PLAIN_TEXT_3_0;
        private static final byte[] PLAIN_TEXT_4_0;
        private static final byte[] PLAIN_TEXT_5_0;
        private static final byte[] PLAIN_TEXT_6_0;
        private static final byte[] PLAIN_TEXT_7_0;
        private static final byte[] PLAIN_TEXT_8_0;
        private static final byte[] PLAIN_TEXT_9_0;
        private static final byte[] PLAIN_TEXT_10_0;
        private static final byte[] PLAIN_TEXT_11_0;
        private static final byte[] PLAIN_TEXT_12_0;
        private static final byte[] PLAIN_TEXT_13_0;
        private static final byte[] PLAIN_TEXT_14_0;
        private static final byte[] PLAIN_TEXT_15_0;
        private static final byte[] PLAIN_TEXT_16_0;
        private static final byte[] PLAIN_TEXT_17_0;
        private static final byte[] PLAIN_TEXT_18_0;
        private static final byte[] PLAIN_TEXT_19_0;
        private static final byte[] PLAIN_TEXT_20_0;
        private static final byte[] PLAIN_TEXT_21_0;
        private static final byte[] PLAIN_TEXT_22_0;
        protected final Collection srcs;
        protected final Collection exts;
        protected final Collection resources;
        protected final Collection resDirs;
        protected final Collection excludes;
        protected final String sourceCompatibility;
        protected final String targetCompatibility;
        protected final String proguardConfig;
        protected final Collection testTargets;
        protected final Collection apPlugins;
        protected final Collection aptDeps;
        protected final Collection providedDeps;
        protected final Map options;
        protected final Collection jvmArgs;
        protected final Map env;
        protected final Collection exportedDeps;
        protected final Collection friendPaths;
        protected final String language;
        protected final String manifest;
        protected final String robolectricManifest;
        protected final String runtimeDependency;
        protected final boolean generateR2;
        protected final boolean disableLint;
        protected final boolean disableLintTemplate;
        protected final Collection customLints;
        protected final String lintConfigXml;
        protected final LintOptions lintOptions;

        public Template(AndroidRule model) {
            super((RockerModel)model);
            this.__internal.setCharset("UTF-8");
            this.__internal.setContentType(AndroidRule.getContentType());
            this.__internal.setTemplateName(AndroidRule.getTemplateName());
            this.__internal.setTemplatePackageName(AndroidRule.getTemplatePackageName());
            this.srcs = model.srcs();
            this.exts = model.exts();
            this.resources = model.resources();
            this.resDirs = model.resDirs();
            this.excludes = model.excludes();
            this.sourceCompatibility = model.sourceCompatibility();
            this.targetCompatibility = model.targetCompatibility();
            this.proguardConfig = model.proguardConfig();
            this.testTargets = model.testTargets();
            this.apPlugins = model.apPlugins();
            this.aptDeps = model.aptDeps();
            this.providedDeps = model.providedDeps();
            this.options = model.options();
            this.jvmArgs = model.jvmArgs();
            this.env = model.env();
            this.exportedDeps = model.exportedDeps();
            this.friendPaths = model.friendPaths();
            this.language = model.language();
            this.manifest = model.manifest();
            this.robolectricManifest = model.robolectricManifest();
            this.runtimeDependency = model.runtimeDependency();
            this.generateR2 = model.generateR2();
            this.disableLint = model.disableLint();
            this.disableLintTemplate = model.disableLintTemplate();
            this.customLints = model.customLints();
            this.lintConfigXml = model.lintConfigXml();
            this.lintOptions = model.lintOptions();
        }

        protected void __doRender() throws IOException, RenderingException {
            this.__internal.aboutToExecutePosInTemplate(33, 1);
            this.__internal.renderValue((DefaultRockerModel)JvmRule.template(this.srcs, this.exts, this.resources, this.excludes, this.sourceCompatibility, this.targetCompatibility, "", this.testTargets, this.apPlugins, this.aptDeps, this.providedDeps, this.exportedDeps, this.options, this.jvmArgs, this.env).__body(() -> {
                this.__internal.aboutToExecutePosInTemplate(50, 1);
                if (AndroidRule.valid(this.manifest)) {
                    this.__internal.aboutToExecutePosInTemplate(50, 24);
                    this.__internal.writeValue(PLAIN_TEXT_0_0);
                    this.__internal.aboutToExecutePosInTemplate(51, 17);
                    this.__internal.renderValue(this.manifest, false);
                    this.__internal.aboutToExecutePosInTemplate(51, 26);
                    this.__internal.writeValue(PLAIN_TEXT_1_0);
                    this.__internal.aboutToExecutePosInTemplate(50, 1);
                }
                this.__internal.aboutToExecutePosInTemplate(53, 1);
                if (AndroidRule.valid(this.robolectricManifest)) {
                    this.__internal.aboutToExecutePosInTemplate(53, 35);
                    this.__internal.writeValue(PLAIN_TEXT_2_0);
                    this.__internal.aboutToExecutePosInTemplate(54, 29);
                    this.__internal.renderValue(this.robolectricManifest, false);
                    this.__internal.aboutToExecutePosInTemplate(54, 49);
                    this.__internal.writeValue(PLAIN_TEXT_1_0);
                    this.__internal.aboutToExecutePosInTemplate(53, 1);
                }
                this.__internal.aboutToExecutePosInTemplate(56, 1);
                if (this.generateR2) {
                    this.__internal.aboutToExecutePosInTemplate(56, 19);
                    this.__internal.writeValue(PLAIN_TEXT_3_0);
                    this.__internal.aboutToExecutePosInTemplate(56, 1);
                }
                this.__internal.aboutToExecutePosInTemplate(59, 1);
                if (AndroidRule.valid(this.proguardConfig)) {
                    this.__internal.aboutToExecutePosInTemplate(59, 30);
                    this.__internal.writeValue(PLAIN_TEXT_4_0);
                    this.__internal.aboutToExecutePosInTemplate(60, 24);
                    this.__internal.renderValue(this.proguardConfig, false);
                    this.__internal.aboutToExecutePosInTemplate(60, 39);
                    this.__internal.writeValue(PLAIN_TEXT_1_0);
                    this.__internal.aboutToExecutePosInTemplate(59, 1);
                }
                this.__internal.aboutToExecutePosInTemplate(62, 1);
                if (AndroidRule.valid(this.runtimeDependency)) {
                    this.__internal.aboutToExecutePosInTemplate(62, 33);
                    this.__internal.writeValue(PLAIN_TEXT_5_0);
                    this.__internal.aboutToExecutePosInTemplate(64, 39);
                    this.__internal.renderValue(this.runtimeDependency, false);
                    this.__internal.aboutToExecutePosInTemplate(64, 57);
                    this.__internal.writeValue(PLAIN_TEXT_1_0);
                    this.__internal.aboutToExecutePosInTemplate(62, 1);
                }
                this.__internal.aboutToExecutePosInTemplate(66, 1);
                if (AndroidRule.valid(this.language)) {
                    this.__internal.aboutToExecutePosInTemplate(66, 24);
                    this.__internal.writeValue(PLAIN_TEXT_6_0);
                    this.__internal.aboutToExecutePosInTemplate(67, 17);
                    this.__internal.renderValue(this.language, false);
                    this.__internal.aboutToExecutePosInTemplate(67, 26);
                    this.__internal.writeValue(PLAIN_TEXT_1_0);
                    this.__internal.aboutToExecutePosInTemplate(66, 1);
                }
                this.__internal.aboutToExecutePosInTemplate(69, 1);
                if (!this.disableLintTemplate) {
                    this.__internal.aboutToExecutePosInTemplate(70, 1);
                    if (!this.disableLint) {
                        this.__internal.aboutToExecutePosInTemplate(71, 1);
                        if (AndroidRule.valid(this.srcs)) {
                            this.__internal.aboutToExecutePosInTemplate(71, 20);
                            this.__internal.writeValue(PLAIN_TEXT_7_0);
                            this.__internal.aboutToExecutePosInTemplate(73, 5);
                            try {
                                Java8Iterator.forEach((Iterable)AndroidRule.sorted(this.srcs), src -> {
                                    try {
                                        this.__internal.aboutToExecutePosInTemplate(73, 32);
                                        this.__internal.writeValue(PLAIN_TEXT_8_0);
                                        this.__internal.aboutToExecutePosInTemplate(74, 10);
                                        this.__internal.renderValue(src, false);
                                        this.__internal.aboutToExecutePosInTemplate(74, 14);
                                        this.__internal.writeValue(PLAIN_TEXT_1_0);
                                        this.__internal.aboutToExecutePosInTemplate(73, 5);
                                    }
                                    catch (ContinueException continueException) {
                                        // empty catch block
                                    }
                                });
                            }
                            catch (BreakException breakException) {
                                // empty catch block
                            }
                            this.__internal.aboutToExecutePosInTemplate(75, 6);
                            this.__internal.writeValue(PLAIN_TEXT_9_0);
                            this.__internal.aboutToExecutePosInTemplate(77, 1);
                            if (AndroidRule.valid(this.resDirs)) {
                                this.__internal.aboutToExecutePosInTemplate(77, 23);
                                this.__internal.writeValue(PLAIN_TEXT_10_0);
                                this.__internal.aboutToExecutePosInTemplate(79, 5);
                                try {
                                    Java8Iterator.forEach((Iterable)AndroidRule.sorted(this.resDirs), resDir -> {
                                        try {
                                            this.__internal.aboutToExecutePosInTemplate(79, 38);
                                            this.__internal.writeValue(PLAIN_TEXT_8_0);
                                            this.__internal.aboutToExecutePosInTemplate(80, 10);
                                            this.__internal.renderValue(resDir, false);
                                            this.__internal.aboutToExecutePosInTemplate(80, 17);
                                            this.__internal.writeValue(PLAIN_TEXT_1_0);
                                            this.__internal.aboutToExecutePosInTemplate(79, 5);
                                        }
                                        catch (ContinueException continueException) {
                                            // empty catch block
                                        }
                                    });
                                }
                                catch (BreakException breakException) {
                                    // empty catch block
                                }
                                this.__internal.aboutToExecutePosInTemplate(81, 6);
                                this.__internal.writeValue(PLAIN_TEXT_9_0);
                                this.__internal.aboutToExecutePosInTemplate(77, 1);
                            }
                            this.__internal.aboutToExecutePosInTemplate(84, 1);
                            if (AndroidRule.valid(this.customLints)) {
                                this.__internal.aboutToExecutePosInTemplate(84, 27);
                                this.__internal.writeValue(PLAIN_TEXT_11_0);
                                this.__internal.aboutToExecutePosInTemplate(86, 5);
                                try {
                                    Java8Iterator.forEach((Iterable)AndroidRule.sorted(this.customLints), customLint -> {
                                        try {
                                            this.__internal.aboutToExecutePosInTemplate(86, 46);
                                            this.__internal.writeValue(PLAIN_TEXT_8_0);
                                            this.__internal.aboutToExecutePosInTemplate(87, 10);
                                            this.__internal.renderValue(customLint, false);
                                            this.__internal.aboutToExecutePosInTemplate(87, 21);
                                            this.__internal.writeValue(PLAIN_TEXT_1_0);
                                            this.__internal.aboutToExecutePosInTemplate(86, 5);
                                        }
                                        catch (ContinueException continueException) {
                                            // empty catch block
                                        }
                                    });
                                }
                                catch (BreakException breakException) {
                                    // empty catch block
                                }
                                this.__internal.aboutToExecutePosInTemplate(88, 6);
                                this.__internal.writeValue(PLAIN_TEXT_9_0);
                                this.__internal.aboutToExecutePosInTemplate(84, 1);
                            }
                            this.__internal.aboutToExecutePosInTemplate(91, 1);
                            if (this.lintOptions != null) {
                                this.__internal.aboutToExecutePosInTemplate(91, 28);
                                this.__internal.writeValue(PLAIN_TEXT_12_0);
                                this.__internal.aboutToExecutePosInTemplate(93, 1);
                                if (this.lintOptions.isAbortOnError()) {
                                    this.__internal.aboutToExecutePosInTemplate(93, 37);
                                    this.__internal.writeValue(PLAIN_TEXT_13_0);
                                    this.__internal.aboutToExecutePosInTemplate(93, 1);
                                }
                                this.__internal.aboutToExecutePosInTemplate(96, 1);
                                if (this.lintOptions.isCheckAllWarnings()) {
                                    this.__internal.aboutToExecutePosInTemplate(96, 41);
                                    this.__internal.writeValue(PLAIN_TEXT_14_0);
                                    this.__internal.aboutToExecutePosInTemplate(96, 1);
                                }
                                this.__internal.aboutToExecutePosInTemplate(99, 1);
                                if (this.lintOptions.isIgnoreWarnings()) {
                                    this.__internal.aboutToExecutePosInTemplate(99, 39);
                                    this.__internal.writeValue(PLAIN_TEXT_15_0);
                                    this.__internal.aboutToExecutePosInTemplate(99, 1);
                                }
                                this.__internal.aboutToExecutePosInTemplate(102, 1);
                                if (this.lintOptions.isWarningsAsErrors()) {
                                    this.__internal.aboutToExecutePosInTemplate(102, 41);
                                    this.__internal.writeValue(PLAIN_TEXT_16_0);
                                    this.__internal.aboutToExecutePosInTemplate(102, 1);
                                }
                                this.__internal.aboutToExecutePosInTemplate(105, 1);
                                if (this.lintOptions.isNoLines()) {
                                    this.__internal.aboutToExecutePosInTemplate(105, 32);
                                    this.__internal.writeValue(PLAIN_TEXT_17_0);
                                    this.__internal.aboutToExecutePosInTemplate(105, 1);
                                }
                                this.__internal.aboutToExecutePosInTemplate(108, 1);
                                if (AndroidRule.valid(this.lintOptions.getDisable())) {
                                    this.__internal.aboutToExecutePosInTemplate(108, 40);
                                    this.__internal.writeValue(PLAIN_TEXT_18_0);
                                    this.__internal.aboutToExecutePosInTemplate(109, 20);
                                    this.__internal.renderValue(String.join((CharSequence)",", this.lintOptions.getDisable()), false);
                                    this.__internal.aboutToExecutePosInTemplate(109, 65);
                                    this.__internal.writeValue(PLAIN_TEXT_1_0);
                                    this.__internal.aboutToExecutePosInTemplate(108, 1);
                                }
                                this.__internal.aboutToExecutePosInTemplate(111, 1);
                                if (AndroidRule.valid(this.lintOptions.getEnable())) {
                                    this.__internal.aboutToExecutePosInTemplate(111, 39);
                                    this.__internal.writeValue(PLAIN_TEXT_19_0);
                                    this.__internal.aboutToExecutePosInTemplate(112, 19);
                                    this.__internal.renderValue(String.join((CharSequence)",", this.lintOptions.getEnable()), false);
                                    this.__internal.aboutToExecutePosInTemplate(112, 63);
                                    this.__internal.writeValue(PLAIN_TEXT_1_0);
                                    this.__internal.aboutToExecutePosInTemplate(111, 1);
                                }
                                this.__internal.aboutToExecutePosInTemplate(114, 1);
                                if (AndroidRule.valid(this.lintConfigXml)) {
                                    this.__internal.aboutToExecutePosInTemplate(114, 29);
                                    this.__internal.writeValue(PLAIN_TEXT_20_0);
                                    this.__internal.aboutToExecutePosInTemplate(115, 30);
                                    this.__internal.renderValue(this.lintConfigXml, false);
                                    this.__internal.aboutToExecutePosInTemplate(115, 46);
                                    this.__internal.writeValue(PLAIN_TEXT_21_0);
                                    this.__internal.aboutToExecutePosInTemplate(114, 1);
                                }
                                this.__internal.aboutToExecutePosInTemplate(116, 2);
                                this.__internal.writeValue(PLAIN_TEXT_9_0);
                                this.__internal.aboutToExecutePosInTemplate(91, 1);
                            }
                            this.__internal.aboutToExecutePosInTemplate(71, 1);
                        }
                        this.__internal.aboutToExecutePosInTemplate(120, 1);
                    } else {
                        this.__internal.aboutToExecutePosInTemplate(120, 9);
                        this.__internal.writeValue(PLAIN_TEXT_22_0);
                        this.__internal.aboutToExecutePosInTemplate(70, 1);
                    }
                    this.__internal.aboutToExecutePosInTemplate(69, 1);
                }
                this.__internal.aboutToExecutePosInTemplate(33, 1);
            }), false);
        }

        static {
            PlainTextUnloadedClassLoader loader = PlainTextUnloadedClassLoader.tryLoad((ClassLoader)AndroidRule.class.getClassLoader(), (String)(AndroidRule.class.getName() + "$PlainText"), (String)"UTF-8");
            PLAIN_TEXT_0_0 = loader.tryGet("PLAIN_TEXT_0_0");
            PLAIN_TEXT_1_0 = loader.tryGet("PLAIN_TEXT_1_0");
            PLAIN_TEXT_2_0 = loader.tryGet("PLAIN_TEXT_2_0");
            PLAIN_TEXT_3_0 = loader.tryGet("PLAIN_TEXT_3_0");
            PLAIN_TEXT_4_0 = loader.tryGet("PLAIN_TEXT_4_0");
            PLAIN_TEXT_5_0 = loader.tryGet("PLAIN_TEXT_5_0");
            PLAIN_TEXT_6_0 = loader.tryGet("PLAIN_TEXT_6_0");
            PLAIN_TEXT_7_0 = loader.tryGet("PLAIN_TEXT_7_0");
            PLAIN_TEXT_8_0 = loader.tryGet("PLAIN_TEXT_8_0");
            PLAIN_TEXT_9_0 = loader.tryGet("PLAIN_TEXT_9_0");
            PLAIN_TEXT_10_0 = loader.tryGet("PLAIN_TEXT_10_0");
            PLAIN_TEXT_11_0 = loader.tryGet("PLAIN_TEXT_11_0");
            PLAIN_TEXT_12_0 = loader.tryGet("PLAIN_TEXT_12_0");
            PLAIN_TEXT_13_0 = loader.tryGet("PLAIN_TEXT_13_0");
            PLAIN_TEXT_14_0 = loader.tryGet("PLAIN_TEXT_14_0");
            PLAIN_TEXT_15_0 = loader.tryGet("PLAIN_TEXT_15_0");
            PLAIN_TEXT_16_0 = loader.tryGet("PLAIN_TEXT_16_0");
            PLAIN_TEXT_17_0 = loader.tryGet("PLAIN_TEXT_17_0");
            PLAIN_TEXT_18_0 = loader.tryGet("PLAIN_TEXT_18_0");
            PLAIN_TEXT_19_0 = loader.tryGet("PLAIN_TEXT_19_0");
            PLAIN_TEXT_20_0 = loader.tryGet("PLAIN_TEXT_20_0");
            PLAIN_TEXT_21_0 = loader.tryGet("PLAIN_TEXT_21_0");
            PLAIN_TEXT_22_0 = loader.tryGet("PLAIN_TEXT_22_0");
        }
    }
}

