/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.template.common;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.runtime.BreakException;
import com.fizzed.rocker.runtime.ContinueException;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.Java8Iterator;
import com.fizzed.rocker.runtime.PlainTextUnloadedClassLoader;
import com.uber.okbuck.template.core.Rule;
import com.uber.okbuck.template.core.RuleTemplate;
import java.io.IOException;
import java.util.Collection;

public class HttpArchive
extends Rule {
    private String sha256;
    private String stripPrefix;
    private String type;
    private Collection urls;

    public static ContentType getContentType() {
        return ContentType.RAW;
    }

    public static String getTemplateName() {
        return "HttpArchive.rocker.raw";
    }

    public static String getTemplatePackageName() {
        return "com.uber.okbuck.template.common";
    }

    public static String getHeaderHash() {
        return "-1640593457";
    }

    public static String[] getArgumentNames() {
        return new String[]{"sha256", "stripPrefix", "type", "urls"};
    }

    public HttpArchive sha256(String sha256) {
        this.sha256 = sha256;
        return this;
    }

    public String sha256() {
        return this.sha256;
    }

    public HttpArchive stripPrefix(String stripPrefix) {
        this.stripPrefix = stripPrefix;
        return this;
    }

    public String stripPrefix() {
        return this.stripPrefix;
    }

    public HttpArchive type(String type) {
        this.type = type;
        return this;
    }

    public String type() {
        return this.type;
    }

    public HttpArchive urls(Collection urls) {
        this.urls = urls;
        return this;
    }

    public Collection urls() {
        return this.urls;
    }

    public static HttpArchive template(String sha256, String stripPrefix, String type, Collection urls) {
        return new HttpArchive().sha256(sha256).stripPrefix(stripPrefix).type(type).urls(urls);
    }

    protected DefaultRockerTemplate buildTemplate() throws RenderingException {
        return new Template(this);
    }

    private static class PlainText {
        private static final String PLAIN_TEXT_0_0 = "http_archive(\n    name = \"";
        private static final String PLAIN_TEXT_1_0 = "\",\n    sha256 = \"";
        private static final String PLAIN_TEXT_2_0 = "\",\n";
        private static final String PLAIN_TEXT_3_0 = "    strip_prefix = \"";
        private static final String PLAIN_TEXT_4_0 = "    type = \"";
        private static final String PLAIN_TEXT_5_0 = "\",\n    urls = [\n";
        private static final String PLAIN_TEXT_6_0 = "        \"";
        private static final String PLAIN_TEXT_7_0 = "    ],\n    visibility = [\"PUBLIC\"],\n)\n";

        private PlainText() {
        }
    }

    public static class Template
    extends RuleTemplate {
        private static final byte[] PLAIN_TEXT_0_0;
        private static final byte[] PLAIN_TEXT_1_0;
        private static final byte[] PLAIN_TEXT_2_0;
        private static final byte[] PLAIN_TEXT_3_0;
        private static final byte[] PLAIN_TEXT_4_0;
        private static final byte[] PLAIN_TEXT_5_0;
        private static final byte[] PLAIN_TEXT_6_0;
        private static final byte[] PLAIN_TEXT_7_0;
        protected final String sha256;
        protected final String stripPrefix;
        protected final String type;
        protected final Collection urls;

        public Template(HttpArchive model) {
            super((RockerModel)model);
            this.__internal.setCharset("UTF-8");
            this.__internal.setContentType(HttpArchive.getContentType());
            this.__internal.setTemplateName(HttpArchive.getTemplateName());
            this.__internal.setTemplatePackageName(HttpArchive.getTemplatePackageName());
            this.sha256 = model.sha256();
            this.stripPrefix = model.stripPrefix();
            this.type = model.type();
            this.urls = model.urls();
        }

        protected void __doRender() throws IOException, RenderingException {
            this.__internal.aboutToExecutePosInTemplate(8, 2);
            this.__internal.writeValue(PLAIN_TEXT_0_0);
            this.__internal.aboutToExecutePosInTemplate(11, 13);
            this.__internal.renderValue(this.name, false);
            this.__internal.aboutToExecutePosInTemplate(11, 20);
            this.__internal.writeValue(PLAIN_TEXT_1_0);
            this.__internal.aboutToExecutePosInTemplate(12, 15);
            this.__internal.renderValue(this.sha256, false);
            this.__internal.aboutToExecutePosInTemplate(12, 24);
            this.__internal.writeValue(PLAIN_TEXT_2_0);
            this.__internal.aboutToExecutePosInTemplate(13, 1);
            if (HttpArchive.valid(this.stripPrefix)) {
                this.__internal.aboutToExecutePosInTemplate(13, 27);
                this.__internal.writeValue(PLAIN_TEXT_3_0);
                this.__internal.aboutToExecutePosInTemplate(14, 21);
                this.__internal.renderValue(this.stripPrefix, false);
                this.__internal.aboutToExecutePosInTemplate(14, 35);
                this.__internal.writeValue(PLAIN_TEXT_2_0);
                this.__internal.aboutToExecutePosInTemplate(13, 1);
            }
            this.__internal.aboutToExecutePosInTemplate(15, 2);
            this.__internal.writeValue(PLAIN_TEXT_4_0);
            this.__internal.aboutToExecutePosInTemplate(16, 13);
            this.__internal.renderValue(this.type, false);
            this.__internal.aboutToExecutePosInTemplate(16, 20);
            this.__internal.writeValue(PLAIN_TEXT_5_0);
            this.__internal.aboutToExecutePosInTemplate(18, 5);
            try {
                Java8Iterator.forEach((Iterable)HttpArchive.sorted(this.urls), url -> {
                    try {
                        this.__internal.aboutToExecutePosInTemplate(18, 32);
                        this.__internal.writeValue(PLAIN_TEXT_6_0);
                        this.__internal.aboutToExecutePosInTemplate(19, 10);
                        this.__internal.renderValue(url, false);
                        this.__internal.aboutToExecutePosInTemplate(19, 14);
                        this.__internal.writeValue(PLAIN_TEXT_2_0);
                        this.__internal.aboutToExecutePosInTemplate(18, 5);
                    }
                    catch (ContinueException continueException) {
                        // empty catch block
                    }
                });
            }
            catch (BreakException breakException) {
                // empty catch block
            }
            this.__internal.aboutToExecutePosInTemplate(20, 6);
            this.__internal.writeValue(PLAIN_TEXT_7_0);
        }

        static {
            PlainTextUnloadedClassLoader loader = PlainTextUnloadedClassLoader.tryLoad((ClassLoader)HttpArchive.class.getClassLoader(), (String)(HttpArchive.class.getName() + "$PlainText"), (String)"UTF-8");
            PLAIN_TEXT_0_0 = loader.tryGet("PLAIN_TEXT_0_0");
            PLAIN_TEXT_1_0 = loader.tryGet("PLAIN_TEXT_1_0");
            PLAIN_TEXT_2_0 = loader.tryGet("PLAIN_TEXT_2_0");
            PLAIN_TEXT_3_0 = loader.tryGet("PLAIN_TEXT_3_0");
            PLAIN_TEXT_4_0 = loader.tryGet("PLAIN_TEXT_4_0");
            PLAIN_TEXT_5_0 = loader.tryGet("PLAIN_TEXT_5_0");
            PLAIN_TEXT_6_0 = loader.tryGet("PLAIN_TEXT_6_0");
            PLAIN_TEXT_7_0 = loader.tryGet("PLAIN_TEXT_7_0");
        }
    }
}

