/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.template.config;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.runtime.BreakException;
import com.fizzed.rocker.runtime.ContinueException;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.Java8Iterator;
import com.fizzed.rocker.runtime.PlainTextUnloadedClassLoader;
import com.uber.okbuck.template.core.Rule;
import com.uber.okbuck.template.core.RuleTemplate;
import java.io.IOException;
import java.util.Map;

public class BuckConfig
extends Rule {
    private String buildToolsVersion;
    private String target;
    private String groovyHome;
    private String kotlinHome;
    private String scalaCompiler;
    private String scalaLibrary;
    private String proguardJar;
    private String buildFileName;
    private Map mavenRepositories;

    public static ContentType getContentType() {
        return ContentType.RAW;
    }

    public static String getTemplateName() {
        return "BuckConfig.rocker.raw";
    }

    public static String getTemplatePackageName() {
        return "com.uber.okbuck.template.config";
    }

    public static String getHeaderHash() {
        return "2052133412";
    }

    public static String[] getArgumentNames() {
        return new String[]{"buildToolsVersion", "target", "groovyHome", "kotlinHome", "scalaCompiler", "scalaLibrary", "proguardJar", "buildFileName", "mavenRepositories"};
    }

    public BuckConfig buildToolsVersion(String buildToolsVersion) {
        this.buildToolsVersion = buildToolsVersion;
        return this;
    }

    public String buildToolsVersion() {
        return this.buildToolsVersion;
    }

    public BuckConfig target(String target) {
        this.target = target;
        return this;
    }

    public String target() {
        return this.target;
    }

    public BuckConfig groovyHome(String groovyHome) {
        this.groovyHome = groovyHome;
        return this;
    }

    public String groovyHome() {
        return this.groovyHome;
    }

    public BuckConfig kotlinHome(String kotlinHome) {
        this.kotlinHome = kotlinHome;
        return this;
    }

    public String kotlinHome() {
        return this.kotlinHome;
    }

    public BuckConfig scalaCompiler(String scalaCompiler) {
        this.scalaCompiler = scalaCompiler;
        return this;
    }

    public String scalaCompiler() {
        return this.scalaCompiler;
    }

    public BuckConfig scalaLibrary(String scalaLibrary) {
        this.scalaLibrary = scalaLibrary;
        return this;
    }

    public String scalaLibrary() {
        return this.scalaLibrary;
    }

    public BuckConfig proguardJar(String proguardJar) {
        this.proguardJar = proguardJar;
        return this;
    }

    public String proguardJar() {
        return this.proguardJar;
    }

    public BuckConfig buildFileName(String buildFileName) {
        this.buildFileName = buildFileName;
        return this;
    }

    public String buildFileName() {
        return this.buildFileName;
    }

    public BuckConfig mavenRepositories(Map mavenRepositories) {
        this.mavenRepositories = mavenRepositories;
        return this;
    }

    public Map mavenRepositories() {
        return this.mavenRepositories;
    }

    public static BuckConfig template(String buildToolsVersion, String target, String groovyHome, String kotlinHome, String scalaCompiler, String scalaLibrary, String proguardJar, String buildFileName, Map mavenRepositories) {
        return new BuckConfig().buildToolsVersion(buildToolsVersion).target(target).groovyHome(groovyHome).kotlinHome(kotlinHome).scalaCompiler(scalaCompiler).scalaLibrary(scalaLibrary).proguardJar(proguardJar).buildFileName(buildFileName).mavenRepositories(mavenRepositories);
    }

    protected DefaultRockerTemplate buildTemplate() throws RenderingException {
        return new Template(this);
    }

    private static class PlainText {
        private static final String PLAIN_TEXT_0_0 = "[android]\n    build_tools_version = ";
        private static final String PLAIN_TEXT_1_0 = "\n    target = ";
        private static final String PLAIN_TEXT_2_0 = "\n";
        private static final String PLAIN_TEXT_3_0 = "\n[groovy]\n    groovy_home = ";
        private static final String PLAIN_TEXT_4_0 = "\n[kotlin]\n    kotlin_home = ";
        private static final String PLAIN_TEXT_5_0 = "\n[scala]\n    compiler = //";
        private static final String PLAIN_TEXT_6_0 = ":scala-compiler.jar\n    library = ";
        private static final String PLAIN_TEXT_7_0 = "\n[tools]\n    proguard = ";
        private static final String PLAIN_TEXT_8_0 = "\n[maven_repositories]\n";
        private static final String PLAIN_TEXT_9_0 = "    ";
        private static final String PLAIN_TEXT_10_0 = " = ";
        private static final String PLAIN_TEXT_11_0 = "\n[download]\n    in_build = true\n    max_number_of_retries = 3\n";
        private static final String PLAIN_TEXT_12_0 = "\n[buildfile]\n    name = ";

        private PlainText() {
        }
    }

    public static class Template
    extends RuleTemplate {
        private static final byte[] PLAIN_TEXT_0_0;
        private static final byte[] PLAIN_TEXT_1_0;
        private static final byte[] PLAIN_TEXT_2_0;
        private static final byte[] PLAIN_TEXT_3_0;
        private static final byte[] PLAIN_TEXT_4_0;
        private static final byte[] PLAIN_TEXT_5_0;
        private static final byte[] PLAIN_TEXT_6_0;
        private static final byte[] PLAIN_TEXT_7_0;
        private static final byte[] PLAIN_TEXT_8_0;
        private static final byte[] PLAIN_TEXT_9_0;
        private static final byte[] PLAIN_TEXT_10_0;
        private static final byte[] PLAIN_TEXT_11_0;
        private static final byte[] PLAIN_TEXT_12_0;
        protected final String buildToolsVersion;
        protected final String target;
        protected final String groovyHome;
        protected final String kotlinHome;
        protected final String scalaCompiler;
        protected final String scalaLibrary;
        protected final String proguardJar;
        protected final String buildFileName;
        protected final Map mavenRepositories;

        public Template(BuckConfig model) {
            super((RockerModel)model);
            this.__internal.setCharset("UTF-8");
            this.__internal.setContentType(BuckConfig.getContentType());
            this.__internal.setTemplateName(BuckConfig.getTemplateName());
            this.__internal.setTemplatePackageName(BuckConfig.getTemplatePackageName());
            this.buildToolsVersion = model.buildToolsVersion();
            this.target = model.target();
            this.groovyHome = model.groovyHome();
            this.kotlinHome = model.kotlinHome();
            this.scalaCompiler = model.scalaCompiler();
            this.scalaLibrary = model.scalaLibrary();
            this.proguardJar = model.proguardJar();
            this.buildFileName = model.buildFileName();
            this.mavenRepositories = model.mavenRepositories();
        }

        protected void __doRender() throws IOException, RenderingException {
            this.__internal.aboutToExecutePosInTemplate(13, 1);
            if (BuckConfig.valid(this.buildToolsVersion) && BuckConfig.valid(this.target)) {
                this.__internal.aboutToExecutePosInTemplate(13, 50);
                this.__internal.writeValue(PLAIN_TEXT_0_0);
                this.__internal.aboutToExecutePosInTemplate(16, 27);
                this.__internal.renderValue(this.buildToolsVersion, false);
                this.__internal.aboutToExecutePosInTemplate(16, 45);
                this.__internal.writeValue(PLAIN_TEXT_1_0);
                this.__internal.aboutToExecutePosInTemplate(17, 14);
                this.__internal.renderValue(this.target, false);
                this.__internal.aboutToExecutePosInTemplate(17, 21);
                this.__internal.writeValue(PLAIN_TEXT_2_0);
                this.__internal.aboutToExecutePosInTemplate(13, 1);
            }
            this.__internal.aboutToExecutePosInTemplate(19, 1);
            if (BuckConfig.valid(this.groovyHome)) {
                this.__internal.aboutToExecutePosInTemplate(19, 26);
                this.__internal.writeValue(PLAIN_TEXT_3_0);
                this.__internal.aboutToExecutePosInTemplate(22, 19);
                this.__internal.renderValue(this.groovyHome, false);
                this.__internal.aboutToExecutePosInTemplate(22, 30);
                this.__internal.writeValue(PLAIN_TEXT_2_0);
                this.__internal.aboutToExecutePosInTemplate(19, 1);
            }
            this.__internal.aboutToExecutePosInTemplate(24, 1);
            if (BuckConfig.valid(this.kotlinHome)) {
                this.__internal.aboutToExecutePosInTemplate(24, 26);
                this.__internal.writeValue(PLAIN_TEXT_4_0);
                this.__internal.aboutToExecutePosInTemplate(27, 19);
                this.__internal.renderValue(this.kotlinHome, false);
                this.__internal.aboutToExecutePosInTemplate(27, 30);
                this.__internal.writeValue(PLAIN_TEXT_2_0);
                this.__internal.aboutToExecutePosInTemplate(24, 1);
            }
            this.__internal.aboutToExecutePosInTemplate(29, 1);
            if (BuckConfig.valid(this.scalaCompiler) && BuckConfig.valid(this.scalaLibrary)) {
                this.__internal.aboutToExecutePosInTemplate(29, 52);
                this.__internal.writeValue(PLAIN_TEXT_5_0);
                this.__internal.aboutToExecutePosInTemplate(32, 18);
                this.__internal.renderValue(this.scalaCompiler, false);
                this.__internal.aboutToExecutePosInTemplate(32, 34);
                this.__internal.writeValue(PLAIN_TEXT_6_0);
                this.__internal.aboutToExecutePosInTemplate(33, 15);
                this.__internal.renderValue(this.scalaLibrary, false);
                this.__internal.aboutToExecutePosInTemplate(33, 30);
                this.__internal.writeValue(PLAIN_TEXT_2_0);
                this.__internal.aboutToExecutePosInTemplate(29, 1);
            }
            this.__internal.aboutToExecutePosInTemplate(35, 1);
            if (BuckConfig.valid(this.proguardJar)) {
                this.__internal.aboutToExecutePosInTemplate(35, 27);
                this.__internal.writeValue(PLAIN_TEXT_7_0);
                this.__internal.aboutToExecutePosInTemplate(38, 16);
                this.__internal.renderValue(this.proguardJar, false);
                this.__internal.aboutToExecutePosInTemplate(38, 28);
                this.__internal.writeValue(PLAIN_TEXT_2_0);
                this.__internal.aboutToExecutePosInTemplate(35, 1);
            }
            this.__internal.aboutToExecutePosInTemplate(40, 1);
            if (BuckConfig.valid(this.mavenRepositories)) {
                this.__internal.aboutToExecutePosInTemplate(40, 33);
                this.__internal.writeValue(PLAIN_TEXT_8_0);
                this.__internal.aboutToExecutePosInTemplate(43, 1);
                try {
                    Java8Iterator.forEach((Map)this.mavenRepositories, (key, val) -> {
                        try {
                            this.__internal.aboutToExecutePosInTemplate(43, 40);
                            this.__internal.writeValue(PLAIN_TEXT_9_0);
                            this.__internal.aboutToExecutePosInTemplate(44, 5);
                            this.__internal.renderValue(key, false);
                            this.__internal.aboutToExecutePosInTemplate(44, 9);
                            this.__internal.writeValue(PLAIN_TEXT_10_0);
                            this.__internal.aboutToExecutePosInTemplate(44, 12);
                            this.__internal.renderValue(val, false);
                            this.__internal.aboutToExecutePosInTemplate(44, 16);
                            this.__internal.writeValue(PLAIN_TEXT_2_0);
                            this.__internal.aboutToExecutePosInTemplate(43, 1);
                        }
                        catch (ContinueException continueException) {
                            // empty catch block
                        }
                    });
                }
                catch (BreakException breakException) {
                    // empty catch block
                }
                this.__internal.aboutToExecutePosInTemplate(45, 2);
                this.__internal.writeValue(PLAIN_TEXT_11_0);
                this.__internal.aboutToExecutePosInTemplate(40, 1);
            }
            this.__internal.aboutToExecutePosInTemplate(51, 1);
            if (BuckConfig.valid(this.buildFileName)) {
                this.__internal.aboutToExecutePosInTemplate(51, 29);
                this.__internal.writeValue(PLAIN_TEXT_12_0);
                this.__internal.aboutToExecutePosInTemplate(54, 12);
                this.__internal.renderValue(this.buildFileName, false);
                this.__internal.aboutToExecutePosInTemplate(54, 26);
                this.__internal.writeValue(PLAIN_TEXT_2_0);
                this.__internal.aboutToExecutePosInTemplate(51, 1);
            }
        }

        static {
            PlainTextUnloadedClassLoader loader = PlainTextUnloadedClassLoader.tryLoad((ClassLoader)BuckConfig.class.getClassLoader(), (String)(BuckConfig.class.getName() + "$PlainText"), (String)"UTF-8");
            PLAIN_TEXT_0_0 = loader.tryGet("PLAIN_TEXT_0_0");
            PLAIN_TEXT_1_0 = loader.tryGet("PLAIN_TEXT_1_0");
            PLAIN_TEXT_2_0 = loader.tryGet("PLAIN_TEXT_2_0");
            PLAIN_TEXT_3_0 = loader.tryGet("PLAIN_TEXT_3_0");
            PLAIN_TEXT_4_0 = loader.tryGet("PLAIN_TEXT_4_0");
            PLAIN_TEXT_5_0 = loader.tryGet("PLAIN_TEXT_5_0");
            PLAIN_TEXT_6_0 = loader.tryGet("PLAIN_TEXT_6_0");
            PLAIN_TEXT_7_0 = loader.tryGet("PLAIN_TEXT_7_0");
            PLAIN_TEXT_8_0 = loader.tryGet("PLAIN_TEXT_8_0");
            PLAIN_TEXT_9_0 = loader.tryGet("PLAIN_TEXT_9_0");
            PLAIN_TEXT_10_0 = loader.tryGet("PLAIN_TEXT_10_0");
            PLAIN_TEXT_11_0 = loader.tryGet("PLAIN_TEXT_11_0");
            PLAIN_TEXT_12_0 = loader.tryGet("PLAIN_TEXT_12_0");
        }
    }
}

