/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.wrapper;

import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.template.config.BuckWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class BuckWrapperTask
extends DefaultTask {
    @Input
    public String repo;
    @Input
    public Set<String> watch;
    @Input
    public Set<String> sourceRoots;
    @Input
    public Set<String> ignoredDirs;
    private final File wrapper = this.getProject().file((Object)"buckw");

    @Inject
    public BuckWrapperTask(String repo, Set<String> watch, Set<String> sourceRoots, Set<String> ignoredDirs) {
        this.repo = repo;
        this.watch = watch;
        this.sourceRoots = sourceRoots;
        this.ignoredDirs = ignoredDirs;
    }

    @TaskAction
    void installWrapper() {
        new BuckWrapper().customBuckRepo(this.repo).watch(BuckWrapperTask.toWatchmanMatchers(this.watch)).sourceRoots(BuckWrapperTask.toWatchmanMatchers(this.sourceRoots)).ignoredDirs(BuckWrapperTask.toWatchmanIgnoredDirs(this.ignoredDirs)).render(this.wrapper);
        this.wrapper.setExecutable(true);
        File watchmanConfig = this.getProject().file((Object)".watchmanconfig");
        if (!watchmanConfig.exists()) {
            FileUtil.copyResourceToProject("wrapper/WATCHMAN_CONFIG", this.getProject().file((Object)".watchmanconfig"));
        }
    }

    @Internal
    public String getDescription() {
        return "Create buck wrapper";
    }

    @Internal
    public String getGroup() {
        return "okbuck";
    }

    private static String toWatchmanIgnoredDirs(Set<String> ignoredDirs) {
        if (ignoredDirs.isEmpty()) {
            return "";
        }
        String ignoreExprs = ignoredDirs.stream().map(ignoredDir -> "            [\"dirname\", \"" + ignoredDir + "\"]").collect(Collectors.joining(",\n"));
        return "        [\"not\",\n" + ignoreExprs + "\n        ]";
    }

    private static String toWatchmanMatchers(Set<String> wildcardPatterns) {
        ArrayList<String> matches = new ArrayList<String>();
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (String wildcardPattern : wildcardPatterns) {
            String simplifiedPattern = wildcardPattern.startsWith("**/") ? wildcardPattern.replaceAll("\\*\\*/", "") : wildcardPattern;
            String basename = FilenameUtils.getBaseName((String)simplifiedPattern);
            String extension = FilenameUtils.getExtension((String)simplifiedPattern);
            if (!simplifiedPattern.contains("/")) {
                if (basename.equals("*")) {
                    suffixes.add(extension);
                    continue;
                }
                names.add(simplifiedPattern);
                continue;
            }
            matches.add(wildcardPattern);
        }
        String matchExprs = matches.stream().map(match -> "            [\"match\", \"" + match + "\", \"wholename\"]").collect(Collectors.joining(",\n"));
        String suffixExprs = suffixes.stream().map(suffix -> "            [\"suffix\", \"" + suffix + "\"]").collect(Collectors.joining(",\n"));
        String nameExpr = names.stream().map(name -> "\"" + name + "\"").collect(Collectors.joining(", "));
        if (!nameExpr.isEmpty()) {
            nameExpr = "            [\"name\", [" + nameExpr + "]]";
        }
        return Stream.of(suffixExprs, nameExpr, matchExprs).filter(StringUtils::isNotEmpty).collect(Collectors.joining(",\n"));
    }

    public String getRepo() {
        return this.repo;
    }

    public Set<String> getWatch() {
        return this.watch;
    }

    public Set<String> getSourceRoots() {
        return this.sourceRoots;
    }

    public Set<String> getIgnoredDirs() {
        return this.ignoredDirs;
    }
}

