/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave.compiler;

import androidx.annotation.FloatRange;
import androidx.annotation.IntDef;
import androidx.annotation.IntRange;
import androidx.annotation.LongDef;
import androidx.annotation.Size;
import com.google.common.collect.ImmutableList;
import com.uber.rave.annotation.Validated;
import com.uber.rave.compiler.AbortProcessingException;
import com.uber.rave.compiler.CompilerUtils;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class AnnotationVerifier {
    static final String LONGDEF_BAD_RETURN_TYPE_ERROR = " does not return a long value";
    static final String INTDEF_BAD_RETURN_TYPE_ERROR = " does not return an integer value";
    static final String FLOAT_RANGE_BAD_RETURN_TYPE_ERROR = " does not return an float or double value";
    static final String INT_RANGE_BAD_RETURN_TYPE_ERROR = " does not return an int or long value";
    protected final Messager messager;
    protected final Elements elements;
    protected final Types types;
    private TypeMirror seenFactoryTypeMirror = null;

    AnnotationVerifier(Messager messager, Elements elements, Types types) {
        this.messager = messager;
        this.types = types;
        this.elements = elements;
    }

    TypeMirror getSeenFactoryTypeMirror() {
        return this.seenFactoryTypeMirror;
    }

    void verify(TypeElement type) {
        Validated validatedAnnotation = type.getAnnotation(Validated.class);
        if (validatedAnnotation == null) {
            this.abortWithError("Annotation processor for @" + Validated.class.getSimpleName() + " was invoked with a type that does not have the annotation.", type);
            return;
        }
        if (type.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.abortWithError("Class is private. It must be at least package private", type);
        }
        TypeMirror factoryMirror = this.getTypeMirrorFromAnnotation(validatedAnnotation, type);
        if ((type.getModifiers().contains((Object)Modifier.PROTECTED) || type.getModifiers().contains((Object)Modifier.DEFAULT)) && !CompilerUtils.packageNameOf(type).equals(CompilerUtils.packageNameOf(this.types.asElement(factoryMirror)))) {
            this.abortWithError(type.getSimpleName() + " is not visible to " + factoryMirror.toString(), type);
        }
        if (this.implementsAnnotation(type)) {
            this.abortWithError("@" + Validated.class.getSimpleName() + " may not be used to implement an annotation interface.", type);
        }
        this.checkFactoryClass(factoryMirror, type);
        this.verifyAnnotationConflicts(type);
        this.verifyAnnotations(type);
    }

    private void verifyAnnotations(TypeElement type) {
        ImmutableList methodElements = new ImmutableList.Builder().addAll(ElementFilter.methodsIn(type.getEnclosedElements())).build();
        for (ExecutableElement executableElement : methodElements) {
            TypeKind kind;
            IntDef annotation;
            TypeKind kind2;
            IntRange intRange;
            TypeKind kind3;
            FloatRange floatRange;
            if (!executableElement.getParameters().isEmpty() || executableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            Size size = executableElement.getAnnotation(Size.class);
            if (size != null && size.multiple() < 1L) {
                this.abortWithError("Multiple value is less than 1 with value:" + size.multiple() + " on method " + executableElement.getSimpleName(), type);
            }
            if ((floatRange = executableElement.getAnnotation(FloatRange.class)) != null && (kind3 = executableElement.getReturnType().getKind()) != TypeKind.FLOAT && kind3 != TypeKind.DOUBLE) {
                this.abortWithError(executableElement.getSimpleName().toString() + FLOAT_RANGE_BAD_RETURN_TYPE_ERROR, type);
            }
            if ((intRange = executableElement.getAnnotation(IntRange.class)) != null && (kind2 = executableElement.getReturnType().getKind()) != TypeKind.INT && kind2 != TypeKind.LONG) {
                this.abortWithError(executableElement.getSimpleName().toString() + INT_RANGE_BAD_RETURN_TYPE_ERROR, type);
            }
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(executableElement)) {
                annotation = annotationMirror.getAnnotationType().asElement().getAnnotation(IntDef.class);
                kind = executableElement.getReturnType().getKind();
                if (annotation == null || kind == TypeKind.INT) continue;
                this.abortWithError(executableElement.getSimpleName().toString() + INTDEF_BAD_RETURN_TYPE_ERROR, type);
            }
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(executableElement)) {
                annotation = annotationMirror.getAnnotationType().asElement().getAnnotation(LongDef.class);
                kind = executableElement.getReturnType().getKind();
                if (annotation == null || kind == TypeKind.LONG) continue;
                this.abortWithError(executableElement.getSimpleName().toString() + LONGDEF_BAD_RETURN_TYPE_ERROR, type);
            }
        }
    }

    private void checkFactoryClass(TypeMirror factoryTypeMirror, TypeElement type) {
        if (this.seenFactoryTypeMirror == null) {
            this.seenFactoryTypeMirror = factoryTypeMirror;
            return;
        }
        if (!this.types.isSameType(factoryTypeMirror, this.seenFactoryTypeMirror)) {
            String errorMsg = "More than one factory class referenced by models " + this.seenFactoryTypeMirror.toString() + " and " + factoryTypeMirror.toString();
            this.abortWithError(errorMsg, type);
        }
    }

    private void verifyAnnotationConflicts(TypeElement typeElement) {
        LinkedList<String> annotationList = new LinkedList<String>();
        ImmutableList methodElements = new ImmutableList.Builder().addAll(ElementFilter.methodsIn(typeElement.getEnclosedElements())).build();
        for (ExecutableElement executableElement : methodElements) {
            annotationList.clear();
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(executableElement)) {
                String annotationName = annotationMirror.getAnnotationType().toString();
                if (!CompilerUtils.isSupportedAnnotation(annotationMirror.getAnnotationType().toString())) continue;
                for (String a : annotationList) {
                    if (!CompilerUtils.areConflicting(a, annotationName)) continue;
                    this.abortWithError("Annotations " + annotationName + " cannot be used with " + a, typeElement);
                }
                annotationList.add(annotationName);
            }
        }
    }

    private void abortWithError(String msg, Element e) {
        this.reportError(msg, e);
        throw new AbortProcessingException();
    }

    private void reportError(String msg, Element e) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    private boolean implementsAnnotation(TypeElement type) {
        return this.types.isAssignable(type.asType(), this.getTypeMirror(Annotation.class));
    }

    private TypeMirror getTypeMirror(Class<?> cls) {
        return this.elements.getTypeElement(cls.getName()).asType();
    }

    private TypeMirror getTypeMirrorFromAnnotation(Validated validated, TypeElement type) {
        try {
            validated.factory();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        this.reportError("Retrieving class information from annotation did not throw an exception something is wrong.", type);
        throw new AbortProcessingException();
    }
}

