/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave.compiler;

import androidx.annotation.FloatRange;
import androidx.annotation.IntDef;
import androidx.annotation.IntRange;
import androidx.annotation.LongDef;
import androidx.annotation.Size;
import androidx.annotation.StringDef;
import com.squareup.javapoet.MethodSpec;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

final class AnnotationWriter {
    static final String CHECK_SIZE_METHOD_NAME = "isSizeOk";
    static final String CHECK_NULL_METHOD_NAME = "checkNullable";
    static final String CHECK_MUST_BE_TRUE_METHOD_NAME = "mustBeTrue";
    static final String CHECK_MUST_BE_FALSE_METHOD_NAME = "mustBeFalse";
    static final String CHECK_MUST_BE_STRING_DEF_VALUE = "checkStringDef";
    static final String CHECK_MUST_BE_INT_DEF_VALUE = "checkIntDef";
    static final String CHECK_MUST_BE_LONG_DEF_VALUE = "checkLongDef";
    static final String CHECK_INT_RANGE_METHOD_NAME = "checkIntRange";
    static final String CHECK_FLOAT_RANGE_METHOD_NAME = "checkFloatRange";
    static final String MERGE_ERROR_METHOD_NAME = "mergeErrors";
    static final String SET_VALIDATION_ITEM_METHOD_NAME = "setValidatedItemName";
    private static final String LITERAL = "$L";
    private static final String LITERAL_DOUBLE = "$LD";
    private static final String LITERAL_LONG = "$LL";
    private static final String NAMES = "$N";
    private static final String STRING_LITERAL = "$S";
    private final MethodSpec.Builder builder;
    private final MethodSpec getter;
    private final boolean isNullable;
    private final boolean hasNonNullOrNullable;

    AnnotationWriter(MethodSpec.Builder builder, MethodSpec getter, boolean isNullable, boolean hasNonNullOrNullable) {
        this.builder = builder;
        this.getter = getter;
        this.isNullable = isNullable;
        this.hasNonNullOrNullable = hasNonNullOrNullable;
    }

    void writeNullable() {
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(this.getter, CHECK_NULL_METHOD_NAME, false);
        baseWriter.addArg(LITERAL, this.isNullable, true);
        baseWriter.addArg(LITERAL, "context", true);
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    void writeMustBeFalse() {
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(this.getter, CHECK_MUST_BE_FALSE_METHOD_NAME, false);
        baseWriter.addArg(LITERAL, "context", true);
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    void writeMustBeTrue() {
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(this.getter, CHECK_MUST_BE_TRUE_METHOD_NAME, false);
        baseWriter.addArg(LITERAL, "context", true);
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    void write(@Nullable Size size) {
        long max;
        long min;
        this.checkAnnotationNotNull((Annotation)size);
        if (size.value() >= 0L) {
            max = min = size.value();
        } else {
            min = size.min();
            max = size.max();
        }
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(this.getter, CHECK_SIZE_METHOD_NAME, false);
        baseWriter.addArg(LITERAL, this.isNullable, true);
        baseWriter.addArg(LITERAL_LONG, min, true);
        baseWriter.addArg(LITERAL_LONG, max, true);
        baseWriter.addArg(LITERAL_LONG, size.multiple(), true);
        baseWriter.addArg(LITERAL, "context", true);
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    void write(@Nullable StringDef stringDef) {
        this.checkAnnotationNotNull((Annotation)stringDef);
        boolean isStringDefNullable = this.hasNonNullOrNullable && this.isNullable;
        String[] acceptableStrings = stringDef.value();
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(CHECK_MUST_BE_STRING_DEF_VALUE);
        baseWriter.addArg(LITERAL, isStringDefNullable, false);
        baseWriter.addArg(LITERAL, "context", true);
        baseWriter.addGetterCall(this.getter, LITERAL);
        for (String string : acceptableStrings) {
            baseWriter.addArg(STRING_LITERAL, string, true);
        }
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    void write(@Nullable IntDef intDef) {
        int[] acceptableInts;
        this.checkAnnotationNotNull((Annotation)intDef);
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(this.getter, CHECK_MUST_BE_INT_DEF_VALUE, true);
        baseWriter.addArg(LITERAL, intDef.flag(), true);
        for (int intVal : acceptableInts = intDef.value()) {
            baseWriter.addArg(LITERAL, intVal, true);
        }
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    void write(@Nullable LongDef longDef) {
        long[] acceptableInts;
        this.checkAnnotationNotNull((Annotation)longDef);
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(this.getter, CHECK_MUST_BE_LONG_DEF_VALUE, true);
        baseWriter.addArg(LITERAL, longDef.flag(), true);
        for (long longVal : acceptableInts = longDef.value()) {
            baseWriter.addArg(LITERAL_LONG, longVal, true);
        }
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    void write(@Nullable IntRange intRange) {
        this.checkAnnotationNotNull((Annotation)intRange);
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(this.getter, CHECK_INT_RANGE_METHOD_NAME, true);
        baseWriter.addArg(LITERAL_LONG, intRange.from(), true);
        baseWriter.addArg(LITERAL_LONG, intRange.to(), true);
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    void write(@Nullable FloatRange floatRange) {
        this.checkAnnotationNotNull((Annotation)floatRange);
        BaseAnnotationWriter baseWriter = new BaseAnnotationWriter(this.getter, CHECK_FLOAT_RANGE_METHOD_NAME, true);
        if (Double.isInfinite(floatRange.from())) {
            baseWriter.addArg("Double.NEGATIVE_INFINITY", null, true);
        } else {
            baseWriter.addArg(LITERAL_DOUBLE, floatRange.from(), true);
        }
        if (Double.isInfinite(floatRange.to())) {
            baseWriter.addArg("Double.POSITIVE_INFINITY", null, true);
        } else {
            baseWriter.addArg(LITERAL_DOUBLE, floatRange.to(), true);
        }
        this.buildStatements(baseWriter.getFormattedString(), baseWriter.getArgs());
    }

    private void checkAnnotationNotNull(@Nullable Annotation annotation) {
        if (annotation == null) {
            throw new RuntimeException("For method " + this.getter.name + " annotation is empty");
        }
    }

    private void buildStatements(String statementFormat, Object ... objects) {
        this.builder.addStatement("$L.$L($S)", new Object[]{"context", SET_VALIDATION_ITEM_METHOD_NAME, this.getter.name + "()"});
        this.builder.addStatement(statementFormat, objects);
    }

    private static final class BaseAnnotationWriter {
        private final StringBuilder builder = new StringBuilder();
        private final List<Object> args = new ArrayList<Object>();

        private BaseAnnotationWriter(MethodSpec getter, String checkMethodName, boolean contextFirst) {
            this.addArg("$L = ", "raveErrors", false);
            this.addArg("$L(", AnnotationWriter.MERGE_ERROR_METHOD_NAME, false);
            this.addArg(AnnotationWriter.LITERAL, "raveErrors", false);
            this.addArg("$L(", checkMethodName, true);
            if (contextFirst) {
                this.addArg(AnnotationWriter.LITERAL, "context", false);
            }
            this.addArg("$L.", "object", contextFirst);
            this.addArg("$N()", getter, false);
        }

        private BaseAnnotationWriter(String checkMethodName) {
            this.addArg("$L = ", "raveErrors", false);
            this.addArg("$L(", AnnotationWriter.MERGE_ERROR_METHOD_NAME, false);
            this.addArg(AnnotationWriter.LITERAL, "raveErrors", false);
            this.addArg("$L(", checkMethodName, true);
        }

        private void addGetterCall(MethodSpec getter, String format) {
            this.addArg(format + ".", "object", true);
            this.addArg("$N()", getter, false);
        }

        void addArg(String format, @Nullable Object arg, boolean addSeparatorBefore) {
            if (addSeparatorBefore) {
                this.builder.append(", ");
            }
            this.builder.append(format);
            if (arg != null) {
                this.args.add(arg);
            }
        }

        String getFormattedString() {
            this.builder.append("))");
            return this.builder.toString();
        }

        Object[] getArgs() {
            return this.args.toArray(new Object[this.args.size()]);
        }
    }
}

