/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave.compiler;

import com.uber.rave.compiler.CompilerUtils;
import com.uber.rave.compiler.MethodIR;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class ClassIR {
    private final List<MethodIR> methodIRs = new ArrayList<MethodIR>();
    private final List<TypeMirror> inheritedTypes = new ArrayList<TypeMirror>();
    private final TypeMirror typeMirror;

    ClassIR(TypeMirror typeMirror) {
        this.typeMirror = typeMirror;
    }

    void addMethodIR(MethodIR methodIRs) {
        this.methodIRs.add(methodIRs);
    }

    List<MethodIR> getAllMethods() {
        return this.methodIRs;
    }

    TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    void addInheritedTypes(TypeMirror typeMirror, Types typesUtils) {
        if (!CompilerUtils.typeMirrorInCollection(this.inheritedTypes, typeMirror, typesUtils)) {
            this.inheritedTypes.add(typeMirror);
        }
    }

    List<TypeMirror> getInheritedTypes() {
        return this.inheritedTypes;
    }
}

