/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave.compiler;

import androidx.annotation.FloatRange;
import androidx.annotation.IntDef;
import androidx.annotation.IntRange;
import androidx.annotation.LongDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.StringDef;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.uber.rave.annotation.MustBeFalse;
import com.uber.rave.annotation.MustBeTrue;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class CompilerUtils {
    private static final List<Class<? extends Annotation>> SUPPORT_ANNOTATIONS = ImmutableList.of(NonNull.class, Nullable.class, Size.class, MustBeFalse.class, MustBeTrue.class, StringDef.class, IntDef.class, LongDef.class, IntRange.class, FloatRange.class);
    private static final List<Pair<Class<? extends Annotation>, Class<? extends Annotation>>> CONFLICTING_SUPPORT_ANNOTATIONS = ImmutableList.of(new Pair<Class<MustBeTrue>, Class<MustBeFalse>>(MustBeTrue.class, MustBeFalse.class), new Pair<Class<IntRange>, Class<IntDef>>(IntRange.class, IntDef.class), new Pair<Class<IntRange>, Class<LongDef>>(IntRange.class, LongDef.class));
    private static Map<Class<? extends Annotation>, Set<Class<? extends Annotation>>> sConflictingAnnotations;
    private static Map<String, Class<? extends Annotation>> sAnnotationMap;

    private CompilerUtils() {
    }

    private static void build(Map<Class<? extends Annotation>, ImmutableSet.Builder<Class<? extends Annotation>>> temp, Class<? extends Annotation> annotation1, Class<? extends Annotation> annotation2) {
        ImmutableSet.Builder builder = temp.get(annotation1);
        if (builder == null) {
            builder = new ImmutableSet.Builder();
            temp.put(annotation1, (ImmutableSet.Builder<Class<? extends Annotation>>)builder);
        }
        builder.add(annotation2);
    }

    private static void init() {
        ImmutableMap.Builder annotationBuilder = ImmutableMap.builder();
        for (Class<? extends Annotation> clazz : SUPPORT_ANNOTATIONS) {
            annotationBuilder.put((Object)clazz.getCanonicalName(), clazz);
        }
        sAnnotationMap = annotationBuilder.build();
        HashMap<Class<? extends Annotation>, ImmutableSet.Builder<Class<? extends Annotation>>> mapBuilder = new HashMap<Class<? extends Annotation>, ImmutableSet.Builder<Class<? extends Annotation>>>();
        for (Pair<Class<? extends Annotation>, Class<? extends Annotation>> pair : CONFLICTING_SUPPORT_ANNOTATIONS) {
            CompilerUtils.build(mapBuilder, (Class)pair.first, (Class)pair.second);
            CompilerUtils.build(mapBuilder, (Class)pair.second, (Class)pair.first);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class<? extends Annotation> annotation : SUPPORT_ANNOTATIONS) {
            ImmutableSet.Builder conflicting = (ImmutableSet.Builder)mapBuilder.get(annotation);
            if (conflicting == null) {
                conflicting = new ImmutableSet.Builder();
            }
            builder.put(annotation, (Object)conflicting.build());
        }
        sConflictingAnnotations = builder.build();
    }

    static boolean typeMirrorInCollection(Collection<TypeMirror> typeCollection, TypeMirror typeMirror, Types typesUtils) {
        for (TypeMirror mirror : typeCollection) {
            if (!typesUtils.isSameType(mirror, typeMirror)) continue;
            return true;
        }
        return false;
    }

    static boolean isSupportAnnotation(String annotationName) {
        return sAnnotationMap.containsKey(annotationName);
    }

    static boolean isSupportedAnnotation(String annotationName) {
        return annotationName.toLowerCase().contains("nullable") || annotationName.toLowerCase().contains("nonnull") || CompilerUtils.isSupportAnnotation(annotationName);
    }

    static Class<? extends Annotation> getSupportAnnotation(String annotationName) {
        return sAnnotationMap.get(annotationName);
    }

    static boolean areConflicting(String annotation1, String annotation2) {
        String a1 = annotation1.toLowerCase();
        String a2 = annotation2.toLowerCase();
        if (a1.contains("nullable") && a2.contains("nonnull") || a1.contains("nonnull") && a2.contains("nullable")) {
            return true;
        }
        Set<Class<? extends Annotation>> set = sConflictingAnnotations.get(CompilerUtils.getSupportAnnotation(annotation1));
        return set.contains(CompilerUtils.getSupportAnnotation(annotation2));
    }

    static String packageNameOf(Element type) {
        Element enclosing;
        while (!((enclosing = type.getEnclosingElement()) instanceof PackageElement)) {
            type = enclosing;
        }
        return ((PackageElement)enclosing).getQualifiedName().toString();
    }

    static {
        CompilerUtils.init();
    }

    private static final class Pair<A, B> {
        final A first;
        final B second;

        Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }
    }
}

