/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave.compiler;

import androidx.annotation.IntDef;
import androidx.annotation.LongDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringDef;
import com.google.common.collect.ImmutableList;
import com.uber.rave.Validator;
import com.uber.rave.annotation.Excluded;
import com.uber.rave.annotation.Validated;
import com.uber.rave.compiler.AbortProcessingException;
import com.uber.rave.compiler.AnnotationVerifier;
import com.uber.rave.compiler.ClassIR;
import com.uber.rave.compiler.CompilerUtils;
import com.uber.rave.compiler.MethodIR;
import com.uber.rave.compiler.RaveIR;
import com.uber.rave.compiler.RaveWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public final class RaveProcessor
extends AbstractProcessor {
    private Messager messager;
    private Elements elementUtils;
    private Types typesUtils;
    private TypeMirror factoryTypeMirror;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>(2);
        annotations.add(Validated.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.elementUtils = this.processingEnv.getElementUtils();
        this.messager = this.processingEnv.getMessager();
        this.typesUtils = this.processingEnv.getTypeUtils();
        if (roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(Validated.class);
        if (annotatedElements.isEmpty()) {
            return false;
        }
        ImmutableList annotatedTypes = new ImmutableList.Builder().addAll(ElementFilter.typesIn(annotatedElements)).build();
        try {
            RaveIR raveIR = this.verify((List<TypeElement>)annotatedTypes);
            this.process(raveIR, (List<TypeElement>)annotatedTypes);
            this.generateSource(raveIR);
        }
        catch (AbortProcessingException e) {
            return false;
        }
        catch (Throwable e) {
            this.error(null, "Error in " + this.getClass().getSimpleName() + ":" + e, new Object[0]);
        }
        return false;
    }

    private void generateSource(RaveIR raveIR) throws IOException {
        Filer filer = this.processingEnv.getFiler();
        RaveWriter raveWriter = new RaveWriter(filer, this.typesUtils, this.processingEnv.getElementUtils());
        raveWriter.generateJava(raveIR);
    }

    private void process(RaveIR raveIR, List<TypeElement> allTypes) {
        for (TypeElement typeElement : allTypes) {
            raveIR.addClassIR(this.extractClassInfo(typeElement, raveIR.getMode()));
        }
    }

    private ClassIR extractClassInfo(TypeElement typeElement, Validator.Mode mode) {
        ClassIR classIR = new ClassIR(this.typesUtils.erasure(typeElement.asType()));
        this.traverseInheritanceTree(typeElement, classIR);
        ImmutableList methodElements = new ImmutableList.Builder().addAll(ElementFilter.methodsIn(typeElement.getEnclosedElements())).build();
        String classPackage = CompilerUtils.packageNameOf(typeElement);
        boolean samePackage = classPackage.equals(CompilerUtils.packageNameOf(this.typesUtils.asElement(this.factoryTypeMirror)));
        for (ExecutableElement executableElement : methodElements) {
            if (!executableElement.getParameters().isEmpty() || executableElement.getModifiers().contains((Object)Modifier.STATIC) || executableElement.getReturnType().getKind().equals((Object)TypeKind.VOID) || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) && !samePackage || executableElement.getAnnotation(Excluded.class) != null) continue;
            MethodIR methodIR = new MethodIR(executableElement.getSimpleName().toString());
            for (AnnotationMirror annotationMirror : this.elementUtils.getAllAnnotationMirrors(executableElement)) {
                Annotation annotation;
                String annotationName = annotationMirror.getAnnotationType().toString();
                if (CompilerUtils.isSupportAnnotation(annotationMirror.getAnnotationType().toString())) {
                    annotation = executableElement.getAnnotation(CompilerUtils.getSupportAnnotation(annotationName));
                    methodIR.addAnnotation(annotation);
                    continue;
                }
                if (annotationMirror.getAnnotationType().asElement().getSimpleName().toString().toLowerCase().equals("nullable")) {
                    methodIR.addAnnotation(() -> Nullable.class);
                    continue;
                }
                if (annotationMirror.getAnnotationType().asElement().getSimpleName().toString().toLowerCase().equals("nonnull")) {
                    methodIR.addAnnotation(() -> NonNull.class);
                    continue;
                }
                annotation = this.extractDefTypeAnnotations(annotationMirror.getAnnotationType().asElement());
                if (annotation == null) continue;
                methodIR.addAnnotation(annotation);
            }
            this.addImplicitNullnessAnnotations(methodIR, mode, executableElement);
            classIR.addMethodIR(methodIR);
        }
        return classIR;
    }

    private void addImplicitNullnessAnnotations(MethodIR methodIR, Validator.Mode mode, ExecutableElement executableElement) {
        if (methodIR.hasAnyAnnotation() || executableElement.getReturnType().getKind().isPrimitive()) {
            return;
        }
        switch (mode) {
            case DEFAULT: {
                methodIR.addAnnotation(() -> Nullable.class);
                break;
            }
            case STRICT: {
                methodIR.addAnnotation(() -> NonNull.class);
                break;
            }
            default: {
                this.error(executableElement, "Unhandled validation mode for method: %s", methodIR.getMethodGetterName());
            }
        }
    }

    @javax.annotation.Nullable
    private Annotation extractDefTypeAnnotations(Element element) {
        StringDef annotation = element.getAnnotation(StringDef.class);
        if (annotation != null) {
            return annotation;
        }
        annotation = element.getAnnotation(IntDef.class);
        if (annotation != null) {
            return annotation;
        }
        annotation = element.getAnnotation(LongDef.class);
        if (annotation != null) {
            return annotation;
        }
        return null;
    }

    private void traverseInheritanceTree(TypeElement typeElement, ClassIR classIR) {
        TypeMirror mirror = typeElement.getSuperclass();
        if (!(mirror instanceof NoType)) {
            TypeElement parentClass = (TypeElement)this.typesUtils.asElement(mirror);
            if (parentClass.getAnnotation(Validated.class) != null) {
                classIR.addInheritedTypes(parentClass.asType(), this.typesUtils);
            } else {
                this.traverseInheritanceTree(parentClass, classIR);
            }
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            TypeElement inheritedInterface = (TypeElement)this.typesUtils.asElement(typeMirror);
            if (inheritedInterface.getAnnotation(Validated.class) != null) {
                classIR.addInheritedTypes(inheritedInterface.asType(), this.typesUtils);
                continue;
            }
            this.traverseInheritanceTree(inheritedInterface, classIR);
        }
    }

    private RaveIR verify(List<TypeElement> types) {
        AnnotationVerifier verifier = new AnnotationVerifier(this.messager, this.elementUtils, this.typesUtils);
        for (TypeElement type : types) {
            verifier.verify(type);
        }
        this.factoryTypeMirror = verifier.getSeenFactoryTypeMirror();
        TypeElement element = (TypeElement)this.typesUtils.asElement(this.factoryTypeMirror);
        Validator strategy = element.getAnnotation(Validator.class);
        return new RaveIR(CompilerUtils.packageNameOf(element), element.getSimpleName().toString(), strategy == null ? Validator.Mode.DEFAULT : strategy.mode());
    }

    private void error(@javax.annotation.Nullable Element e, String msg, Object ... args) {
        if (e == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
        }
    }
}

