/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave.compiler;

import androidx.annotation.FloatRange;
import androidx.annotation.IntDef;
import androidx.annotation.IntRange;
import androidx.annotation.LongDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.StringDef;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import com.uber.rave.BaseValidator;
import com.uber.rave.InvalidModelException;
import com.uber.rave.RaveError;
import com.uber.rave.annotation.MustBeFalse;
import com.uber.rave.annotation.MustBeTrue;
import com.uber.rave.compiler.AnnotationWriter;
import com.uber.rave.compiler.ClassIR;
import com.uber.rave.compiler.MethodIR;
import com.uber.rave.compiler.RaveIR;
import com.uber.rave.compiler.RaveProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class RaveWriter {
    static final String VALIDATE_METHOD_NAME = "validateAs";
    static final String ADD_SUPPORTED_CLASS_METHOD_NAME = "addSupportedClass";
    static final String RE_EVAL_SUPERTYPE_METHOD_NAME = "reEvaluateAsSuperType";
    static final String MERGE_ERROR_METHOD_NAME = "mergeErrors";
    static final String VALIDATE_METHOD_ARG_NAME = "object";
    static final String GENERATED_CLASS_POSTFIX = "_Generated_Validator";
    static final Class<? extends Exception> RAVE_INVALID_MODEL_EXCEPTION_CLASS = InvalidModelException.class;
    static final String RAVE_ERROR_ARG_NAME = "raveErrors";
    static final String VALIDATE_METHOD_CLAZZ_ARG_NAME = "clazz";
    static final String VALIDATION_CONTEXT_ARG_NAME = "context";
    private static final ParameterizedTypeName CLASS_PARAMETERIZED_TYPE_NAME = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.get(Object.class))});
    private static final String GENERATED_COMMENTS = "https://github.com/uber-common/rave";
    private static final AnnotationSpec GENERATED = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{RaveProcessor.class.getName()}).addMember("comments", "$S", new Object[]{"https://github.com/uber-common/rave"}).build();
    private final Filer filer;
    private final Types typeUtils;
    private final boolean generatedAnnotationAvailable;

    protected RaveWriter(Filer filer, Types typesUtils, Elements elements) {
        this.filer = filer;
        this.typeUtils = typesUtils;
        this.generatedAnnotationAvailable = elements.getTypeElement("javax.annotation.Generated") != null;
    }

    public void generateJava(RaveIR raveIR) throws IOException {
        List<MethodSpec> allMethods = this.generateSubtypeValidationMethods(raveIR);
        allMethods.add(this.generateConstructor(raveIR));
        String className = raveIR.getSimpleName() + GENERATED_CLASS_POSTFIX;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className);
        builder.superclass(BaseValidator.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethods(allMethods);
        if (this.generatedAnnotationAvailable) {
            builder.addAnnotation(GENERATED);
        }
        TypeSpec validatorClass = builder.build();
        JavaFile.builder((String)raveIR.getPackageName(), (TypeSpec)validatorClass).build().writeTo(this.filer);
    }

    private MethodSpec generateConstructor(RaveIR raveIR) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        for (ClassIR classIR : raveIR.getClassIRs()) {
            builder.addStatement("$L($T.class)", new Object[]{ADD_SUPPORTED_CLASS_METHOD_NAME, classIR.getTypeMirror()});
        }
        builder.addStatement("registerSelf()", new Object[0]);
        return builder.build();
    }

    private List<MethodSpec> generateSubtypeValidationMethods(RaveIR raveIR) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)VALIDATE_METHOD_NAME).addException(RAVE_INVALID_MODEL_EXCEPTION_CLASS).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addAnnotation(Override.class).addParameter(ParameterSpec.builder(Object.class, (String)VALIDATE_METHOD_ARG_NAME, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)CLASS_PARAMETERIZED_TYPE_NAME, (String)VALIDATE_METHOD_CLAZZ_ARG_NAME, (Modifier[])new Modifier[0]).build());
        builder.beginControlFlow("if (!$L.isInstance($L))", new Object[]{VALIDATE_METHOD_CLAZZ_ARG_NAME, VALIDATE_METHOD_ARG_NAME});
        builder.addStatement("throw new $T($L.getClass().getCanonicalName() + $S + $L.getCanonicalName())", new Object[]{IllegalArgumentException.class, VALIDATE_METHOD_ARG_NAME, "is not of type", VALIDATE_METHOD_CLAZZ_ARG_NAME});
        builder.endControlFlow();
        ArrayList<MethodSpec> concreteSpecs = new ArrayList<MethodSpec>(raveIR.getNumClasses());
        for (ClassIR classIR : raveIR.getClassIRs()) {
            MethodSpec specificSpec = this.generateConcreteMethodSpec(classIR);
            concreteSpecs.add(specificSpec);
            builder.beginControlFlow("if ($L.equals($T.class))", new Object[]{VALIDATE_METHOD_CLAZZ_ARG_NAME, classIR.getTypeMirror()});
            builder.addStatement("$L(($T) $L)", new Object[]{VALIDATE_METHOD_NAME, classIR.getTypeMirror(), VALIDATE_METHOD_ARG_NAME});
            builder.addStatement("return", new Object[0]);
            builder.endControlFlow();
        }
        builder.addStatement(" throw new $T($L.getClass().getCanonicalName() + $S + this.getClass().getCanonicalName())", new Object[]{IllegalArgumentException.class, VALIDATE_METHOD_ARG_NAME, " is not supported by validator "});
        ArrayList<MethodSpec> allSpecs = new ArrayList<MethodSpec>();
        allSpecs.add(builder.build());
        allSpecs.addAll(concreteSpecs);
        return allSpecs;
    }

    private MethodSpec generateConcreteMethodSpec(ClassIR classIR) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)VALIDATE_METHOD_NAME).addException(RAVE_INVALID_MODEL_EXCEPTION_CLASS).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(Void.TYPE).addParameter(TypeName.get((TypeMirror)classIR.getTypeMirror()), VALIDATE_METHOD_ARG_NAME, new Modifier[0]);
        builder.addStatement("$T $L = getValidationContext($T.class)", new Object[]{BaseValidator.ValidationContext.class, VALIDATION_CONTEXT_ARG_NAME, classIR.getTypeMirror()});
        builder.addStatement("$T<$T> $L = null", new Object[]{List.class, RaveError.class, RAVE_ERROR_ARG_NAME});
        for (TypeMirror mirror : classIR.getInheritedTypes()) {
            builder.addStatement("$L = $L($L, $L($T.class, $L))", new Object[]{RAVE_ERROR_ARG_NAME, MERGE_ERROR_METHOD_NAME, RAVE_ERROR_ARG_NAME, RE_EVAL_SUPERTYPE_METHOD_NAME, this.typeUtils.erasure(mirror), VALIDATE_METHOD_ARG_NAME});
        }
        for (MethodIR methodIR : classIR.getAllMethods()) {
            this.buildAnnotationChecks(builder, methodIR);
        }
        builder.beginControlFlow("if ($L != null && !$L.isEmpty())", new Object[]{RAVE_ERROR_ARG_NAME, RAVE_ERROR_ARG_NAME});
        builder.addStatement("throw new $T($L)", new Object[]{RAVE_INVALID_MODEL_EXCEPTION_CLASS, RAVE_ERROR_ARG_NAME});
        builder.endControlFlow();
        return builder.build();
    }

    private void buildAnnotationChecks(MethodSpec.Builder builder, MethodIR methodIR) {
        boolean isNullable = !methodIR.hasAnnotation(NonNull.class);
        boolean hasNonNullOrNullable = methodIR.hasAnnotation(NonNull.class) || methodIR.hasAnnotation(Nullable.class);
        AnnotationWriter writer = new AnnotationWriter(builder, MethodSpec.methodBuilder((String)methodIR.getMethodGetterName()).build(), isNullable, hasNonNullOrNullable);
        if (hasNonNullOrNullable && !methodIR.hasAnnotation(Size.class) && !methodIR.hasAnnotation(StringDef.class)) {
            writer.writeNullable();
        }
        if (methodIR.hasAnnotation(Size.class)) {
            writer.write(methodIR.getAnnotation(Size.class));
        }
        if (methodIR.hasAnnotation(MustBeFalse.class)) {
            writer.writeMustBeFalse();
        }
        if (methodIR.hasAnnotation(MustBeTrue.class)) {
            writer.writeMustBeTrue();
        }
        if (methodIR.hasAnnotation(StringDef.class)) {
            writer.write(methodIR.getAnnotation(StringDef.class));
        }
        if (methodIR.hasAnnotation(IntDef.class)) {
            writer.write(methodIR.getAnnotation(IntDef.class));
        }
        if (methodIR.hasAnnotation(IntRange.class)) {
            writer.write(methodIR.getAnnotation(IntRange.class));
        }
        if (methodIR.hasAnnotation(FloatRange.class)) {
            writer.write(methodIR.getAnnotation(FloatRange.class));
        }
        if (methodIR.hasAnnotation(LongDef.class)) {
            writer.write(methodIR.getAnnotation(LongDef.class));
        }
    }
}

