/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave;

import com.uber.rave.Rave;
import com.uber.rave.RaveError;
import com.uber.rave.RaveException;
import com.uber.rave.UnsupportedObjectException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class BaseValidator {
    private final HashSet<Class<?>> supportedClasses = new HashSet();

    protected BaseValidator() {
    }

    final void validate(Object object) throws RaveException {
        Class<?> clazz = object.getClass();
        if (!this.supportedClasses.contains(clazz)) {
            throw new IllegalArgumentException(clazz.getCanonicalName() + ":" + "Is not supported by validation.");
        }
        this.validateAs(object, clazz);
    }

    protected final Set<Class<?>> getSupportedClasses() {
        return this.supportedClasses;
    }

    protected abstract void validateAs(Object var1, Class<?> var2) throws RaveException;

    @Nullable
    protected final List<RaveError> reEvaluateAsSuperType(Class<?> clazz, Object obj) {
        try {
            Rave.getInstance().validateAs(obj, clazz);
        }
        catch (RaveException e) {
            return e.errors;
        }
        return null;
    }

    protected final void registerSelf() {
        Rave.getInstance().registerValidator(this, this.supportedClasses);
    }

    protected final void addSupportedClass(Class<?> clazz) {
        this.supportedClasses.add(clazz);
    }

    protected static ValidationContext getValidationContext(Class<?> clazz) {
        return new ValidationContext(clazz);
    }

    @Nullable
    protected static List<RaveError> mustBeFalse(boolean input, ValidationContext validationContext) {
        if (input) {
            LinkedList<RaveError> list = new LinkedList<RaveError>();
            list.add(new RaveError(validationContext, "Is not false."));
            return list;
        }
        return null;
    }

    protected static List<RaveError> isSizeOk(@Nullable String string, boolean isNullable, long min, long max, long multiple, ValidationContext validationContext) {
        List<RaveError> errors = BaseValidator.checkNullable(string, isNullable, validationContext);
        if (string == null) {
            return errors;
        }
        int stringSize = string.length();
        errors = BaseValidator.testMultipleParameter(multiple, stringSize, validationContext, "String", errors);
        if ((long)stringSize <= max && (long)stringSize >= min) {
            return errors;
        }
        String msg = "String size out of bounds. Size is: " + string.length() + " when should be between " + min + " and " + max;
        return BaseValidator.appendError(validationContext, msg, errors);
    }

    protected static List<RaveError> isSizeOk(@Nullable Collection<?> collection, boolean isNullable, long min, long max, long multiple, ValidationContext validationContext) {
        List<RaveError> raveErrors = BaseValidator.checkNullable(collection, isNullable, validationContext);
        if (collection == null) {
            return raveErrors;
        }
        int collectionSize = collection.size();
        raveErrors = BaseValidator.testMultipleParameter(multiple, collectionSize, validationContext, collection.getClass().getCanonicalName(), raveErrors);
        if ((long)collectionSize <= max && (long)collectionSize >= min) {
            return raveErrors;
        }
        String msg = collection.getClass().getCanonicalName() + " is not within bounds min:" + min + " max:" + max;
        return BaseValidator.appendError(validationContext, msg, raveErrors);
    }

    @Nullable
    protected static <T> List<RaveError> isSizeOk(@Nullable T[] array, boolean isNullable, long min, long max, long multiple, ValidationContext validationContext) {
        List<RaveError> raveErrors = BaseValidator.checkNullable(array, isNullable, validationContext);
        if (array == null) {
            return raveErrors;
        }
        raveErrors = BaseValidator.testMultipleParameter(multiple, array.length, validationContext, "", raveErrors);
        if ((long)array.length <= max && (long)array.length >= min) {
            return raveErrors;
        }
        String msg = "With size" + array.length + " is not within bounds min:" + min + " and max:" + max;
        return BaseValidator.appendError(validationContext, msg, raveErrors);
    }

    @Nullable
    protected static <K, V> List<RaveError> isSizeOk(@Nullable Map<K, V> map, boolean isNullable, long min, long max, long multiple, ValidationContext validationContext) {
        List<RaveError> raveErrors = BaseValidator.checkNullable(map, isNullable, validationContext);
        if (map == null) {
            return raveErrors;
        }
        raveErrors = BaseValidator.testMultipleParameter(multiple, map.size(), validationContext, "", raveErrors);
        if ((long)map.size() <= max && (long)map.size() >= min) {
            return raveErrors;
        }
        String msg = "With size " + map.size() + " is not within bounds min: " + min + " and max: " + max;
        return BaseValidator.appendError(validationContext, msg, raveErrors);
    }

    protected static List<RaveError> checkNullable(@Nullable Object obj, boolean isNullable, ValidationContext validationContext) {
        if (obj == null) {
            if (isNullable) {
                return Collections.emptyList();
            }
            LinkedList<RaveError> errors = new LinkedList<RaveError>();
            errors.add(new RaveError(validationContext.clazz, validationContext.validatedItemName, "Item is null and shouldn't be."));
            return errors;
        }
        if (!(obj instanceof String)) {
            try {
                Rave.getInstance().validate(obj);
            }
            catch (UnsupportedObjectException e) {
                return Collections.emptyList();
            }
            catch (RaveException e) {
                return BaseValidator.appendErrors(e, null);
            }
        }
        return Collections.emptyList();
    }

    protected static List<RaveError> checkNullable(@Nullable Collection<?> collection, boolean isNullable, ValidationContext validationContext) {
        List<RaveError> errors = BaseValidator.checkNullable(collection, isNullable, validationContext);
        return collection == null ? errors : BaseValidator.checkIterable(collection, errors);
    }

    protected static <T> List<RaveError> checkNullable(@Nullable T[] array, boolean isNullable, ValidationContext validationContext) {
        List<RaveError> errors = BaseValidator.checkNullable(array, isNullable, validationContext);
        if (array == null) {
            return errors;
        }
        Rave rave = Rave.getInstance();
        for (T type : array) {
            if (type == null) continue;
            try {
                rave.validate(type);
            }
            catch (UnsupportedObjectException e) {
                return errors;
            }
            catch (RaveException e) {
                errors = BaseValidator.appendErrors(e, errors);
            }
        }
        return errors;
    }

    protected static <K, V> List<RaveError> checkNullable(@Nullable Map<K, V> map, boolean isNullable, ValidationContext validationContext) {
        List<RaveError> errors = BaseValidator.checkNullable(map, isNullable, validationContext);
        if (map == null) {
            return errors;
        }
        errors = BaseValidator.checkIterable(map.keySet(), errors);
        return BaseValidator.checkIterable(map.values(), errors);
    }

    @Nullable
    protected static List<RaveError> mergeErrors(@Nullable List<RaveError> e1, @Nullable List<RaveError> e2) {
        if (e1 == null || e1.isEmpty()) {
            return e2;
        }
        if (e2 == null || e2.isEmpty()) {
            return e1;
        }
        e1.addAll(e2);
        return e1;
    }

    protected static List<RaveError> mustBeTrue(boolean input, ValidationContext validationContext) {
        return input ? Collections.emptyList() : BaseValidator.createNewList(new RaveError(validationContext, "Is not true."));
    }

    protected static List<RaveError> checkStringDef(boolean isNullable, ValidationContext validationContext, @Nullable String value, String ... acceptableValues) {
        List<RaveError> errors = BaseValidator.checkNullable(value, isNullable, validationContext);
        if (value == null) {
            return errors;
        }
        for (String string : acceptableValues) {
            if (!value.equals(string)) continue;
            return Collections.emptyList();
        }
        return BaseValidator.createStringDefError(value, acceptableValues, validationContext);
    }

    protected static List<RaveError> checkStringDef(boolean isNullable, ValidationContext validationContext, @Nullable Collection<String> values, String ... acceptableValues) {
        List<RaveError> errors = BaseValidator.checkNullable(values, isNullable, validationContext);
        if (values == null) {
            return errors;
        }
        for (String s : values) {
            errors = BaseValidator.mergeErrors(errors, BaseValidator.checkStringDef(false, validationContext, s, acceptableValues));
        }
        return errors == null ? Collections.emptyList() : errors;
    }

    protected static List<RaveError> checkStringDef(boolean isNullable, ValidationContext validationContext, @Nullable String[] values, String ... acceptableValues) {
        List<RaveError> errors = BaseValidator.checkNullable(values, isNullable, validationContext);
        if (values == null) {
            return errors;
        }
        for (String s : values) {
            errors = BaseValidator.mergeErrors(errors, BaseValidator.checkStringDef(false, validationContext, s, acceptableValues));
        }
        return errors == null ? Collections.emptyList() : errors;
    }

    protected static List<RaveError> checkFloatRange(ValidationContext validationContext, double value, double from, double to) {
        boolean upperIsOk;
        boolean lowerIsOk = from == Double.NEGATIVE_INFINITY || value >= from;
        boolean bl = upperIsOk = to == Double.POSITIVE_INFINITY || value <= to;
        if (lowerIsOk && upperIsOk) {
            return Collections.emptyList();
        }
        return BaseValidator.createNewList(new RaveError(validationContext, value + " " + "Does not conform to the following @FloatRange values:" + " which should be between " + from + " and " + to));
    }

    protected static List<RaveError> checkIntRange(ValidationContext validationContext, long value, long from, long to) {
        if (value <= to && value >= from) {
            return Collections.emptyList();
        }
        return BaseValidator.createNewList(new RaveError(validationContext, value + " " + "Does not conform to the following @IntRange values:" + " which should be between " + from + " and " + to));
    }

    protected static List<RaveError> checkIntDef(ValidationContext validationContext, int value, boolean flag, int ... acceptableValues) {
        for (int acceptable : acceptableValues) {
            if (value != acceptable) continue;
            return Collections.emptyList();
        }
        return BaseValidator.createIntDefError(value, acceptableValues, validationContext);
    }

    protected static List<RaveError> checkLongDef(ValidationContext validationContext, long value, boolean flag, long ... acceptableValues) {
        for (long acceptable : acceptableValues) {
            if (value != acceptable) continue;
            return Collections.emptyList();
        }
        return BaseValidator.createLongDefError(value, acceptableValues, validationContext);
    }

    private static <T> List<RaveError> checkIterable(Iterable<T> iterable, @Nullable List<RaveError> errors) {
        Rave rave = Rave.getInstance();
        for (T type : iterable) {
            if (type == null) continue;
            try {
                rave.validate(type);
            }
            catch (UnsupportedObjectException e) {
                return errors == null ? Collections.emptyList() : errors;
            }
            catch (RaveException e) {
                errors = BaseValidator.appendErrors(e, errors);
            }
        }
        return errors == null ? Collections.emptyList() : errors;
    }

    private static List<RaveError> appendErrors(@Nullable RaveException e, @Nullable List<RaveError> errors) {
        if (errors == null) {
            errors = new LinkedList<RaveError>();
        }
        if (e == null) {
            return errors;
        }
        try {
            errors.addAll(e.errors);
        }
        catch (UnsupportedOperationException e1) {
            LinkedList<RaveError> errorList = new LinkedList<RaveError>();
            errorList.addAll(e.errors);
            errorList.addAll(errors);
            return errorList;
        }
        return errors;
    }

    private static List<RaveError> appendError(ValidationContext validationContext, String msg, @Nullable List<RaveError> raveErrors) {
        if (raveErrors == null || raveErrors.isEmpty()) {
            return BaseValidator.createNewList(new RaveError(validationContext, msg));
        }
        raveErrors.add(new RaveError(validationContext, msg));
        return raveErrors;
    }

    private static List<RaveError> createNewList(RaveError error) {
        LinkedList<RaveError> errors = new LinkedList<RaveError>();
        errors.add(error);
        return errors;
    }

    private static List<RaveError> testMultipleParameter(long multiple, int size, ValidationContext validationContext, String elementType, List<RaveError> raveErrors) {
        if (multiple >= 0L && (long)size % multiple != 0L) {
            String msg = elementType + " is not a multiple of " + multiple + ", size is " + size;
            raveErrors = BaseValidator.appendError(validationContext, msg, raveErrors);
        }
        return raveErrors;
    }

    private static List<RaveError> createStringDefError(@Nullable String value, String[] acceptableValues, ValidationContext validationContext) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (String string : acceptableValues) {
            if (!first) {
                stringBuilder.append(" ");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append(string);
            first = false;
        }
        stringBuilder.append("}");
        return BaseValidator.createNewList(new RaveError(validationContext, value + " " + "Does not conform to the following @StringDef values:" + stringBuilder.toString()));
    }

    private static List<RaveError> createIntDefError(int value, int[] acceptableValues, ValidationContext validationContext) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (int string : acceptableValues) {
            if (!first) {
                stringBuilder.append(" ");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append(string);
            first = false;
        }
        stringBuilder.append("}");
        return BaseValidator.createNewList(new RaveError(validationContext, value + " " + "Does not conform to the following @IntDef values:" + stringBuilder.toString()));
    }

    private static List<RaveError> createLongDefError(long value, long[] acceptableValues, ValidationContext validationContext) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (long string : acceptableValues) {
            if (!first) {
                stringBuilder.append(" ");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append(string);
            first = false;
        }
        stringBuilder.append("}");
        return BaseValidator.createNewList(new RaveError(validationContext, String.format("%s %s %s", value, "Does not conform to the following @LongDef values:", stringBuilder.toString())));
    }

    public static final class ValidationContext {
        private final Class<?> clazz;
        private String validatedItemName = "";

        private ValidationContext(Class<?> clazz) {
            this.clazz = clazz;
        }

        Class<?> getClazz() {
            return this.clazz;
        }

        String getValidatedItemName() {
            return this.validatedItemName;
        }

        public void setValidatedItemName(String item) {
            this.validatedItemName = item;
        }
    }
}

