/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave;

import com.uber.rave.BaseValidator;
import com.uber.rave.InvalidModelException;
import com.uber.rave.RaveError;
import com.uber.rave.RaveException;
import com.uber.rave.UnsupportedObjectException;
import com.uber.rave.ValidatorFactory;
import com.uber.rave.annotation.Validated;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class Rave {
    private static final int CLASS_VALIDATOR_DEFAULT_CACHE_SIZE = 100;
    private final Map<Class<?>, BaseValidator> classValidatorMap = new HashMap();
    private final UnAnnotatedModelValidator unannotatedModelValidator = new UnAnnotatedModelValidator(100);

    public static synchronized Rave getInstance() {
        return SingletonHolder.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Object object) throws RaveException {
        BaseValidator validator;
        Class<?> clazz = object.getClass();
        Validated validated = clazz.getAnnotation(Validated.class);
        Rave rave = this;
        synchronized (rave) {
            if (validated == null && !this.unannotatedModelValidator.hasSeen(clazz)) {
                this.unannotatedModelValidator.processNonAnnotatedClasses(clazz);
            }
            if ((validator = this.classValidatorMap.get(clazz)) == null) {
                validator = this.getValidatorInstance(clazz);
            }
            if (validator == null) {
                throw new UnsupportedObjectException(Collections.singletonList(new RaveError(clazz, "", "Is not supported by validation.")));
            }
        }
        validator.validate(object);
    }

    public void validateIgnoreUnsupported(Object object) throws InvalidModelException {
        try {
            this.validate(object);
        }
        catch (InvalidModelException e) {
            throw e;
        }
        catch (RaveException raveException) {
            // empty catch block
        }
    }

    synchronized void registerValidator(BaseValidator validator, Set<Class<?>> supportedModels) {
        for (Class<?> clazz : supportedModels) {
            BaseValidator base = this.classValidatorMap.put(clazz, validator);
            if (base == null) continue;
            throw new IllegalStateException("Two validators are validating the same model. " + base.getClass().getCanonicalName() + " and " + this.classValidatorMap.get(clazz).getClass().getCanonicalName() + " for class " + clazz.getCanonicalName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateAs(Object obj, Class<?> clazz) throws RaveException {
        BaseValidator base;
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("Trying to validate " + obj.getClass().getCanonicalName() + " as " + clazz.getCanonicalName());
        }
        Rave rave = this;
        synchronized (rave) {
            base = this.classValidatorMap.get(clazz);
            if (base == null) {
                base = this.getValidatorInstance(clazz);
            }
            if (base == null) {
                throw new UnsupportedObjectException(Collections.singletonList(new RaveError(obj.getClass(), "", "Is not supported by validation.")));
            }
        }
        base.validateAs(obj, clazz);
    }

    private void registerValidatorWithClass(BaseValidator validator, Class<?> supportedModel) {
        this.classValidatorMap.put(supportedModel, validator);
    }

    private void removeEntry(Class<?> supportedModel) {
        this.classValidatorMap.remove(supportedModel);
    }

    @Nullable
    private BaseValidator getValidatorInstance(Class<?> classToValidate) {
        Validated validated = classToValidate.getAnnotation(Validated.class);
        if (validated == null) {
            return null;
        }
        Class<? extends ValidatorFactory> validatorClazz = validated.factory();
        try {
            validatorClazz.newInstance().generateValidator();
            return this.classValidatorMap.get(classToValidate);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    static final class UnAnnotatedModelValidator
    extends BaseValidator {
        private final Map<Class<?>, Void> unsupportedClassesCache;
        private final Map<Class<?>, Set<Class<?>>> supportedClassesCache = new HashMap();

        UnAnnotatedModelValidator(final int cacheSize) {
            this.unsupportedClassesCache = new LinkedHashMap<Class<?>, Void>(){

                @Override
                public boolean removeEldestEntry(Map.Entry<Class<?>, Void> eldest) {
                    boolean returnValue;
                    boolean bl = returnValue = this.size() > cacheSize;
                    if (returnValue) {
                        Rave.getInstance().removeEntry(eldest.getKey());
                    }
                    return returnValue;
                }
            };
        }

        @Override
        protected void validateAs(Object object, Class<?> clazz) throws RaveException {
            if (this.unsupportedClassesCache.containsKey(clazz)) {
                throw new UnsupportedObjectException(Collections.singletonList(new RaveError(clazz, "", "Is not supported by validation.")));
            }
            Set<Class<?>> inheritanceSet = this.supportedClassesCache.get(clazz);
            if (inheritanceSet == null || inheritanceSet.isEmpty()) {
                throw new IllegalArgumentException(clazz.getCanonicalName() + ":" + "Is not supported by validation." + this.getClass().getCanonicalName());
            }
            List<RaveError> raveErrors = null;
            for (Class<?> parentClass : inheritanceSet) {
                raveErrors = UnAnnotatedModelValidator.mergeErrors(raveErrors, this.reEvaluateAsSuperType(parentClass, object));
            }
            if (raveErrors != null && !raveErrors.isEmpty()) {
                throw new InvalidModelException(raveErrors);
            }
        }

        void processNonAnnotatedClasses(Class<?> clazz) {
            Validated validated = clazz.getAnnotation(Validated.class);
            if (validated != null) {
                throw new IllegalArgumentException(clazz.getCanonicalName() + " is annotated with " + Validated.class.getCanonicalName());
            }
            if (!this.traverseClassHierarchy(clazz, clazz)) {
                this.unsupportedClassesCache.put(clazz, null);
            }
            this.addSupportedClass(clazz);
            Rave.getInstance().registerValidatorWithClass(this, clazz);
        }

        private boolean traverseClassHierarchy(Class<?> original, Class<?> classToCheck) {
            boolean returnValue = false;
            Class<?> parentClass = classToCheck.getSuperclass();
            if (parentClass != null) {
                returnValue = this.evaluateInheritance(original, parentClass);
            }
            for (Class<?> interfaces : classToCheck.getInterfaces()) {
                returnValue = this.evaluateInheritance(original, interfaces) || returnValue;
            }
            return returnValue;
        }

        private boolean evaluateInheritance(Class<?> original, Class<?> classToCheck) {
            Validated validated = classToCheck.getAnnotation(Validated.class);
            if (validated != null) {
                Set<Class<?>> set = this.supportedClassesCache.get(original);
                if (set == null) {
                    set = new HashSet();
                    this.supportedClassesCache.put(original, set);
                }
                set.add(classToCheck);
                return true;
            }
            return this.traverseClassHierarchy(original, classToCheck);
        }

        private boolean hasSeen(Class<?> clazz) {
            return this.supportedClassesCache.containsKey(clazz) || this.unsupportedClassesCache.containsKey(clazz);
        }
    }

    private static class SingletonHolder {
        private static final Rave INSTANCE = new Rave();

        private SingletonHolder() {
        }

        public static Rave getInstance() {
            return INSTANCE;
        }
    }
}

