/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rave;

import com.uber.rave.RaveError;
import java.util.HashSet;
import java.util.Set;

final class ValidationIgnore {
    private final Set<String> ignoreMethods = new HashSet<String>();
    private final Class<?> clazz;
    private boolean ignoreClassAll = false;

    ValidationIgnore(Class<?> clazz) {
        this.clazz = clazz;
    }

    public boolean shouldIgnore(RaveError error) {
        if (!error.getClazz().equals(this.clazz)) {
            return false;
        }
        return this.ignoreClassAll || this.ignoreMethods.contains(error.getClassElement());
    }

    boolean isIgnoreClassAll() {
        return this.ignoreClassAll;
    }

    Class<?> getClazz() {
        return this.clazz;
    }

    void setAsIgnoreClassAll() {
        this.ignoreClassAll = true;
    }

    boolean hasIgnoreMethods() {
        return !this.ignoreMethods.isEmpty();
    }

    void addMethod(String methodName) {
        this.ignoreMethods.add(methodName + "()");
        this.ignoreMethods.add(methodName);
    }

    boolean shouldIgnoreMethod(String methodName) {
        return this.ignoreClassAll || this.ignoreMethods.contains(methodName);
    }
}

