/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.jakewharton.rxrelay2.BehaviorRelay;
import com.jakewharton.rxrelay2.PublishRelay;
import com.jakewharton.rxrelay2.Relay;
import com.uber.autodispose.lifecycle.CorrespondingEventsFunction;
import com.uber.autodispose.lifecycle.LifecycleEndedException;
import com.uber.autodispose.lifecycle.LifecycleScopeProvider;
import com.uber.autodispose.lifecycle.LifecycleScopes;
import com.uber.rib.core.ActivityStarter;
import com.uber.rib.core.Bundle;
import com.uber.rib.core.CoreAppCompatActivity;
import com.uber.rib.core.Initializer;
import com.uber.rib.core.Interactor;
import com.uber.rib.core.RibEventType;
import com.uber.rib.core.RibEvents;
import com.uber.rib.core.RxActivityEvents;
import com.uber.rib.core.ViewRouter;
import com.uber.rib.core.lifecycle.ActivityCallbackEvent;
import com.uber.rib.core.lifecycle.ActivityLifecycleEvent;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;

public abstract class RibActivity
extends CoreAppCompatActivity
implements ActivityStarter,
LifecycleScopeProvider<ActivityLifecycleEvent>,
RxActivityEvents {
    private static final CorrespondingEventsFunction<ActivityLifecycleEvent> ACTIVITY_LIFECYCLE = lastEvent -> {
        switch (lastEvent.getType()) {
            case CREATE: {
                return ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.DESTROY);
            }
            case START: {
                return ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.STOP);
            }
            case RESUME: {
                return ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.PAUSE);
            }
            case USER_LEAVING: {
                return ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.DESTROY);
            }
            case PAUSE: {
                return ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.STOP);
            }
            case STOP: {
                return ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.DESTROY);
            }
            case DESTROY: {
                throw new LifecycleEndedException("Cannot bind to Activity lifecycle when outside of it.");
            }
        }
        throw new UnsupportedOperationException("Binding to " + lastEvent + " not yet implemented");
    };
    private ViewRouter<?, ?> router;
    private final BehaviorRelay<ActivityLifecycleEvent> lifecycleBehaviorRelay = BehaviorRelay.create();
    private final Relay<ActivityLifecycleEvent> lifecycleRelay = this.lifecycleBehaviorRelay.toSerialized();
    private final Relay<ActivityCallbackEvent> callbacksRelay = PublishRelay.create().toSerialized();

    @Override
    public Observable<ActivityLifecycleEvent> lifecycle() {
        return this.lifecycleRelay.hide();
    }

    @Override
    public Observable<ActivityCallbackEvent> callbacks() {
        return this.callbacksRelay.hide();
    }

    public CorrespondingEventsFunction<ActivityLifecycleEvent> correspondingEvents() {
        return ACTIVITY_LIFECYCLE;
    }

    @Nullable
    public ActivityLifecycleEvent peekLifecycle() {
        return (ActivityLifecycleEvent)this.lifecycleBehaviorRelay.getValue();
    }

    public CompletableSource requestScope() {
        return LifecycleScopes.resolveScopeFromLifecycle((LifecycleScopeProvider)this);
    }

    @Initializer
    @CallSuper
    protected void onCreate(@Nullable android.os.Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ViewGroup rootViewGroup = (ViewGroup)this.findViewById(0x1020002);
        this.lifecycleRelay.accept((Object)ActivityLifecycleEvent.createOnCreateEvent(savedInstanceState));
        this.router = this.createRouter(rootViewGroup);
        Bundle wrappedBundle = null;
        if (savedInstanceState != null) {
            wrappedBundle = new Bundle(savedInstanceState);
        }
        this.router.dispatchAttach(wrappedBundle);
        rootViewGroup.addView(this.router.getView());
        RibEvents.getInstance().emitEvent(RibEventType.ATTACHED, this.router, null);
    }

    @CallSuper
    protected void onSaveInstanceState(android.os.Bundle outState) {
        super.onSaveInstanceState(outState);
        this.callbacksRelay.accept((Object)ActivityCallbackEvent.createOnSaveInstanceStateEvent(outState));
        ((ViewRouter)((Object)Preconditions.checkNotNull(this.router))).saveInstanceState(new Bundle(outState));
    }

    @CallSuper
    protected void onStart() {
        super.onStart();
        this.lifecycleRelay.accept((Object)ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.START));
    }

    @CallSuper
    protected void onResume() {
        super.onResume();
        this.lifecycleRelay.accept((Object)ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.RESUME));
    }

    @CallSuper
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.callbacksRelay.accept((Object)ActivityCallbackEvent.createNewIntent(intent));
    }

    @CallSuper
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.callbacksRelay.accept((Object)ActivityCallbackEvent.createOnActivityResultEvent(requestCode, resultCode, data));
    }

    @CallSuper
    protected void onPause() {
        this.lifecycleRelay.accept((Object)ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.PAUSE));
        super.onPause();
    }

    @CallSuper
    protected void onStop() {
        this.lifecycleRelay.accept((Object)ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.STOP));
        super.onStop();
    }

    @CallSuper
    protected void onDestroy() {
        if (this.lifecycleRelay != null) {
            this.lifecycleRelay.accept((Object)ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.DESTROY));
        }
        if (this.router != null) {
            this.router.dispatchDetach();
            RibEvents.getInstance().emitEvent(RibEventType.DETACHED, this.router, null);
        }
        this.router = null;
        super.onDestroy();
    }

    @CallSuper
    public void onLowMemory() {
        super.onLowMemory();
        this.callbacksRelay.accept((Object)ActivityCallbackEvent.create(ActivityCallbackEvent.Type.LOW_MEMORY));
    }

    @CallSuper
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.callbacksRelay.accept((Object)ActivityCallbackEvent.createTrimMemoryEvent(level));
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode, Configuration newConfig) {
        this.callbacksRelay.accept((Object)ActivityCallbackEvent.createPictureInPictureMode(isInPictureInPictureMode));
    }

    public void onBackPressed() {
        if (this.router != null && !this.router.handleBackPress()) {
            this.onUnhandledBackPressed();
            if (Build.VERSION.SDK_INT >= 29 && this.isTaskRoot() && this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
                super.finishAfterTransition();
            } else {
                super.onBackPressed();
            }
        }
    }

    protected void onUserLeaveHint() {
        this.lifecycleRelay.accept((Object)ActivityLifecycleEvent.create(ActivityLifecycleEvent.Type.USER_LEAVING));
        super.onUserLeaveHint();
    }

    protected void onUnhandledBackPressed() {
    }

    protected Interactor getInteractor() {
        if (this.router != null) {
            return this.router.getInteractor();
        }
        throw new IllegalStateException("Attempting to get a router when activity is not created or has been destroyed.");
    }

    protected abstract ViewRouter<?, ?> createRouter(ViewGroup var1);
}

