/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.Nullable;
import com.uber.rib.core.ViewRouter;

public final class XRay {
    private static final XRay INSTANCE = new XRay();
    private static final int FRAME_WIDTH = 500;
    private static final int FRAME_HEIGHT = 150;
    private static final float XRAY_ALFA = 0.9f;
    private static final int TEXT_SIZE = 30;
    private static final int TEXT_COLOR = -65536;
    private boolean isEnabled = false;
    @Nullable
    private Paint textPaint;

    private XRay() {
    }

    public static void toggle() {
        XRay.INSTANCE.isEnabled = !XRay.INSTANCE.isEnabled;
    }

    public static boolean isEnabled() {
        return XRay.INSTANCE.isEnabled;
    }

    static void apply(ViewRouter viewRouter, View view) {
        Drawable oldBackground = view.getBackground();
        Bitmap bitmap = oldBackground != null ? XRay.drawableToBitmap(oldBackground) : Bitmap.createBitmap((int)500, (int)150, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        INSTANCE.writeOnBitmap(bitmap, XRay.getRibletName(viewRouter));
        BitmapDrawable newBackground = new BitmapDrawable(view.getContext().getResources(), bitmap);
        newBackground.setGravity(17);
        view.setBackground((Drawable)newBackground);
        view.setAlpha(0.9f);
    }

    private static Bitmap drawableToBitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)500, (int)150, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.draw(canvas);
        return bitmap;
    }

    private static String getRibletName(ViewRouter viewRouter) {
        return ((Object)((Object)viewRouter)).getClass().getSimpleName().replace("Router", "");
    }

    private void writeOnBitmap(Bitmap bitmap, String text) {
        Canvas canvas = new Canvas(bitmap);
        Paint textPaint = this.getTextPaint();
        float xStartPoint = ((float)bitmap.getWidth() - textPaint.measureText(text)) / 2.0f;
        float yStartPoint = (float)bitmap.getHeight() / 2.0f;
        canvas.drawText(text, xStartPoint, yStartPoint, textPaint);
    }

    private Paint getTextPaint() {
        if (this.textPaint == null) {
            this.textPaint = new Paint();
            this.textPaint.setTextSize(30.0f);
            this.textPaint.setColor(-65536);
        }
        return this.textPaint;
    }
}

