/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import android.os.Parcelable;
import androidx.annotation.Nullable;

public class Bundle {
    private final android.os.Bundle androidBundle;

    public Bundle() {
        this(null);
    }

    public Bundle(@Nullable android.os.Bundle androidBundle) {
        this.androidBundle = androidBundle == null ? new android.os.Bundle() : androidBundle;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.androidBundle.getBoolean(key, defaultValue);
    }

    public void putBoolean(String key, boolean value) {
        this.androidBundle.putBoolean(key, value);
    }

    @Nullable
    public Bundle getBundleExtra(String key) {
        Parcelable value = this.androidBundle.getParcelable(key);
        if (value != null) {
            return new Bundle((android.os.Bundle)value);
        }
        return null;
    }

    public void putBundleExtra(String key, @Nullable Bundle bundle) {
        if (bundle != null) {
            this.androidBundle.putParcelable(key, (Parcelable)bundle.getWrappedBundle());
        } else {
            this.androidBundle.putParcelable(key, null);
        }
    }

    @Nullable
    public Parcelable getParcelable(String key) {
        return this.androidBundle.getParcelable(key);
    }

    public void putParcelable(String key, @Nullable Parcelable value) {
        this.androidBundle.putParcelable(key, value);
    }

    @Nullable
    public String getString(String key) {
        return this.androidBundle.getString(key);
    }

    public void putString(String key, @Nullable String value) {
        this.androidBundle.putString(key, value);
    }

    public void putInt(String key, int value) {
        this.androidBundle.putInt(key, value);
    }

    public int getInt(String key, int defaultValue) {
        return this.androidBundle.getInt(key, defaultValue);
    }

    android.os.Bundle getWrappedBundle() {
        return this.androidBundle;
    }
}

