/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.jakewharton.rxrelay2.BehaviorRelay;
import com.jakewharton.rxrelay2.Relay;
import com.uber.autodispose.lifecycle.CorrespondingEventsFunction;
import com.uber.autodispose.lifecycle.LifecycleEndedException;
import com.uber.autodispose.lifecycle.LifecycleScopeProvider;
import com.uber.autodispose.lifecycle.LifecycleScopes;
import com.uber.rib.core.Bundle;
import com.uber.rib.core.Presenter;
import com.uber.rib.core.Router;
import com.uber.rib.core.lifecycle.InteractorEvent;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import javax.inject.Inject;

public abstract class Interactor<P, R extends Router>
implements LifecycleScopeProvider<InteractorEvent> {
    private static final CorrespondingEventsFunction<InteractorEvent> LIFECYCLE_MAP_FUNCTION = interactorEvent -> {
        switch (interactorEvent) {
            case ACTIVE: {
                return InteractorEvent.INACTIVE;
            }
        }
        throw new LifecycleEndedException();
    };
    @Inject
    P presenter;
    private final BehaviorRelay<InteractorEvent> behaviorRelay = BehaviorRelay.create();
    private final Relay<InteractorEvent> lifecycleRelay = this.behaviorRelay.toSerialized();
    @Nullable
    private R router;

    public Interactor() {
    }

    protected Interactor(P presenter) {
        this.presenter = presenter;
    }

    public R getRouter() {
        if (this.router == null) {
            throw new IllegalStateException("Attempting to get interactor's router before being set.");
        }
        return this.router;
    }

    public Observable<InteractorEvent> lifecycle() {
        return this.lifecycleRelay.hide();
    }

    public boolean isAttached() {
        return this.behaviorRelay.getValue() == InteractorEvent.ACTIVE;
    }

    @CallSuper
    protected void didBecomeActive(@Nullable Bundle savedInstanceState) {
    }

    public boolean handleBackPress() {
        return false;
    }

    protected void willResignActive() {
    }

    protected void onSaveInstanceState(Bundle outState) {
    }

    protected void dispatchAttach(@Nullable Bundle savedInstanceState) {
        this.lifecycleRelay.accept((Object)InteractorEvent.ACTIVE);
        if (this.getPresenter() instanceof Presenter) {
            Presenter presenter = (Presenter)this.getPresenter();
            presenter.dispatchLoad();
        }
        this.didBecomeActive(savedInstanceState);
    }

    protected P dispatchDetach() {
        if (this.getPresenter() instanceof Presenter) {
            Presenter presenter = (Presenter)this.getPresenter();
            presenter.dispatchUnload();
        }
        this.willResignActive();
        this.lifecycleRelay.accept((Object)InteractorEvent.INACTIVE);
        return this.getPresenter();
    }

    protected void setRouter(R router) {
        if (this.router != null) {
            throw new IllegalStateException("Attempting to set interactor's router after it has been set.");
        }
        this.router = router;
    }

    @VisibleForTesting
    private P getPresenter() {
        if (this.presenter == null) {
            throw new IllegalStateException("Attempting to get interactor's presenter before being set.");
        }
        return this.presenter;
    }

    public CorrespondingEventsFunction<InteractorEvent> correspondingEvents() {
        return LIFECYCLE_MAP_FUNCTION;
    }

    public InteractorEvent peekLifecycle() {
        return (InteractorEvent)((Object)this.behaviorRelay.getValue());
    }

    public final CompletableSource requestScope() {
        return LifecycleScopes.resolveScopeFromLifecycle((LifecycleScopeProvider)this);
    }
}

