/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import androidx.annotation.CallSuper;
import com.jakewharton.rxrelay2.BehaviorRelay;
import com.jakewharton.rxrelay2.Relay;
import com.uber.autodispose.ScopeProvider;
import com.uber.rib.core.lifecycle.PresenterEvent;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import org.checkerframework.checker.guieffect.qual.UIEffect;

public abstract class Presenter
implements ScopeProvider {
    private final BehaviorRelay<PresenterEvent> behaviorRelay = BehaviorRelay.create();
    private final Relay<PresenterEvent> lifecycleRelay = this.behaviorRelay.toSerialized();
    private boolean isLoaded = false;

    protected void dispatchLoad() {
        this.isLoaded = true;
        this.lifecycleRelay.accept((Object)PresenterEvent.LOADED);
        this.didLoad();
    }

    protected void dispatchUnload() {
        this.isLoaded = false;
        this.willUnload();
        this.lifecycleRelay.accept((Object)PresenterEvent.UNLOADED);
    }

    protected boolean isLoaded() {
        return this.isLoaded;
    }

    @CallSuper
    protected void didLoad() {
    }

    @UIEffect
    @CallSuper
    protected void willUnload() {
    }

    public Observable<PresenterEvent> lifecycle() {
        return this.lifecycleRelay.hide();
    }

    public CompletableSource requestScope() {
        return this.lifecycleRelay.skip(1L).firstElement().ignoreElement();
    }
}

