/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import androidx.annotation.Nullable;

public class Rib {
    @Nullable
    private static Configuration configuration = null;

    private Rib() {
    }

    public static void setConfiguration(Configuration configurationToSet) {
        if (configuration != null) {
            if (configuration instanceof DefaultConfiguration) {
                throw new IllegalStateException("Attempting to set a configuration after using RIB code.");
            }
            throw new IllegalStateException("Attempting to set a configuration after one has previously been set.");
        }
        configuration = configurationToSet;
    }

    static Configuration getConfiguration() {
        if (configuration == null) {
            configuration = new DefaultConfiguration();
        }
        return configuration;
    }

    private static class DefaultConfiguration
    implements Configuration {
        private DefaultConfiguration() {
        }

        @Override
        public void handleNonFatalError(String errorMessage, @Nullable Throwable throwable) {
            throw new RuntimeException(errorMessage, throwable);
        }

        @Override
        public void handleNonFatalWarning(String warningMessage, @Nullable Throwable throwable) {
        }

        @Override
        public void handleDebugMessage(String format, Object ... args) {
        }
    }

    public static interface Configuration {
        public void handleNonFatalError(String var1, @Nullable Throwable var2);

        public void handleNonFatalWarning(String var1, @Nullable Throwable var2);

        public void handleDebugMessage(String var1, Object ... var2);
    }
}

