/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import androidx.annotation.MainThread;
import androidx.annotation.Nullable;

@MainThread
public class RibRefWatcher {
    @Nullable
    private static RibRefWatcher instance;
    private static boolean leakCanaryEnabled;
    private static boolean uLeakEnabled;
    private static boolean breadcrumbsEnabled;
    @Nullable
    private ReferenceWatcher referenceWatcher;

    public static RibRefWatcher getInstance() {
        if (instance == null) {
            instance = new RibRefWatcher();
        }
        return instance;
    }

    public void setReferenceWatcher(@Nullable ReferenceWatcher watcher) {
        this.referenceWatcher = watcher;
    }

    public void watchDeletedObject(@Nullable Object object) {
        if (object == null) {
            return;
        }
        if (this.referenceWatcher != null && (leakCanaryEnabled || uLeakEnabled)) {
            this.referenceWatcher.watch(object);
        }
    }

    void logBreadcrumb(String eventType, @Nullable String child, @Nullable String parent) {
        if (this.referenceWatcher != null && breadcrumbsEnabled) {
            if (child == null || parent == null) {
                this.referenceWatcher.logBreadcrumb(eventType, eventType, eventType);
            } else {
                this.referenceWatcher.logBreadcrumb(eventType, child, parent);
            }
        }
    }

    public void enableBreadcrumbLogging() {
        breadcrumbsEnabled = true;
    }

    public void enableLeakCanary() {
        leakCanaryEnabled = true;
    }

    public void disableLeakCanary() {
        leakCanaryEnabled = false;
    }

    public static boolean isLeakCanaryEnabled() {
        return leakCanaryEnabled;
    }

    public void enableULeakLifecycleTracking() {
        uLeakEnabled = true;
    }

    public void disableULeakLifecycleTracking() {
        uLeakEnabled = false;
    }

    static {
        leakCanaryEnabled = false;
        uLeakEnabled = false;
        breadcrumbsEnabled = false;
    }

    public static interface ReferenceWatcher {
        public void watch(Object var1);

        public void logBreadcrumb(String var1, String var2, String var3);
    }
}

