/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import android.os.Looper;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.uber.rib.core.Bundle;
import com.uber.rib.core.Initializer;
import com.uber.rib.core.Interactor;
import com.uber.rib.core.InteractorBaseComponent;
import com.uber.rib.core.Rib;
import com.uber.rib.core.RibEventType;
import com.uber.rib.core.RibEvents;
import com.uber.rib.core.RibRefWatcher;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Router<I extends Interactor> {
    @VisibleForTesting
    static final String KEY_CHILD_ROUTERS = "Router.childRouters";
    @VisibleForTesting
    static final String KEY_INTERACTOR = "Router.interactor";
    private final List<Router> children = new CopyOnWriteArrayList<Router>();
    private final I interactor;
    private final Thread mainThread;
    private final RibRefWatcher ribRefWatcher;
    private String tag;
    @Nullable
    private Bundle savedInstanceState;
    private boolean isLoaded;

    protected Router(I interactor, @Nullable InteractorBaseComponent component) {
        this(component, interactor, RibRefWatcher.getInstance(), Router.getMainThread());
    }

    protected Router(I interactor) {
        this(null, interactor, RibRefWatcher.getInstance(), Router.getMainThread());
    }

    protected Router(@Nullable InteractorBaseComponent component, I interactor, RibRefWatcher ribRefWatcher, Thread mainThread) {
        this.interactor = interactor;
        this.ribRefWatcher = ribRefWatcher;
        this.mainThread = mainThread;
        this.inject(component);
        this.attachToInteractor();
    }

    protected void inject(@Nullable InteractorBaseComponent component) {
        if (component != null) {
            component.inject(this.interactor);
        }
    }

    protected void attachToInteractor() {
        ((Interactor)this.interactor).setRouter((Router)this);
    }

    public I getInteractor() {
        return this.interactor;
    }

    public boolean handleBackPress() {
        this.ribRefWatcher.logBreadcrumb("BACKPRESS", null, null);
        return ((Interactor)this.getInteractor()).handleBackPress();
    }

    @Initializer
    protected void didLoad() {
    }

    protected void willAttach() {
    }

    protected void willDetach() {
    }

    @MainThread
    protected void attachChild(Router<?> childRouter) {
        this.attachChild(childRouter, childRouter.getClass().getName());
    }

    @MainThread
    protected void attachChild(Router<?> childRouter, String tag) {
        for (Router child : this.children) {
            if (!tag.equals(child.tag)) continue;
            Rib.getConfiguration().handleNonFatalWarning(String.format(Locale.getDefault(), "There is already a child router with tag: %s", tag), null);
        }
        this.children.add(childRouter);
        this.ribRefWatcher.logBreadcrumb("ATTACHED", childRouter.getClass().getSimpleName(), this.getClass().getSimpleName());
        RibEvents.getInstance().emitEvent(RibEventType.ATTACHED, childRouter, this);
        Bundle childBundle = null;
        if (this.savedInstanceState != null) {
            Bundle previousChildren = (Bundle)Preconditions.checkNotNull((Object)this.savedInstanceState.getBundleExtra(KEY_CHILD_ROUTERS));
            childBundle = previousChildren.getBundleExtra(tag);
        }
        childRouter.dispatchAttach(childBundle, tag);
    }

    @MainThread
    protected void detachChild(Router childRouter) {
        boolean isChildRemoved = this.children.remove(childRouter);
        I interactor = childRouter.getInteractor();
        this.ribRefWatcher.watchDeletedObject(interactor);
        this.ribRefWatcher.logBreadcrumb("DETACHED", childRouter.getClass().getSimpleName(), this.getClass().getSimpleName());
        if (this.savedInstanceState != null) {
            Bundle childrenBundles = (Bundle)Preconditions.checkNotNull((Object)this.savedInstanceState.getBundleExtra(KEY_CHILD_ROUTERS));
            childrenBundles.putBundleExtra(childRouter.tag, null);
        }
        childRouter.dispatchDetach();
        if (isChildRemoved) {
            RibEvents.getInstance().emitEvent(RibEventType.DETACHED, childRouter, this);
        }
    }

    @CallSuper
    protected void dispatchAttach(@Nullable Bundle savedInstanceState) {
        this.dispatchAttach(savedInstanceState, this.getClass().getName());
    }

    @CallSuper
    @Initializer
    protected void dispatchAttach(@Nullable Bundle savedInstanceState, String tag) {
        this.checkForMainThread();
        if (!this.isLoaded) {
            this.isLoaded = true;
            this.didLoad();
        }
        this.savedInstanceState = savedInstanceState;
        this.tag = tag;
        this.willAttach();
        Bundle interactorBundle = null;
        if (this.savedInstanceState != null) {
            interactorBundle = this.savedInstanceState.getBundleExtra(KEY_INTERACTOR);
        }
        ((Interactor)this.getInteractor()).dispatchAttach(interactorBundle);
    }

    protected void dispatchDetach() {
        this.checkForMainThread();
        ((Interactor)this.getInteractor()).dispatchDetach();
        this.willDetach();
        for (Router child : this.children) {
            this.detachChild(child);
        }
    }

    List<Router> getChildren() {
        return this.children;
    }

    String getTag() {
        return this.tag;
    }

    void saveInstanceState(Bundle outState) {
        Bundle interactorSavedInstanceState = new Bundle();
        ((Interactor)this.getInteractor()).onSaveInstanceState(interactorSavedInstanceState);
        outState.putBundleExtra(KEY_INTERACTOR, interactorSavedInstanceState);
        Bundle childBundles = new Bundle();
        for (Router child : this.children) {
            Bundle childBundle = new Bundle();
            child.saveInstanceState(childBundle);
            childBundles.putBundleExtra(child.tag, childBundle);
        }
        outState.putBundleExtra(KEY_CHILD_ROUTERS, childBundles);
    }

    private void checkForMainThread() {
        if (this.mainThread != Thread.currentThread()) {
            String errorMessage = "Call must happen on the main thread";
            IllegalStateException exception = new IllegalStateException(errorMessage);
            Rib.getConfiguration().handleNonFatalError(errorMessage, exception);
        }
    }

    static Thread getMainThread() {
        try {
            return Looper.getMainLooper().getThread();
        }
        catch (Exception e) {
            return Thread.currentThread();
        }
    }
}

