/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import androidx.annotation.VisibleForTesting;
import com.jakewharton.rxrelay2.PublishRelay;
import com.uber.autodispose.lifecycle.LifecycleScopeProvider;
import com.uber.rib.core.Interactor;
import com.uber.rib.core.Presenter;
import com.uber.rib.core.Worker;
import com.uber.rib.core.WorkerScopeProvider;
import com.uber.rib.core.WorkerUnbinder;
import com.uber.rib.core.lifecycle.InteractorEvent;
import com.uber.rib.core.lifecycle.PresenterEvent;
import com.uber.rib.core.lifecycle.WorkerEvent;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.util.List;

public final class WorkerBinder {
    private WorkerBinder() {
    }

    public static WorkerUnbinder bind(Interactor<?, ?> interactor, Worker worker) {
        return WorkerBinder.bind(WorkerBinder.mapInteractorLifecycleToWorker(interactor.lifecycle()), worker);
    }

    public static void bind(Interactor interactor, List<? extends Worker> workers) {
        for (Worker worker : workers) {
            WorkerBinder.bind(interactor, worker);
        }
    }

    public static WorkerUnbinder bind(Presenter presenter, Worker worker) {
        return WorkerBinder.bind(WorkerBinder.mapPresenterLifecycleToWorker(presenter.lifecycle()), worker);
    }

    public static void bind(Presenter presenter, List<? extends Worker> workers) {
        for (Worker worker : workers) {
            WorkerBinder.bind(presenter, worker);
        }
    }

    @VisibleForTesting
    static WorkerUnbinder bind(Observable<WorkerEvent> mappedLifecycle, Worker worker) {
        PublishRelay unbindSubject = PublishRelay.create();
        Observable workerLifecycle = mappedLifecycle.mergeWith((ObservableSource)unbindSubject).takeUntil(workerEvent -> workerEvent == WorkerEvent.STOP);
        WorkerBinder.bindToWorkerLifecycle((Observable<WorkerEvent>)workerLifecycle, worker);
        return () -> unbindSubject.accept((Object)WorkerEvent.STOP);
    }

    static Observable<WorkerEvent> mapInteractorLifecycleToWorker(Observable<InteractorEvent> interactorEventObservable) {
        return interactorEventObservable.map(interactorEvent -> {
            switch (interactorEvent) {
                case ACTIVE: {
                    return WorkerEvent.START;
                }
            }
            return WorkerEvent.STOP;
        });
    }

    static Observable<WorkerEvent> mapPresenterLifecycleToWorker(Observable<PresenterEvent> presenterEventObservable) {
        return presenterEventObservable.map(presenterEvent -> {
            switch (presenterEvent) {
                case LOADED: {
                    return WorkerEvent.START;
                }
            }
            return WorkerEvent.STOP;
        });
    }

    @Deprecated
    public static void bindTo(LifecycleScopeProvider<InteractorEvent> lifecycle, Worker worker) {
        WorkerBinder.bind(WorkerBinder.mapInteractorLifecycleToWorker((Observable<InteractorEvent>)lifecycle.lifecycle()), worker);
    }

    public static void bindToWorkerLifecycle(Observable<WorkerEvent> workerLifecycle, Worker worker) {
        workerLifecycle.subscribe(workerEvent -> {
            switch (workerEvent) {
                case START: {
                    worker.onStart(new WorkerScopeProvider((Observable<WorkerEvent>)workerLifecycle.hide()));
                    break;
                }
                default: {
                    worker.onStop();
                }
            }
        });
    }
}

