/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core.screenstack;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import com.jakewharton.rxrelay2.BehaviorRelay;
import com.jakewharton.rxrelay2.Relay;
import com.uber.rib.core.screenstack.lifecycle.ScreenStackEvent;
import io.reactivex.Observable;

public abstract class ViewProvider {
    private final Relay<ScreenStackEvent> lifecycleRelay = BehaviorRelay.create().toSerialized();

    View buildViewInternal(ViewGroup parentView) {
        this.lifecycleRelay.accept((Object)ScreenStackEvent.BUILT);
        return this.buildView(parentView);
    }

    public abstract View buildView(ViewGroup var1);

    public Observable<ScreenStackEvent> lifecycle() {
        return this.lifecycleRelay.hide();
    }

    protected void doOnViewRemoved() {
    }

    public final void onViewRemoved() {
        this.lifecycleRelay.accept((Object)ScreenStackEvent.REMOVED);
        this.doOnViewRemoved();
    }

    public boolean onBackPress() {
        return false;
    }

    @CallSuper
    public void onViewAppeared() {
        this.lifecycleRelay.accept((Object)ScreenStackEvent.APPEARED);
    }

    @CallSuper
    public void onViewHidden() {
        this.lifecycleRelay.accept((Object)ScreenStackEvent.HIDDEN);
    }
}

